/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11.provider;

import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.ws.wsdl.WsdlDefinitionException;
import org.springframework.ws.wsdl.wsdl11.provider.TypesProvider;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InliningXsdSchemaTypesProvider
extends TransformerObjectSupport
implements TypesProvider {
    private static final Log logger = LogFactory.getLog(InliningXsdSchemaTypesProvider.class);
    public static final String SCHEMA_PREFIX = "sch";
    private XsdSchemaCollection schemaCollection;

    public void setSchema(final XsdSchema schema) {
        this.schemaCollection = new XsdSchemaCollection(){

            @Override
            public XsdSchema[] getXsdSchemas() {
                return new XsdSchema[]{schema};
            }

            @Override
            public XmlValidator createValidator() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public XsdSchemaCollection getSchemaCollection() {
        return this.schemaCollection;
    }

    public void setSchemaCollection(XsdSchemaCollection schemaCollection) {
        this.schemaCollection = schemaCollection;
    }

    @Override
    public void addTypes(Definition definition) throws WSDLException {
        Assert.notNull((Object)this.getSchemaCollection(), (String)"setting 'schema' or 'schemaCollection' is required");
        Types types = definition.createTypes();
        XsdSchema[] schemas = this.schemaCollection.getXsdSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug("Inlining " + schemas[i]);
            }
            if (schemas.length == 1) {
                definition.addNamespace(SCHEMA_PREFIX, schemas[i].getTargetNamespace());
            } else {
                String prefix = SCHEMA_PREFIX + i;
                definition.addNamespace(prefix, schemas[i].getTargetNamespace());
            }
            Element schemaElement = this.getSchemaElement(schemas[i]);
            Schema schema = (Schema)definition.getExtensionRegistry().createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            types.addExtensibilityElement((ExtensibilityElement)schema);
            schema.setElement(schemaElement);
        }
        definition.setTypes(types);
    }

    private Element getSchemaElement(XsdSchema schema) {
        try {
            DOMResult result = new DOMResult();
            this.transform(schema.getSource(), result);
            Document schemaDocument = (Document)result.getNode();
            return schemaDocument.getDocumentElement();
        }
        catch (TransformerException e) {
            throw new WsdlDefinitionException("Could not transform schema source to Document");
        }
    }
}

