/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.filter.impl;

import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;

public class HeaderTransformationMessageFilter
implements MessageFilter {
    private static final String SOAP_HEADER_TRANSFORMATION_PROBLEM = "Soap header transformation problem";
    private static final Logger LOG = LoggerFactory.getLogger(HeaderTransformationMessageFilter.class);
    private String xslt;
    private boolean saxon;

    public HeaderTransformationMessageFilter(String xslt) {
        this.xslt = xslt;
    }

    @Override
    public void filterProducer(Exchange exchange2, WebServiceMessage webServiceMessage) {
        if (exchange2 != null) {
            this.processHeader(exchange2.getContext(), exchange2.getIn(), webServiceMessage);
        }
    }

    @Override
    public void filterConsumer(Exchange exchange2, WebServiceMessage webServiceMessage) {
        if (exchange2 != null) {
            Message responseMessage = exchange2.hasOut() ? exchange2.getOut() : exchange2.getIn();
            this.processHeader(exchange2.getContext(), responseMessage, webServiceMessage);
        }
    }

    private void processHeader(CamelContext context, Message inOrOut, WebServiceMessage webServiceMessage) {
        if (webServiceMessage instanceof SoapMessage) {
            SoapMessage soapMessage = (SoapMessage)webServiceMessage;
            try {
                XsltUriResolver resolver = new XsltUriResolver(context, this.xslt);
                Source stylesheetResource = resolver.resolve(this.xslt, null);
                TransformerFactory transformerFactory = this.getTransformerFactory(context);
                Transformer transformer = transformerFactory.newTransformer(stylesheetResource);
                this.addParameters(inOrOut, transformer);
                transformer.transform(soapMessage.getSoapHeader().getSource(), soapMessage.getSoapHeader().getResult());
            }
            catch (TransformerException e) {
                throw new RuntimeException("Cannot transform the header of the soap message", e);
            }
        }
    }

    private void addParameters(Message inOrOut, Transformer transformer) {
        Map headers = inOrOut.getHeaders();
        for (Map.Entry headerEntry : headers.entrySet()) {
            String key = (String)headerEntry.getKey();
            if (key == null || key.startsWith("$")) continue;
            transformer.setParameter(key, String.valueOf(headerEntry.getValue()));
        }
    }

    private TransformerFactory getTransformerFactory(CamelContext context) {
        TransformerFactory transformerFactory = null;
        transformerFactory = this.saxon ? this.getSaxonTransformerFactory(context) : TransformerFactory.newInstance();
        if (transformerFactory == null) {
            throw new IllegalStateException("Cannot resolve a transformer factory");
        }
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
        transformerFactory.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) throws TransformerException {
                LOG.warn(HeaderTransformationMessageFilter.SOAP_HEADER_TRANSFORMATION_PROBLEM, (Throwable)exception);
            }

            @Override
            public void fatalError(TransformerException exception) throws TransformerException {
                LOG.error(HeaderTransformationMessageFilter.SOAP_HEADER_TRANSFORMATION_PROBLEM, (Throwable)exception);
            }

            @Override
            public void error(TransformerException exception) throws TransformerException {
                LOG.error(HeaderTransformationMessageFilter.SOAP_HEADER_TRANSFORMATION_PROBLEM, (Throwable)exception);
            }
        });
        return transformerFactory;
    }

    private TransformerFactory getSaxonTransformerFactory(CamelContext context) {
        ClassResolver resolver = context.getClassResolver();
        try {
            Class factoryClass = resolver.resolveMandatoryClass("net.sf.saxon.TransformerFactoryImpl", TransformerFactory.class, XsltComponent.class.getClassLoader());
            if (factoryClass != null) {
                return (TransformerFactory)ObjectHelper.newInstance((Class)factoryClass);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load the saxon transformer class", e);
        }
        return null;
    }

    public String getXslt() {
        return this.xslt;
    }

    public void setXslt(String xslt) {
        this.xslt = xslt;
    }

    public boolean isSaxon() {
        return this.saxon;
    }

    public void setSaxon(boolean saxon) {
        this.saxon = saxon;
    }
}

