/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.adapter.method;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.namespace.QNameUtils;

public class SoapHeaderElementMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type genericType;
        org.springframework.ws.soap.server.endpoint.annotation.SoapHeader soapHeader = (org.springframework.ws.soap.server.endpoint.annotation.SoapHeader)parameter.getParameterAnnotation(org.springframework.ws.soap.server.endpoint.annotation.SoapHeader.class);
        if (soapHeader == null) {
            return false;
        }
        Class parameterType = parameter.getParameterType();
        if (SoapHeaderElement.class.equals((Object)parameterType)) {
            return true;
        }
        return List.class.equals((Object)parameterType) && (genericType = parameter.getGenericParameterType()) instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && SoapHeaderElement.class.equals((Object)typeArguments[0]);
    }

    @Override
    public Object resolveArgument(MessageContext messageContext, MethodParameter parameter) throws Exception {
        Assert.isInstanceOf(SoapMessage.class, (Object)messageContext.getRequest());
        SoapMessage request = (SoapMessage)messageContext.getRequest();
        SoapHeader soapHeader = request.getSoapHeader();
        String paramValue = ((org.springframework.ws.soap.server.endpoint.annotation.SoapHeader)parameter.getParameterAnnotation(org.springframework.ws.soap.server.endpoint.annotation.SoapHeader.class)).value();
        Assert.isTrue((boolean)QNameUtils.validateQName(paramValue), (String)("Invalid header qualified name [" + paramValue + "]. QName must be of the form '{namespace}localPart'."));
        QName qname = QName.valueOf(paramValue);
        Class parameterType = parameter.getParameterType();
        if (SoapHeaderElement.class.equals((Object)parameterType)) {
            return this.extractSoapHeader(qname, soapHeader);
        }
        if (List.class.equals((Object)parameterType)) {
            return this.extractSoapHeaderList(qname, soapHeader);
        }
        throw new UnsupportedOperationException();
    }

    private SoapHeaderElement extractSoapHeader(QName qname, SoapHeader soapHeader) {
        Iterator<SoapHeaderElement> elements = soapHeader.examineAllHeaderElements();
        while (elements.hasNext()) {
            SoapHeaderElement e = elements.next();
            if (!e.getName().equals(qname)) continue;
            return e;
        }
        return null;
    }

    private List<SoapHeaderElement> extractSoapHeaderList(QName qname, SoapHeader soapHeader) {
        ArrayList<SoapHeaderElement> result = new ArrayList<SoapHeaderElement>();
        Iterator<SoapHeaderElement> elements = soapHeader.examineAllHeaderElements();
        while (elements.hasNext()) {
            SoapHeaderElement e = elements.next();
            if (!e.getName().equals(qname)) continue;
            result.add(e);
        }
        return result;
    }
}

