/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.support.DefaultStrategiesHelper;
import org.springframework.ws.support.WebUtils;
import org.springframework.ws.transport.WebServiceMessageReceiver;
import org.springframework.ws.transport.http.WebServiceMessageReceiverHandlerAdapter;
import org.springframework.ws.transport.http.WsdlDefinitionHandlerAdapter;
import org.springframework.ws.transport.http.XsdSchemaHandlerAdapter;
import org.springframework.ws.wsdl.WsdlDefinition;
import org.springframework.xml.xsd.XsdSchema;

public class MessageDispatcherServlet
extends FrameworkServlet {
    public static final String DEFAULT_MESSAGE_FACTORY_BEAN_NAME = "messageFactory";
    public static final String DEFAULT_MESSAGE_RECEIVER_BEAN_NAME = "messageReceiver";
    public static final String DEFAULT_MESSAGE_RECEIVER_HANDLER_ADAPTER_BEAN_NAME = "messageReceiverHandlerAdapter";
    public static final String DEFAULT_WSDL_DEFINITION_HANDLER_ADAPTER_BEAN_NAME = "wsdlDefinitionHandlerAdapter";
    public static final String DEFAULT_XSD_SCHEMA_HANDLER_ADAPTER_BEAN_NAME = "xsdSchemaHandlerAdapter";
    private static final String WSDL_SUFFIX_NAME = ".wsdl";
    private static final String XSD_SUFFIX_NAME = ".xsd";
    private final DefaultStrategiesHelper defaultStrategiesHelper = new DefaultStrategiesHelper(MessageDispatcherServlet.class);
    private String messageFactoryBeanName = "messageFactory";
    private String messageReceiverHandlerAdapterBeanName = "messageReceiverHandlerAdapter";
    private WebServiceMessageReceiverHandlerAdapter messageReceiverHandlerAdapter;
    private String wsdlDefinitionHandlerAdapterBeanName = "wsdlDefinitionHandlerAdapter";
    private WsdlDefinitionHandlerAdapter wsdlDefinitionHandlerAdapter;
    private String xsdSchemaHandlerAdapterBeanName = "xsdSchemaHandlerAdapter";
    private XsdSchemaHandlerAdapter xsdSchemaHandlerAdapter;
    private String messageReceiverBeanName = "messageReceiver";
    private WebServiceMessageReceiver messageReceiver;
    private Map<String, WsdlDefinition> wsdlDefinitions;
    private Map<String, XsdSchema> xsdSchemas;
    private boolean transformWsdlLocations = false;
    private boolean transformSchemaLocations = false;

    public MessageDispatcherServlet() {
        this(null);
    }

    public MessageDispatcherServlet(WebApplicationContext webApplicationContext) {
        super(webApplicationContext);
    }

    public String getMessageFactoryBeanName() {
        return this.messageFactoryBeanName;
    }

    public void setMessageFactoryBeanName(String messageFactoryBeanName) {
        this.messageFactoryBeanName = messageFactoryBeanName;
    }

    public String getMessageReceiverBeanName() {
        return this.messageReceiverBeanName;
    }

    public void setMessageReceiverBeanName(String messageReceiverBeanName) {
        this.messageReceiverBeanName = messageReceiverBeanName;
    }

    public boolean isTransformWsdlLocations() {
        return this.transformWsdlLocations;
    }

    public void setTransformWsdlLocations(boolean transformWsdlLocations) {
        this.transformWsdlLocations = transformWsdlLocations;
    }

    public boolean isTransformSchemaLocations() {
        return this.transformSchemaLocations;
    }

    public void setTransformSchemaLocations(boolean transformSchemaLocations) {
        this.transformSchemaLocations = transformSchemaLocations;
    }

    public String getMessageReceiverHandlerAdapterBeanName() {
        return this.messageReceiverHandlerAdapterBeanName;
    }

    public void setMessageReceiverHandlerAdapterBeanName(String messageReceiverHandlerAdapterBeanName) {
        this.messageReceiverHandlerAdapterBeanName = messageReceiverHandlerAdapterBeanName;
    }

    public String getWsdlDefinitionHandlerAdapterBeanName() {
        return this.wsdlDefinitionHandlerAdapterBeanName;
    }

    public void setWsdlDefinitionHandlerAdapterBeanName(String wsdlDefinitionHandlerAdapterBeanName) {
        this.wsdlDefinitionHandlerAdapterBeanName = wsdlDefinitionHandlerAdapterBeanName;
    }

    public String getXsdSchemaHandlerAdapterBeanName() {
        return this.xsdSchemaHandlerAdapterBeanName;
    }

    public void setXsdSchemaHandlerAdapterBeanName(String xsdSchemaHandlerAdapterBeanName) {
        this.xsdSchemaHandlerAdapterBeanName = xsdSchemaHandlerAdapterBeanName;
    }

    @Override
    protected void doService(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        WsdlDefinition definition = this.getWsdlDefinition(httpServletRequest);
        if (definition != null) {
            this.wsdlDefinitionHandlerAdapter.handle(httpServletRequest, httpServletResponse, definition);
            return;
        }
        XsdSchema schema = this.getXsdSchema(httpServletRequest);
        if (schema != null) {
            this.xsdSchemaHandlerAdapter.handle(httpServletRequest, httpServletResponse, schema);
            return;
        }
        this.messageReceiverHandlerAdapter.handle(httpServletRequest, httpServletResponse, this.messageReceiver);
    }

    @Override
    protected void onRefresh(ApplicationContext context) {
        this.initStrategies(context);
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        WsdlDefinition definition = this.getWsdlDefinition(httpServletRequest);
        if (definition != null) {
            return this.wsdlDefinitionHandlerAdapter.getLastModified(httpServletRequest, definition);
        }
        XsdSchema schema = this.getXsdSchema(httpServletRequest);
        if (schema != null) {
            return this.xsdSchemaHandlerAdapter.getLastModified(httpServletRequest, schema);
        }
        return this.messageReceiverHandlerAdapter.getLastModified(httpServletRequest, this.messageReceiver);
    }

    protected WebServiceMessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    protected WsdlDefinition getWsdlDefinition(HttpServletRequest request) {
        if ("GET".equals(request.getMethod()) && request.getRequestURI().endsWith(WSDL_SUFFIX_NAME)) {
            String fileName = WebUtils.extractFilenameFromUrlPath(request.getRequestURI());
            return this.wsdlDefinitions.get(fileName);
        }
        return null;
    }

    protected XsdSchema getXsdSchema(HttpServletRequest request) {
        if ("GET".equals(request.getMethod()) && request.getRequestURI().endsWith(XSD_SUFFIX_NAME)) {
            String fileName = WebUtils.extractFilenameFromUrlPath(request.getRequestURI());
            return this.xsdSchemas.get(fileName);
        }
        return null;
    }

    protected void initStrategies(ApplicationContext context) {
        this.initMessageReceiverHandlerAdapter(context);
        this.initWsdlDefinitionHandlerAdapter(context);
        this.initXsdSchemaHandlerAdapter(context);
        this.initMessageReceiver(context);
        this.initWsdlDefinitions(context);
        this.initXsdSchemas(context);
    }

    private void initMessageReceiverHandlerAdapter(ApplicationContext context) {
        try {
            try {
                this.messageReceiverHandlerAdapter = (WebServiceMessageReceiverHandlerAdapter)context.getBean(this.getMessageReceiverHandlerAdapterBeanName(), WebServiceMessageReceiverHandlerAdapter.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.messageReceiverHandlerAdapter = new WebServiceMessageReceiverHandlerAdapter();
            }
            this.initWebServiceMessageFactory(context);
            this.messageReceiverHandlerAdapter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize WebServiceMessageReceiverHandlerAdapter", (Throwable)ex);
        }
    }

    private void initWebServiceMessageFactory(ApplicationContext context) {
        WebServiceMessageFactory messageFactory;
        block2: {
            try {
                messageFactory = (WebServiceMessageFactory)context.getBean(this.getMessageFactoryBeanName(), WebServiceMessageFactory.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                messageFactory = this.defaultStrategiesHelper.getDefaultStrategy(WebServiceMessageFactory.class, context);
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug("No WebServiceMessageFactory found in servlet '" + this.getServletName() + "': using default");
            }
        }
        this.messageReceiverHandlerAdapter.setMessageFactory(messageFactory);
    }

    private void initWsdlDefinitionHandlerAdapter(ApplicationContext context) {
        try {
            try {
                this.wsdlDefinitionHandlerAdapter = (WsdlDefinitionHandlerAdapter)context.getBean(this.getWsdlDefinitionHandlerAdapterBeanName(), WsdlDefinitionHandlerAdapter.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.wsdlDefinitionHandlerAdapter = new WsdlDefinitionHandlerAdapter();
            }
            this.wsdlDefinitionHandlerAdapter.setTransformLocations(this.isTransformWsdlLocations());
            this.wsdlDefinitionHandlerAdapter.setTransformSchemaLocations(this.isTransformSchemaLocations());
            this.wsdlDefinitionHandlerAdapter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize WsdlDefinitionHandlerAdapter", (Throwable)ex);
        }
    }

    private void initXsdSchemaHandlerAdapter(ApplicationContext context) {
        try {
            try {
                this.xsdSchemaHandlerAdapter = (XsdSchemaHandlerAdapter)context.getBean(this.getXsdSchemaHandlerAdapterBeanName(), XsdSchemaHandlerAdapter.class);
            }
            catch (NoSuchBeanDefinitionException ignored) {
                this.xsdSchemaHandlerAdapter = new XsdSchemaHandlerAdapter();
            }
            this.xsdSchemaHandlerAdapter.setTransformSchemaLocations(this.isTransformSchemaLocations());
            this.xsdSchemaHandlerAdapter.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not initialize XsdSchemaHandlerAdapter", (Throwable)ex);
        }
    }

    private void initMessageReceiver(ApplicationContext context) {
        block3: {
            try {
                this.messageReceiver = (WebServiceMessageReceiver)context.getBean(this.getMessageReceiverBeanName(), WebServiceMessageReceiver.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                this.messageReceiver = this.defaultStrategiesHelper.getDefaultStrategy(WebServiceMessageReceiver.class, context);
                if (this.messageReceiver instanceof BeanNameAware) {
                    ((BeanNameAware)this.messageReceiver).setBeanName(this.getServletName());
                }
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.debug("No MessageDispatcher found in servlet '" + this.getServletName() + "': using default");
            }
        }
    }

    private void initWsdlDefinitions(ApplicationContext context) {
        this.wsdlDefinitions = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, WsdlDefinition.class, (boolean)true, (boolean)false);
        if (this.logger.isDebugEnabled()) {
            for (Map.Entry<String, WsdlDefinition> entry : this.wsdlDefinitions.entrySet()) {
                String beanName = entry.getKey();
                WsdlDefinition definition = entry.getValue();
                this.logger.debug("Published [" + definition + "] as " + beanName + WSDL_SUFFIX_NAME);
            }
        }
    }

    private void initXsdSchemas(ApplicationContext context) {
        this.xsdSchemas = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, XsdSchema.class, (boolean)true, (boolean)false);
        if (this.logger.isDebugEnabled()) {
            for (Map.Entry<String, XsdSchema> entry : this.xsdSchemas.entrySet()) {
                String beanName = entry.getKey();
                XsdSchema schema = entry.getValue();
                this.logger.debug("Published [" + schema + "] as " + beanName + XSD_SUFFIX_NAME);
            }
        }
    }
}

