/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.AbstractReceiverConnection;
import org.springframework.ws.transport.mail.MailTransportException;
import org.springframework.ws.transport.mail.support.MailTransportUtils;

public class MailReceiverConnection
extends AbstractReceiverConnection {
    private final Message requestMessage;
    private final Session session;
    private Message responseMessage;
    private ByteArrayOutputStream responseBuffer;
    private String responseContentType;
    private URLName transportUri;
    private InternetAddress from;

    protected MailReceiverConnection(Message requestMessage, Session session) {
        Assert.notNull((Object)requestMessage, (String)"'requestMessage' must not be null");
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.requestMessage = requestMessage;
        this.session = session;
    }

    public Message getRequestMessage() {
        return this.requestMessage;
    }

    public Message getResponseMessage() {
        return this.responseMessage;
    }

    void setTransportUri(URLName transportUri) {
        this.transportUri = transportUri;
    }

    void setFrom(InternetAddress from) {
        this.from = from;
    }

    @Override
    public URI getUri() throws URISyntaxException {
        try {
            Object[] recipients = this.requestMessage.getRecipients(Message.RecipientType.TO);
            if (!ObjectUtils.isEmpty((Object[])recipients) && recipients[0] instanceof InternetAddress) {
                return MailTransportUtils.toUri((InternetAddress)recipients[0], this.requestMessage.getSubject());
            }
            throw new URISyntaxException("", "Could not determine To header");
        }
        catch (MessagingException ex) {
            throw new URISyntaxException("", ex.getMessage());
        }
    }

    @Override
    public String getErrorMessage() throws IOException {
        return null;
    }

    @Override
    public boolean hasError() throws IOException {
        return false;
    }

    @Override
    public Iterator<String> getRequestHeaderNames() throws IOException {
        try {
            ArrayList<String> headers = new ArrayList<String>();
            Enumeration<Header> enumeration = this.requestMessage.getAllHeaders();
            while (enumeration.hasMoreElements()) {
                Header header = enumeration.nextElement();
                headers.add(header.getName());
            }
            return headers.iterator();
        }
        catch (MessagingException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public Iterator<String> getRequestHeaders(String name) throws IOException {
        try {
            String[] headers = this.requestMessage.getHeader(name);
            return Arrays.asList(headers).iterator();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    @Override
    protected InputStream getRequestInputStream() throws IOException {
        try {
            return this.requestMessage.getInputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    @Override
    public void addResponseHeader(String name, String value) throws IOException {
        try {
            this.responseMessage.addHeader(name, value);
            if ("Content-Type".equals(name)) {
                this.responseContentType = value;
            }
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    @Override
    protected OutputStream getResponseOutputStream() throws IOException {
        return this.responseBuffer;
    }

    @Override
    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        try {
            this.responseMessage = this.requestMessage.reply(false);
            this.responseMessage.setFrom(this.from);
            this.responseBuffer = new ByteArrayOutputStream();
        }
        catch (MessagingException ex) {
            throw new MailTransportException(ex);
        }
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        Transport transport = null;
        try {
            this.responseMessage.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.responseContentType, this.responseBuffer.toByteArray())));
            transport = this.session.getTransport(this.transportUri);
            transport.connect();
            this.responseMessage.saveChanges();
            transport.sendMessage(this.responseMessage, this.responseMessage.getAllRecipients());
        }
        catch (MessagingException ex) {
            try {
                throw new MailTransportException(ex);
            }
            catch (Throwable throwable) {
                MailTransportUtils.closeService(transport);
                throw throwable;
            }
        }
        MailTransportUtils.closeService(transport);
    }

    private class ByteArrayDataSource
    implements DataSource {
        private byte[] data;
        private String contentType;

        public ByteArrayDataSource(String contentType, byte[] data) {
            this.data = data;
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return "ByteArrayDataSource";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

