/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.mail.support;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class MailTransportUtils {
    private static final Pattern TO_PATTERN = Pattern.compile("^([^\\?]+)");
    private static final Pattern SUBJECT_PATTERN = Pattern.compile("subject=([^\\&]+)");
    private static final Log logger = LogFactory.getLog(MailTransportUtils.class);

    private MailTransportUtils() {
    }

    public static InternetAddress getTo(URI uri) {
        Matcher matcher = TO_PATTERN.matcher(uri.getSchemeSpecificPart());
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String group = matcher.group(i);
                if (group == null) continue;
                try {
                    return new InternetAddress(group);
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getSubject(URI uri) {
        Matcher matcher = SUBJECT_PATTERN.matcher(uri.getSchemeSpecificPart());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static void closeService(Service service) {
        if (service != null) {
            try {
                service.close();
            }
            catch (MessagingException ex) {
                logger.debug("Could not close JavaMail Service", ex);
            }
        }
    }

    public static void closeFolder(Folder folder) {
        MailTransportUtils.closeFolder(folder, false);
    }

    public static void closeFolder(Folder folder, boolean expunge) {
        if (folder != null && folder.isOpen()) {
            try {
                folder.close(expunge);
            }
            catch (MessagingException ex) {
                logger.debug("Could not close JavaMail Folder", ex);
            }
        }
    }

    public static String toPasswordProtectedString(URLName name) {
        String protocol = name.getProtocol();
        String username = name.getUsername();
        String password = name.getPassword();
        String host = name.getHost();
        int port = name.getPort();
        String file = name.getFile();
        String ref = name.getRef();
        StringBuilder tempURL = new StringBuilder();
        if (protocol != null) {
            tempURL.append(protocol).append(':');
        }
        if (StringUtils.hasLength((String)username) || StringUtils.hasLength((String)host)) {
            tempURL.append("//");
            if (StringUtils.hasLength((String)username)) {
                tempURL.append(username);
                if (StringUtils.hasLength((String)password)) {
                    tempURL.append(":*****");
                }
                tempURL.append("@");
            }
            if (StringUtils.hasLength((String)host)) {
                tempURL.append(host);
            }
            if (port != -1) {
                tempURL.append(':').append(Integer.toString(port));
            }
            if (StringUtils.hasLength((String)file)) {
                tempURL.append('/');
            }
        }
        if (StringUtils.hasLength((String)file)) {
            tempURL.append(file);
        }
        if (StringUtils.hasLength((String)ref)) {
            tempURL.append('#').append(ref);
        }
        return tempURL.toString();
    }

    public static URI toUri(InternetAddress to, String subject) throws URISyntaxException {
        if (StringUtils.hasLength((String)subject)) {
            return new URI("mailto", to.getAddress() + "?subject=" + subject, null);
        }
        return new URI("mailto", to.getAddress(), null);
    }
}

