/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.TypeConverterExists;
import org.apache.camel.TypeConverters;
import org.apache.camel.ValueHolder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.core.xml.AbstractCamelEndpointFactoryBean;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.core.xml.AbstractCamelRedeliveryPolicyFactoryBean;
import org.apache.camel.core.xml.CamelJMXAgentDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderDefinition;
import org.apache.camel.core.xml.CamelPropertyPlaceholderFunctionDefinition;
import org.apache.camel.core.xml.CamelRouteControllerDefinition;
import org.apache.camel.core.xml.CamelStreamCachingStrategyDefinition;
import org.apache.camel.core.xml.PatternBasedPackageScanFilter;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.model.ContextScanDefinition;
import org.apache.camel.model.ErrorHandlerDefinition;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.GlobalOptionsDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RestContextRefDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteConfigurationContainer;
import org.apache.camel.model.RouteConfigurationContextRefDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteContextRefDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteTemplateContainer;
import org.apache.camel.model.RouteTemplateContextRefDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteContainer;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ThreadPoolProfileDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestContainer;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.transformer.TransformersDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.model.validator.ValidatorsDefinition;
import org.apache.camel.reifier.transformer.TransformerReifier;
import org.apache.camel.reifier.validator.ValidatorReifier;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelContextFactoryBean<T extends ModelCamelContext>
extends IdentifiedType
implements RouteTemplateContainer,
RouteConfigurationContainer,
RouteContainer,
RestContainer,
TemplatedRouteContainer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContextFactoryBean.class);
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart;
    @XmlTransient
    private final AtomicBoolean routesSetupDone = new AtomicBoolean();

    public AbstractCamelContextFactoryBean() {
        this.contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    }

    public T getObject() throws Exception {
        return this.getContext();
    }

    public abstract Class<T> getObjectType();

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    /*
     * WARNING - void declaration
     */
    public void afterPropertiesSet() throws Exception {
        Map<String, LogListener> map;
        UuidGenerator uuidGenerator;
        void var25_70;
        DevConsoleRegistry devConsoleRegistry;
        Set<HealthCheckRepository> set;
        void var24_62;
        HealthCheckRegistry healthCheckRegistry;
        Map<String, RoutePolicyFactory> map2;
        Map<String, ServiceRegistry> map3;
        Map<String, CamelClusterService> map4;
        Map<String, ModelLifecycleStrategy> map5;
        Map<String, LifecycleStrategy> lifecycleStrategies;
        Map<String, InterceptStrategy> map6;
        ShutdownStrategy shutdownStrategy;
        Map<String, EndpointStrategy> map7;
        Map<String, EventNotifier> eventNotifiers;
        Map<String, TypeConverters> typeConverters;
        HeadersMapFactory headersMapFactory;
        RuntimeEndpointRegistry runtimeEndpointRegistry;
        UnitOfWorkFactory unitOfWorkFactory;
        EventFactory eventFactory;
        ManagementObjectNameStrategy managementObjectNameStrategy;
        ManagementStrategy managementStrategy;
        AsyncProcessorAwaitManager asyncProcessorAwaitManager;
        InflightRepository inflightRepository;
        String s;
        TypeConverterRegistry tcr;
        PackageScanClassResolver packageResolver;
        if (org.apache.camel.util.ObjectHelper.isEmpty(this.getId())) {
            throw new IllegalArgumentException("Id must be set");
        }
        PropertiesComponent pc = this.getBeanForType(PropertiesComponent.class);
        if (pc != null) {
            LOG.debug("Using PropertiesComponent: {}", (Object)pc);
            this.getContext().setPropertiesComponent(pc);
        }
        if ((packageResolver = this.getBeanForType(PackageScanClassResolver.class)) != null) {
            LOG.info("Using custom PackageScanClassResolver: {}", (Object)packageResolver);
            this.getContext().adapt(ExtendedCamelContext.class).setPackageScanClassResolver(packageResolver);
        }
        if ((tcr = this.getBeanForType(TypeConverterRegistry.class)) != null) {
            LOG.info("Using custom TypeConverterRegistry: {}", (Object)tcr);
            this.getContext().setTypeConverterRegistry(tcr);
        }
        if (this.getTypeConverterStatisticsEnabled() != null) {
            this.getContext().setTypeConverterStatisticsEnabled(CamelContextHelper.parseBoolean(this.getContext(), this.getTypeConverterStatisticsEnabled()));
        }
        if (this.getTypeConverterExists() != null) {
            this.getContext().getTypeConverterRegistry().setTypeConverterExists(this.getTypeConverterExists());
        }
        if (this.getTypeConverterExistsLoggingLevel() != null) {
            this.getContext().getTypeConverterRegistry().setTypeConverterExistsLoggingLevel(this.getTypeConverterExistsLoggingLevel());
        }
        if (this.getLoadTypeConverters() != null) {
            s = this.getContext().resolvePropertyPlaceholders(this.getLoadTypeConverters());
            this.getContext().setLoadTypeConverters(Boolean.parseBoolean(s));
        }
        if (this.getLoadHealthChecks() != null) {
            s = this.getContext().resolvePropertyPlaceholders(this.getLoadHealthChecks());
            this.getContext().setLoadHealthChecks(Boolean.parseBoolean(s));
        }
        HashMap<String, String> mergedOptions = new HashMap<String, String>();
        if (this.getGlobalOptions() != null) {
            mergedOptions.putAll(this.getGlobalOptions().asMap());
        }
        if (!mergedOptions.isEmpty()) {
            this.getContext().setGlobalOptions(mergedOptions);
        }
        this.initCustomRegistry(this.getContext());
        this.initPropertyPlaceholder();
        this.initJMXAgent();
        this.setupCustomServices();
        BacklogTracer backlogTracer = this.getBeanForType(BacklogTracer.class);
        if (backlogTracer != null) {
            LOG.info("Using custom BacklogTracer: {}", (Object)backlogTracer);
            this.getContext().addService(backlogTracer);
        }
        if ((inflightRepository = this.getBeanForType(InflightRepository.class)) != null) {
            LOG.info("Using custom InflightRepository: {}", (Object)inflightRepository);
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((asyncProcessorAwaitManager = this.getBeanForType(AsyncProcessorAwaitManager.class)) != null) {
            LOG.info("Using custom AsyncProcessorAwaitManager: {}", (Object)asyncProcessorAwaitManager);
            this.getContext().adapt(ExtendedCamelContext.class).setAsyncProcessorAwaitManager(asyncProcessorAwaitManager);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info("Using custom ManagementStrategy: {}", (Object)managementStrategy);
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((managementObjectNameStrategy = this.getBeanForType(ManagementObjectNameStrategy.class)) != null) {
            LOG.info("Using custom ManagementObjectNameStrategy: {}", (Object)managementObjectNameStrategy);
            this.getContext().getManagementStrategy().setManagementObjectNameStrategy(managementObjectNameStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info("Using custom EventFactory: {}", (Object)eventFactory);
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((unitOfWorkFactory = this.getBeanForType(UnitOfWorkFactory.class)) != null) {
            LOG.info("Using custom UnitOfWorkFactory: {}", (Object)unitOfWorkFactory);
            this.getContext().adapt(ExtendedCamelContext.class).setUnitOfWorkFactory(unitOfWorkFactory);
        }
        if ((runtimeEndpointRegistry = this.getBeanForType(RuntimeEndpointRegistry.class)) != null) {
            LOG.info("Using custom RuntimeEndpointRegistry: {}", (Object)runtimeEndpointRegistry);
            this.getContext().setRuntimeEndpointRegistry(runtimeEndpointRegistry);
        }
        if ((headersMapFactory = this.getBeanForType(HeadersMapFactory.class)) != null) {
            LOG.info("Using custom HeadersMapFactory: {}", (Object)headersMapFactory);
            this.getContext().adapt(ExtendedCamelContext.class).setHeadersMapFactory(headersMapFactory);
        }
        if ((typeConverters = this.getContext().getRegistry().findByTypeWithName(TypeConverters.class)) != null && !typeConverters.isEmpty()) {
            for (Map.Entry<String, TypeConverters> entry : typeConverters.entrySet()) {
                TypeConverters typeConverters2 = entry.getValue();
                LOG.info("Adding custom TypeConverters with id: {} and implementation: {}", (Object)entry.getKey(), (Object)typeConverters2);
                this.getContext().getTypeConverterRegistry().addTypeConverters(typeConverters2);
            }
        }
        if ((eventNotifiers = this.getContext().getRegistry().findByTypeWithName(EventNotifier.class)) != null && !eventNotifiers.isEmpty()) {
            for (Map.Entry<String, EventNotifier> entry : eventNotifiers.entrySet()) {
                EventNotifier eventNotifier = entry.getValue();
                if (this.getContext().getManagementStrategy().getEventNotifiers().contains(eventNotifier)) continue;
                LOG.info("Using custom EventNotifier with id: {} and implementation: {}", (Object)entry.getKey(), (Object)eventNotifier);
                this.getContext().getManagementStrategy().addEventNotifier(eventNotifier);
            }
        }
        if ((map7 = this.getContext().getRegistry().findByTypeWithName(EndpointStrategy.class)) != null && !map7.isEmpty()) {
            for (Map.Entry<String, EndpointStrategy> entry : map7.entrySet()) {
                EndpointStrategy strategy = entry.getValue();
                LOG.info("Using custom EndpointStrategy with id: {} and implementation: {}", (Object)entry.getKey(), (Object)strategy);
                this.getContext().adapt(ExtendedCamelContext.class).registerEndpointCallback(strategy);
            }
        }
        if ((shutdownStrategy = this.getBeanForType(ShutdownStrategy.class)) != null) {
            LOG.info("Using custom ShutdownStrategy: {}", (Object)shutdownStrategy);
            this.getContext().setShutdownStrategy(shutdownStrategy);
        }
        if ((map6 = this.getContext().getRegistry().findByTypeWithName(InterceptStrategy.class)) != null && !map6.isEmpty()) {
            for (Map.Entry entry : map6.entrySet()) {
                InterceptStrategy interceptStrategy = (InterceptStrategy)entry.getValue();
                if (this.getContext().adapt(ExtendedCamelContext.class).getInterceptStrategies().contains(interceptStrategy)) continue;
                LOG.info("Using custom InterceptStrategy with id: {} and implementation: {}", entry.getKey(), (Object)interceptStrategy);
                this.getContext().adapt(ExtendedCamelContext.class).addInterceptStrategy(interceptStrategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().findByTypeWithName(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (Map.Entry<String, LifecycleStrategy> entry : lifecycleStrategies.entrySet()) {
                LifecycleStrategy lifecycleStrategy = entry.getValue();
                if (this.getContext().getLifecycleStrategies().contains(lifecycleStrategy)) continue;
                LOG.info("Using custom LifecycleStrategy with id: {} and implementation: {}", (Object)entry.getKey(), (Object)lifecycleStrategy);
                this.getContext().addLifecycleStrategy(lifecycleStrategy);
            }
        }
        if ((map5 = this.getContext().getRegistry().findByTypeWithName(ModelLifecycleStrategy.class)) != null && !map5.isEmpty()) {
            for (Map.Entry<String, ModelLifecycleStrategy> entry : map5.entrySet()) {
                ModelLifecycleStrategy modelLifecycleStrategy = entry.getValue();
                ModelCamelContext modelCamelContext = this.getContext().adapt(ModelCamelContext.class);
                if (modelCamelContext.getModelLifecycleStrategies().contains(modelLifecycleStrategy)) continue;
                LOG.info("Using custom ModelLifecycleStrategy with id: {} and implementation: {}", (Object)entry.getKey(), (Object)modelLifecycleStrategy);
                modelCamelContext.addModelLifecycleStrategy(modelLifecycleStrategy);
            }
        }
        if ((map4 = this.getContext().getRegistry().findByTypeWithName(CamelClusterService.class)) != null && !map4.isEmpty()) {
            for (Map.Entry<String, CamelClusterService> entry : map4.entrySet()) {
                CamelClusterService camelClusterService = entry.getValue();
                LOG.info("Using CamelClusterService with id: {} and implementation: {}", (Object)camelClusterService.getId(), (Object)camelClusterService);
                this.getContext().addService(camelClusterService);
            }
        }
        if ((map3 = this.getContext().getRegistry().findByTypeWithName(ServiceRegistry.class)) != null && !map3.isEmpty()) {
            for (Map.Entry<String, ServiceRegistry> entry : map3.entrySet()) {
                ServiceRegistry serviceRegistry = entry.getValue();
                if (serviceRegistry.getId() == null) {
                    serviceRegistry.setGeneratedId(this.getContext().getUuidGenerator().generateUuid());
                }
                LOG.info("Using ServiceRegistry with id: {} and implementation: {}", (Object)serviceRegistry.getId(), (Object)serviceRegistry);
                this.getContext().addService(serviceRegistry);
            }
        }
        if ((map2 = this.getContext().getRegistry().findByTypeWithName(RoutePolicyFactory.class)) != null && !map2.isEmpty()) {
            for (Map.Entry<String, RoutePolicyFactory> entry : map2.entrySet()) {
                RoutePolicyFactory factory = entry.getValue();
                LOG.info("Using custom RoutePolicyFactory with id: {} and implementation: {}", (Object)entry.getKey(), (Object)factory);
                this.getContext().addRoutePolicyFactory(factory);
            }
        }
        if ((healthCheckRegistry = this.getBeanForType(HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext((CamelContext)this.getContext());
            LOG.debug("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            this.getContext().setExtension(HealthCheckRegistry.class, (HealthCheckRegistry)healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get(this.getContext());
            if (healthCheckRegistry2 != null) {
                healthCheckRegistry2.setCamelContext((CamelContext)this.getContext());
            }
        }
        if (var24_62 != null && org.apache.camel.util.ObjectHelper.isNotEmpty(set = this.getContext().getRegistry().findByType(HealthCheckRepository.class))) {
            for (HealthCheckRepository healthCheckRepository : set) {
                var24_62.register(healthCheckRepository);
            }
        }
        if ((devConsoleRegistry = this.getBeanForType(DevConsoleRegistry.class)) != null) {
            devConsoleRegistry.setCamelContext((CamelContext)this.getContext());
            LOG.debug("Using DevConsoleRegistry: {}", (Object)devConsoleRegistry);
            this.getContext().setExtension(DevConsoleRegistry.class, (DevConsoleRegistry)devConsoleRegistry);
        } else {
            DevConsoleRegistry devConsoleRegistry2 = DevConsoleRegistry.get(this.getContext());
            if (devConsoleRegistry2 != null) {
                devConsoleRegistry2.setCamelContext((CamelContext)this.getContext());
            }
        }
        if (var25_70 != null) {
            Set<DevConsole> consoles = this.getContext().getRegistry().findByType(DevConsole.class);
            for (DevConsole console : consoles) {
                var25_70.register(console);
            }
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: {}", (Object)uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((map = this.getContext().getRegistry().findByTypeWithName(LogListener.class)) != null && !map.isEmpty()) {
            for (Map.Entry<String, LogListener> entry : map.entrySet()) {
                LogListener logListener = entry.getValue();
                if (this.getContext().adapt(ExtendedCamelContext.class).getLogListeners() != null && this.getContext().adapt(ExtendedCamelContext.class).getLogListeners().contains(logListener)) continue;
                LOG.info("Using custom LogListener with id: {} and implementation: {}", (Object)entry.getKey(), (Object)logListener);
                this.getContext().adapt(ExtendedCamelContext.class).addLogListener(logListener);
            }
        }
        this.initThreadPoolProfiles(this.getContext());
        this.initBeanPostProcessor(this.getContext());
        this.initCamelContext(this.getContext());
        this.initStreamCachingStrategy();
        this.initRouteController();
    }

    protected void setupRoutes() throws Exception {
        if (this.routesSetupDone.compareAndSet(false, true)) {
            LOG.debug("Setting up routes");
            this.getContext().adapt(ExtendedCamelContext.class).setupRoutes(false);
            this.initRouteConfigurationRefs();
            this.getContext().addRouteConfigurations(this.getRouteConfigurations());
            this.initRouteTemplateRefs();
            this.initRouteRefs();
            this.initRestRefs();
            this.initTransformers();
            this.initValidators();
            this.getContext().addRestDefinitions(this.getRests(), false);
            RestConfiguration config = this.getContext().getRestConfiguration();
            if (config.getApiContextPath() != null) {
                boolean hasRestApi = false;
                for (RouteDefinition route : this.getContext().getRouteDefinitions()) {
                    FromDefinition from = route.getInput();
                    if (from.getUri() == null || !from.getUri().startsWith("rest-api:")) continue;
                    hasRestApi = true;
                }
                if (!hasRestApi) {
                    RouteDefinition route = RestDefinition.asRouteApiDefinition(this.getContext(), config);
                    LOG.debug("Adding routeId: {} as rest-api route", (Object)route.getId());
                    this.getRoutes().add(route);
                }
            }
            for (RestDefinition rest : this.getContext().getRestDefinitions()) {
                rest.asRouteDefinition((CamelContext)this.getContext()).forEach(r -> this.getRoutes().add((RouteDefinition)r));
            }
            this.getContext().addRouteTemplateDefinitions(this.getRouteTemplates());
            this.prepareRoutes();
            this.getContext().addRouteDefinitions(this.getRoutes());
            this.getContext().addRouteFromTemplatedRoutes(this.getTemplatedRoutes());
            LOG.debug("Found JAXB created routes: {}", this.getRoutes());
            this.findRouteBuilders();
            this.installRoutes();
            this.getContext().adapt(ExtendedCamelContext.class).setupRoutes(true);
        }
    }

    private void initTransformers() {
        if (this.getTransformers() != null) {
            for (TransformerDefinition def : this.getTransformers().getTransformers()) {
                Transformer transformer = TransformerReifier.reifier(this.getContext(), def).createTransformer();
                this.getContext().getTransformerRegistry().put(AbstractCamelContextFactoryBean.createTransformerKey(def), transformer);
            }
        }
    }

    private static ValueHolder<String> createTransformerKey(TransformerDefinition def) {
        return org.apache.camel.util.ObjectHelper.isNotEmpty(def.getScheme()) ? new TransformerKey(def.getScheme()) : new TransformerKey(new DataType(def.getFromType()), new DataType(def.getToType()));
    }

    private void initValidators() {
        if (this.getValidators() != null) {
            for (ValidatorDefinition def : this.getValidators().getValidators()) {
                Validator validator = ValidatorReifier.reifier(this.getContext(), def).createValidator();
                this.getContext().getValidatorRegistry().put(AbstractCamelContextFactoryBean.createValidatorKey(def), validator);
            }
        }
    }

    private static ValidatorKey createValidatorKey(ValidatorDefinition def) {
        return new ValidatorKey(new DataType(def.getType()));
    }

    private void prepareRoutes() {
        for (RouteDefinition route : this.getRoutes()) {
            List<RouteConfigurationDefinition> globalConfigurations;
            RouteDefinitionHelper.sanityCheckRoute(route);
            route.resetPrepare();
            AtomicReference errorHandler = new AtomicReference();
            ArrayList<OnExceptionDefinition> oe = new ArrayList<OnExceptionDefinition>(this.getOnExceptions());
            ArrayList<InterceptDefinition> icp = new ArrayList<InterceptDefinition>(this.getIntercepts());
            ArrayList<InterceptFromDefinition> ifrom = new ArrayList<InterceptFromDefinition>(this.getInterceptFroms());
            ArrayList<InterceptSendToEndpointDefinition> ito = new ArrayList<InterceptSendToEndpointDefinition>(this.getInterceptSendToEndpoints());
            ArrayList<OnCompletionDefinition> oc = new ArrayList<OnCompletionDefinition>(this.getOnCompletions());
            if (this.getContext() != null && (globalConfigurations = this.getContext().adapt(ModelCamelContext.class).getRouteConfigurationDefinitions()) != null) {
                String[] ids;
                String[] stringArray;
                if (route.getRouteConfigurationId() != null) {
                    stringArray = route.getRouteConfigurationId().split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                }
                for (String id : ids = stringArray) {
                    globalConfigurations.stream().sorted(OrderedComparator.get()).filter(g -> {
                        if (route.getRouteConfigurationId() != null) {
                            return PatternHelper.matchPattern(g.getId(), id);
                        }
                        return g.getId() == null || g.getId().equals(id);
                    }).forEach(g -> {
                        if (g.getErrorHandler() != null) {
                            errorHandler.set(g.getErrorHandler());
                        }
                        String aid = g.getId() == null ? "<default>" : g.getId();
                        route.addAppliedRouteConfigurationId(aid);
                        oe.addAll(g.getOnExceptions());
                        icp.addAll(g.getIntercepts());
                        ifrom.addAll(g.getInterceptFroms());
                        ito.addAll(g.getInterceptSendTos());
                        oc.addAll(g.getOnCompletions());
                    });
                }
            }
            RouteDefinitionHelper.prepareRoute(this.getContext(), route, (ErrorHandlerDefinition)errorHandler.get(), oe, icp, ifrom, ito, oc);
            if (LOG.isDebugEnabled() && route.getAppliedRouteConfigurationIds() != null) {
                LOG.debug("Route: {} is using route configurations ids: {}", (Object)route.getId(), route.getAppliedRouteConfigurationIds());
            }
            route.markPrepared();
        }
    }

    protected abstract void initCustomRegistry(T var1);

    protected void initJMXAgent() throws Exception {
        CamelJMXAgentDefinition camelJMXAgent = this.getCamelJMXAgent();
        boolean disabled = false;
        if (camelJMXAgent != null) {
            boolean bl = disabled = camelJMXAgent.getDisabled() != null && CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getDisabled()) != false;
        }
        if (disabled) {
            LOG.debug("JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy(new DefaultManagementStrategy());
        } else if (camelJMXAgent != null) {
            String level;
            LOG.debug("JMXAgent enabled: {}", (Object)camelJMXAgent);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (camelJMXAgent.getMbeanObjectDomainName() != null) {
                properties.put("mbeanObjectDomainName", CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getMbeanObjectDomainName()));
            }
            if (camelJMXAgent.getUsePlatformMBeanServer() != null) {
                properties.put("usePlatformMBeanServer", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getUsePlatformMBeanServer()));
            }
            if (camelJMXAgent.getOnlyRegisterProcessorWithCustomId() != null) {
                properties.put("onlyRegisterProcessorWithCustomId", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getOnlyRegisterProcessorWithCustomId()));
            }
            if (camelJMXAgent.getRegisterAlways() != null) {
                properties.put("registerAlways", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getRegisterAlways()));
            }
            if (camelJMXAgent.getRegisterNewRoutes() != null) {
                properties.put("registerNewRoutes", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getRegisterNewRoutes()));
            }
            if (camelJMXAgent.getIncludeHostName() != null) {
                properties.put("includeHostName", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getIncludeHostName()));
            }
            if (camelJMXAgent.getUseHostIPAddress() != null) {
                properties.put("useHostIPAddress", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getUseHostIPAddress()));
            }
            if (camelJMXAgent.getMask() != null) {
                properties.put("mask", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getMask()));
            }
            if (camelJMXAgent.getLoadStatisticsEnabled() != null) {
                properties.put("loadStatisticsEnabled", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getLoadStatisticsEnabled()));
            }
            if (camelJMXAgent.getEndpointRuntimeStatisticsEnabled() != null) {
                properties.put("endpointRuntimeStatisticsEnabled", CamelContextHelper.parseBoolean(this.getContext(), camelJMXAgent.getEndpointRuntimeStatisticsEnabled()));
            }
            if (camelJMXAgent.getStatisticsLevel() != null) {
                level = CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getStatisticsLevel());
                ManagementStatisticsLevel msLevel = this.getContext().getTypeConverter().mandatoryConvertTo(ManagementStatisticsLevel.class, level);
                properties.put("statisticsLevel", (Object)msLevel);
            }
            if (camelJMXAgent.getMbeansLevel() != null) {
                level = CamelContextHelper.parseText(this.getContext(), camelJMXAgent.getMbeansLevel());
                ManagementMBeansLevel mbLevel = this.getContext().getTypeConverter().mandatoryConvertTo(ManagementMBeansLevel.class, level);
                properties.put("mBeansLevel", (Object)mbLevel);
            }
            this.getContext().adapt(ExtendedCamelContext.class).setupManagement(properties);
        }
    }

    protected void initStreamCachingStrategy() throws Exception {
        String spoolRules;
        Boolean anySpoolRules;
        Boolean statisticsEnabled;
        Boolean remove;
        String spoolCipher;
        String limit;
        Integer spoolUsedHeap;
        Long spoolThreshold;
        String spoolDirectory;
        CamelStreamCachingStrategyDefinition streamCaching = this.getCamelStreamCachingStrategy();
        if (streamCaching == null) {
            this.getContext().getStreamCachingStrategy().setEnabled(true);
            return;
        }
        Boolean enabled = CamelContextHelper.parseBoolean(this.getContext(), streamCaching.getEnabled());
        if (enabled != null) {
            this.getContext().getStreamCachingStrategy().setEnabled(enabled);
        } else {
            this.getContext().getStreamCachingStrategy().setEnabled(true);
        }
        Boolean spoolEnabled = CamelContextHelper.parseBoolean(this.getContext(), streamCaching.getSpoolEnabled());
        if (spoolEnabled != null) {
            this.getContext().getStreamCachingStrategy().setSpoolEnabled(spoolEnabled);
        }
        if ((spoolDirectory = CamelContextHelper.parseText(this.getContext(), streamCaching.getSpoolDirectory())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolDirectory(spoolDirectory);
        }
        if ((spoolThreshold = CamelContextHelper.parseLong(this.getContext(), streamCaching.getSpoolThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolThreshold(spoolThreshold);
        }
        if ((spoolUsedHeap = CamelContextHelper.parseInteger(this.getContext(), streamCaching.getSpoolUsedHeapMemoryThreshold())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(spoolUsedHeap);
        }
        if ((limit = CamelContextHelper.parseText(this.getContext(), streamCaching.getSpoolUsedHeapMemoryLimit())) != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit ul = CamelContextHelper.mandatoryConvertTo(this.getContext(), StreamCachingStrategy.SpoolUsedHeapMemoryLimit.class, limit);
            this.getContext().getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(ul);
        }
        if ((spoolCipher = CamelContextHelper.parseText(this.getContext(), streamCaching.getSpoolCipher())) != null) {
            this.getContext().getStreamCachingStrategy().setSpoolCipher(spoolCipher);
        }
        if ((remove = CamelContextHelper.parseBoolean(this.getContext(), streamCaching.getRemoveSpoolDirectoryWhenStopping())) != null) {
            this.getContext().getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(remove);
        }
        if ((statisticsEnabled = CamelContextHelper.parseBoolean(this.getContext(), streamCaching.getStatisticsEnabled())) != null) {
            this.getContext().getStreamCachingStrategy().getStatistics().setStatisticsEnabled(statisticsEnabled);
        }
        if ((anySpoolRules = CamelContextHelper.parseBoolean(this.getContext(), streamCaching.getAnySpoolRules())) != null) {
            this.getContext().getStreamCachingStrategy().setAnySpoolRules(anySpoolRules);
        }
        if ((spoolRules = CamelContextHelper.parseText(this.getContext(), streamCaching.getSpoolRules())) != null) {
            for (String name : ObjectHelper.createIterable(spoolRules)) {
                StreamCachingStrategy.SpoolRule rule = this.getContext().getRegistry().lookupByNameAndType(name, StreamCachingStrategy.SpoolRule.class);
                if (rule == null) continue;
                this.getContext().getStreamCachingStrategy().addSpoolRule(rule);
            }
        }
    }

    protected void initRouteController() throws Exception {
        LoggingLevel loggingLevel;
        Boolean unhealthyOnExhausted;
        Double backOffMultiplier;
        Long backOffMaxAttempts;
        Long backOffMaxElapsedTime;
        Long backOffMaxDelay;
        Long backoffDelay;
        Long initialDelay;
        Integer threadPoolSize;
        String excludeRoutes;
        String includeRoutes;
        RouteController routeController = this.getBeanForType(RouteController.class);
        if (routeController != null) {
            LOG.info("Using RouteController: {}", (Object)routeController);
            this.getContext().setRouteController(routeController);
            return;
        }
        CamelRouteControllerDefinition rc = this.getCamelRouteController();
        if (rc == null) {
            return;
        }
        SupervisingRouteController src = null;
        Boolean enabled = CamelContextHelper.parseBoolean(this.getContext(), rc.getSupervising());
        if (enabled != null) {
            src = this.getContext().getRouteController().supervising();
        }
        if ((includeRoutes = CamelContextHelper.parseText(this.getContext(), rc.getIncludeRoutes())) != null && src != null) {
            src.setIncludeRoutes(includeRoutes);
        }
        if ((excludeRoutes = CamelContextHelper.parseText(this.getContext(), rc.getExcludeRoutes())) != null && src != null) {
            src.setExcludeRoutes(excludeRoutes);
        }
        if ((threadPoolSize = CamelContextHelper.parseInteger(this.getContext(), rc.getThreadPoolSize())) != null && src != null) {
            src.setThreadPoolSize(threadPoolSize);
        }
        if ((initialDelay = CamelContextHelper.parseLong(this.getContext(), rc.getInitialDelay())) != null && src != null) {
            src.setInitialDelay(initialDelay);
        }
        if ((backoffDelay = CamelContextHelper.parseLong(this.getContext(), rc.getBackOffDelay())) != null && src != null) {
            src.setBackOffDelay(backoffDelay);
        }
        if ((backOffMaxDelay = CamelContextHelper.parseLong(this.getContext(), rc.getBackOffMaxDelay())) != null && src != null) {
            src.setBackOffMaxDelay(backOffMaxDelay);
        }
        if ((backOffMaxElapsedTime = CamelContextHelper.parseLong(this.getContext(), rc.getBackOffMaxElapsedTime())) != null && src != null) {
            src.setBackOffMaxElapsedTime(backOffMaxElapsedTime);
        }
        if ((backOffMaxAttempts = CamelContextHelper.parseLong(this.getContext(), rc.getBackOffMaxAttempts())) != null && src != null) {
            src.setBackOffMaxAttempts(backOffMaxAttempts);
        }
        if ((backOffMultiplier = CamelContextHelper.parseDouble(this.getContext(), rc.getBackOffMultiplier())) != null && src != null) {
            src.setBackOffMultiplier(backOffMultiplier);
        }
        if ((unhealthyOnExhausted = CamelContextHelper.parseBoolean(this.getContext(), rc.getUnhealthyOnExhausted())) != null && unhealthyOnExhausted.booleanValue()) {
            src.setUnhealthyOnExhausted(unhealthyOnExhausted);
        }
        if ((loggingLevel = CamelContextHelper.parse(this.getContext(), LoggingLevel.class, rc.getLoggingLevel())) != null) {
            src.setLoggingLevel(loggingLevel);
        }
    }

    protected void initPropertyPlaceholder() throws Exception {
        if (this.getCamelPropertyPlaceholder() != null) {
            CamelPropertyPlaceholderDefinition def = this.getCamelPropertyPlaceholder();
            ArrayList<PropertiesLocation> locations = new ArrayList<PropertiesLocation>();
            if (def.getLocation() != null) {
                ObjectHelper.createIterable(def.getLocation()).forEach(location -> locations.add(new PropertiesLocation((String)location)));
            }
            if (def.getLocations() != null) {
                def.getLocations().forEach(definition -> locations.add(definition.toLocation()));
            }
            PropertiesComponent pc = new PropertiesComponent();
            pc.setLocations(locations);
            pc.setEncoding(def.getEncoding());
            if (def.isIgnoreMissingLocation() != null) {
                pc.setIgnoreMissingLocation(def.isIgnoreMissingLocation());
            }
            if (def.isNestedPlaceholder() != null) {
                pc.setNestedPlaceholder(def.isNestedPlaceholder());
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(def.getPropertiesParserRef())) {
                PropertiesParser parser = CamelContextHelper.mandatoryLookup(this.getContext(), def.getPropertiesParserRef(), PropertiesParser.class);
                pc.setPropertiesParser(parser);
            }
            if (def.getDefaultFallbackEnabled() != null) {
                pc.setDefaultFallbackEnabled(def.getDefaultFallbackEnabled());
            }
            if (def.getFunctions() != null && !def.getFunctions().isEmpty()) {
                for (CamelPropertyPlaceholderFunctionDefinition function : def.getFunctions()) {
                    String ref = function.getRef();
                    PropertiesFunction pf = CamelContextHelper.mandatoryLookup(this.getContext(), ref, PropertiesFunction.class);
                    pc.addPropertiesFunction(pf);
                }
            }
            this.getContext().setPropertiesComponent(pc);
        }
    }

    protected void initRouteRefs() throws Exception {
        if (this.getRouteRefs() != null) {
            for (RouteContextRefDefinition ref : this.getRouteRefs()) {
                List<RouteDefinition> defs = ref.lookupRoutes((CamelContext)this.getContext());
                for (RouteDefinition def : defs) {
                    LOG.debug("Adding route from {} -> {}", (Object)ref, (Object)def);
                    this.getRoutes().add(0, def);
                }
            }
        }
    }

    protected void initRouteConfigurationRefs() throws Exception {
        if (this.getRouteConfigurationRefs() != null) {
            for (RouteConfigurationContextRefDefinition ref : this.getRouteConfigurationRefs()) {
                List<RouteConfigurationDefinition> defs = ref.lookupRouteConfigurations((CamelContext)this.getContext());
                for (RouteConfigurationDefinition def : defs) {
                    LOG.debug("Adding route configuration from {} -> {}", (Object)ref, (Object)def);
                    this.getRouteConfigurations().add(def);
                }
            }
        }
    }

    protected void initRouteTemplateRefs() throws Exception {
        if (this.getRouteTemplateRefs() != null) {
            for (RouteTemplateContextRefDefinition ref : this.getRouteTemplateRefs()) {
                List<RouteTemplateDefinition> defs = ref.lookupRouteTemplates((CamelContext)this.getContext());
                for (RouteTemplateDefinition def : defs) {
                    LOG.debug("Adding route template from {} -> {}", (Object)ref, (Object)def);
                    this.getRouteTemplates().add(def);
                }
            }
        }
    }

    protected void initRestRefs() throws Exception {
        if (this.getRestRefs() != null) {
            for (RestContextRefDefinition ref : this.getRestRefs()) {
                List<RestDefinition> defs = ref.lookupRests((CamelContext)this.getContext());
                for (RestDefinition def : defs) {
                    LOG.debug("Adding rest from {} -> {}", (Object)ref, (Object)def);
                    this.getRests().add(0, def);
                }
            }
        }
    }

    protected abstract <S> S getBeanForType(Class<S> var1);

    public void destroy() throws Exception {
        this.routesSetupDone.set(false);
        this.getContext().stop();
    }

    public T getContext() {
        return this.getContext(true);
    }

    public abstract T getContext(boolean var1);

    @Override
    public abstract List<RouteTemplateDefinition> getRouteTemplates();

    @Override
    public abstract List<TemplatedRouteDefinition> getTemplatedRoutes();

    @Override
    public abstract List<RouteConfigurationDefinition> getRouteConfigurations();

    @Override
    public abstract List<RouteDefinition> getRoutes();

    @Override
    public abstract List<RestDefinition> getRests();

    public abstract RestConfigurationDefinition getRestConfiguration();

    public abstract List<? extends AbstractCamelEndpointFactoryBean> getEndpoints();

    public abstract List<? extends AbstractCamelRedeliveryPolicyFactoryBean> getRedeliveryPolicies();

    public abstract List<InterceptDefinition> getIntercepts();

    public abstract List<InterceptFromDefinition> getInterceptFroms();

    public abstract List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints();

    public abstract GlobalOptionsDefinition getGlobalOptions();

    public abstract String[] getPackages();

    public abstract PackageScanDefinition getPackageScan();

    public abstract void setPackageScan(PackageScanDefinition var1);

    public abstract ContextScanDefinition getContextScan();

    public abstract void setContextScan(ContextScanDefinition var1);

    public abstract CamelPropertyPlaceholderDefinition getCamelPropertyPlaceholder();

    public abstract StartupSummaryLevel getStartupSummaryLevel();

    public abstract String getTrace();

    public abstract String getTracePattern();

    public abstract String getTraceLoggingFormat();

    public abstract String getBacklogTrace();

    public abstract String getDebug();

    public abstract String getMessageHistory();

    public abstract String getSourceLocationEnabled();

    public abstract String getLogMask();

    public abstract String getLogExhaustedMessageBody();

    public abstract String getStreamCache();

    public abstract String getDelayer();

    public abstract String getAutoStartup();

    public abstract String getUseMDCLogging();

    public abstract String getMDCLoggingKeysPattern();

    public abstract String getDumpRoutes();

    public abstract String getUseDataType();

    public abstract String getUseBreadcrumb();

    public abstract String getBeanPostProcessorEnabled();

    public abstract String getAllowUseOriginalMessage();

    public abstract String getCaseInsensitiveHeaders();

    public abstract String getAutowiredEnabled();

    public abstract String getRuntimeEndpointRegistryEnabled();

    public abstract String getManagementNamePattern();

    public abstract String getThreadNamePattern();

    public abstract String getLoadTypeConverters();

    public abstract String getLoadHealthChecks();

    public abstract String getInflightRepositoryBrowseEnabled();

    public abstract String getTypeConverterStatisticsEnabled();

    public abstract LoggingLevel getTypeConverterExistsLoggingLevel();

    public abstract TypeConverterExists getTypeConverterExists();

    public abstract CamelJMXAgentDefinition getCamelJMXAgent();

    public abstract CamelStreamCachingStrategyDefinition getCamelStreamCachingStrategy();

    public abstract CamelRouteControllerDefinition getCamelRouteController();

    public abstract List<RouteConfigurationContextRefDefinition> getRouteConfigurationRefs();

    public abstract List<RouteBuilderDefinition> getBuilderRefs();

    public abstract List<RouteContextRefDefinition> getRouteRefs();

    public abstract List<RouteTemplateContextRefDefinition> getRouteTemplateRefs();

    public abstract List<RestContextRefDefinition> getRestRefs();

    public abstract String getErrorHandlerRef();

    public abstract DataFormatsDefinition getDataFormats();

    public abstract TransformersDefinition getTransformers();

    public abstract ValidatorsDefinition getValidators();

    public abstract List<OnExceptionDefinition> getOnExceptions();

    public abstract List<OnCompletionDefinition> getOnCompletions();

    public abstract ShutdownRoute getShutdownRoute();

    public abstract ShutdownRunningTask getShutdownRunningTask();

    public abstract List<ThreadPoolProfileDefinition> getThreadPoolProfiles();

    public abstract String getDependsOn();

    public abstract List<AbstractCamelFactoryBean<?>> getBeansFactory();

    public abstract List<?> getBeans();

    public abstract ServiceCallConfigurationDefinition getDefaultServiceCallConfiguration();

    public abstract List<ServiceCallConfigurationDefinition> getServiceCallConfigurations();

    public abstract Resilience4jConfigurationDefinition getDefaultResilience4jConfiguration();

    public abstract List<Resilience4jConfigurationDefinition> getResilience4jConfigurations();

    public abstract FaultToleranceConfigurationDefinition getDefaultFaultToleranceConfiguration();

    public abstract List<FaultToleranceConfigurationDefinition> getFaultToleranceConfigurations();

    protected void initCamelContext(T context) throws Exception {
        CamelBeanPostProcessor cbpp;
        if (this.getStartupSummaryLevel() != null) {
            context.setStartupSummaryLevel(this.getStartupSummaryLevel());
        }
        if (this.getBeanPostProcessorEnabled() != null && (cbpp = context.adapt(ExtendedCamelContext.class).getBeanPostProcessor()) != null) {
            cbpp.setEnabled(CamelContextHelper.parseBoolean(context, this.getBeanPostProcessorEnabled()));
        }
        if (this.getStreamCache() != null) {
            context.setStreamCaching(CamelContextHelper.parseBoolean(context, this.getStreamCache()));
        }
        if (this.getTrace() != null) {
            String text = CamelContextHelper.parseText(context, this.getTrace());
            if ("standby".equalsIgnoreCase(text)) {
                context.setTracingStandby(true);
            } else {
                context.setTracing(CamelContextHelper.parseBoolean(context, this.getTrace()));
            }
        }
        if (this.getTracePattern() != null) {
            context.setTracingPattern(CamelContextHelper.parseText(context, this.getTracePattern()));
        }
        if (this.getTraceLoggingFormat() != null) {
            context.setTracingLoggingFormat(CamelContextHelper.parseText(context, this.getTraceLoggingFormat()));
        }
        if (this.getBacklogTrace() != null) {
            context.setBacklogTracing(CamelContextHelper.parseBoolean(context, this.getBacklogTrace()));
        }
        if (this.getDebug() != null) {
            context.setDebugging(CamelContextHelper.parseBoolean(context, this.getDebug()));
        }
        if (this.getMessageHistory() != null) {
            context.setMessageHistory(CamelContextHelper.parseBoolean(context, this.getMessageHistory()));
        }
        if (this.getSourceLocationEnabled() != null) {
            context.setSourceLocationEnabled(CamelContextHelper.parseBoolean(context, this.getSourceLocationEnabled()));
        }
        if (this.getLogMask() != null) {
            context.setLogMask(CamelContextHelper.parseBoolean(context, this.getLogMask()));
        }
        if (this.getLogExhaustedMessageBody() != null) {
            context.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean(context, this.getLogExhaustedMessageBody()));
        }
        if (this.getDelayer() != null) {
            context.setDelayer(CamelContextHelper.parseLong(context, this.getDelayer()));
        }
        if (this.getErrorHandlerRef() != null) {
            context.adapt(ExtendedCamelContext.class).setErrorHandlerFactory(new RefErrorHandlerDefinition(this.getErrorHandlerRef()));
        }
        if (this.getAutoStartup() != null) {
            context.setAutoStartup(CamelContextHelper.parseBoolean(context, this.getAutoStartup()));
        }
        if (this.getUseMDCLogging() != null) {
            context.setUseMDCLogging(CamelContextHelper.parseBoolean(context, this.getUseMDCLogging()));
        }
        if (this.getMDCLoggingKeysPattern() != null) {
            context.setMDCLoggingKeysPattern(CamelContextHelper.parseText(context, this.getMDCLoggingKeysPattern()));
        }
        if (this.getDumpRoutes() != null) {
            context.setDumpRoutes(CamelContextHelper.parseBoolean(context, this.getDumpRoutes()));
        }
        if (this.getUseDataType() != null) {
            context.setUseDataType(CamelContextHelper.parseBoolean(context, this.getUseDataType()));
        }
        if (this.getUseBreadcrumb() != null) {
            context.setUseBreadcrumb(CamelContextHelper.parseBoolean(context, this.getUseBreadcrumb()));
        }
        if (this.getAllowUseOriginalMessage() != null) {
            context.setAllowUseOriginalMessage(CamelContextHelper.parseBoolean(context, this.getAllowUseOriginalMessage()));
        }
        if (this.getCaseInsensitiveHeaders() != null) {
            context.setCaseInsensitiveHeaders(CamelContextHelper.parseBoolean(context, this.getCaseInsensitiveHeaders()));
        }
        if (this.getAutowiredEnabled() != null) {
            context.setAutowiredEnabled(CamelContextHelper.parseBoolean(context, this.getAutowiredEnabled()));
        }
        if (this.getRuntimeEndpointRegistryEnabled() != null) {
            context.getRuntimeEndpointRegistry().setEnabled(CamelContextHelper.parseBoolean(context, this.getRuntimeEndpointRegistryEnabled()));
        }
        if (this.getManagementNamePattern() != null) {
            context.getManagementNameStrategy().setNamePattern(CamelContextHelper.parseText(context, this.getManagementNamePattern()));
        }
        if (this.getThreadNamePattern() != null) {
            context.getExecutorServiceManager().setThreadNamePattern(CamelContextHelper.parseText(context, this.getThreadNamePattern()));
        }
        if (this.getShutdownRoute() != null) {
            context.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.getShutdownRunningTask() != null) {
            context.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        if (this.getDataFormats() != null) {
            context.setDataFormats(this.getDataFormats().asMap());
        }
        if (this.getTransformers() != null) {
            context.setTransformers(this.getTransformers().getTransformers());
        }
        if (this.getValidators() != null) {
            context.setValidators(this.getValidators().getValidators());
        }
        if (this.getInflightRepositoryBrowseEnabled() != null) {
            context.getInflightRepository().setInflightBrowseEnabled(CamelContextHelper.parseBoolean(context, this.getInflightRepositoryBrowseEnabled()));
        }
        if (this.getRestConfiguration() != null) {
            this.getRestConfiguration().asRestConfiguration(context, context.getRestConfiguration());
        }
        if (this.getDefaultServiceCallConfiguration() != null) {
            context.setServiceCallConfiguration(this.getDefaultServiceCallConfiguration());
        }
        if (this.getServiceCallConfigurations() != null) {
            for (ServiceCallConfigurationDefinition serviceCallConfigurationDefinition : this.getServiceCallConfigurations()) {
                context.addServiceCallConfiguration(serviceCallConfigurationDefinition.getId(), serviceCallConfigurationDefinition);
            }
        }
        if (this.getDefaultResilience4jConfiguration() != null) {
            context.setResilience4jConfiguration(this.getDefaultResilience4jConfiguration());
        }
        if (this.getResilience4jConfigurations() != null) {
            for (Resilience4jConfigurationDefinition resilience4jConfigurationDefinition : this.getResilience4jConfigurations()) {
                context.addResilience4jConfiguration(resilience4jConfigurationDefinition.getId(), resilience4jConfigurationDefinition);
            }
        }
        if (this.getDefaultFaultToleranceConfiguration() != null) {
            context.setFaultToleranceConfiguration(this.getDefaultFaultToleranceConfiguration());
        }
        if (this.getFaultToleranceConfigurations() != null) {
            for (FaultToleranceConfigurationDefinition faultToleranceConfigurationDefinition : this.getFaultToleranceConfigurations()) {
                context.addFaultToleranceConfiguration(faultToleranceConfigurationDefinition.getId(), faultToleranceConfigurationDefinition);
            }
        }
    }

    protected void initThreadPoolProfiles(T context) throws Exception {
        HashSet<String> defaultIds = new HashSet<String>();
        Map<String, ThreadPoolProfile> profiles = context.getRegistry().findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry<String, ThreadPoolProfile> entry : profiles.entrySet()) {
                ThreadPoolProfile profile = entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)entry.getKey(), (Object)profile);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (this.getThreadPoolProfiles() != null && !this.getThreadPoolProfiles().isEmpty()) {
            for (ThreadPoolProfileDefinition definition : this.getThreadPoolProfiles()) {
                Boolean defaultProfile = CamelContextHelper.parseBoolean(this.getContext(), definition.getDefaultProfile());
                if (defaultProfile != null && defaultProfile.booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)definition.getId(), (Object)definition);
                    context.getExecutorServiceManager().setDefaultThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
                    defaultIds.add(definition.getId());
                    continue;
                }
                context.getExecutorServiceManager().registerThreadPoolProfile(this.asThreadPoolProfile((CamelContext)context, definition));
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + defaultIds);
        }
    }

    private ThreadPoolProfile asThreadPoolProfile(CamelContext context, ThreadPoolProfileDefinition definition) throws Exception {
        ThreadPoolProfile answer = new ThreadPoolProfile();
        answer.setId(definition.getId());
        answer.setDefaultProfile(CamelContextHelper.parseBoolean(context, definition.getDefaultProfile()));
        answer.setPoolSize(CamelContextHelper.parseInteger(context, definition.getPoolSize()));
        answer.setMaxPoolSize(CamelContextHelper.parseInteger(context, definition.getMaxPoolSize()));
        answer.setKeepAliveTime(CamelContextHelper.parseLong(context, definition.getKeepAliveTime()));
        answer.setMaxQueueSize(CamelContextHelper.parseInteger(context, definition.getMaxQueueSize()));
        answer.setAllowCoreThreadTimeOut(CamelContextHelper.parseBoolean(context, definition.getAllowCoreThreadTimeOut()));
        answer.setRejectedPolicy(CamelContextHelper.parse(context, ThreadPoolRejectedPolicy.class, definition.getRejectedPolicy()));
        answer.setTimeUnit(CamelContextHelper.parse(context, TimeUnit.class, definition.getTimeUnit()));
        return answer;
    }

    protected abstract void initBeanPostProcessor(T var1);

    protected void installRoutes() throws Exception {
        ArrayList builders = new ArrayList();
        if (this.getBuilderRefs() != null) {
            for (RouteBuilderDefinition builderRef : this.getBuilderRefs()) {
                RoutesBuilder routes = builderRef.createRoutes((CamelContext)this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            this.postProcessBeforeInit(builder);
            this.getContext().addRoutes(builder);
        }
    }

    protected abstract void postProcessBeforeInit(RouteBuilder var1);

    protected void findRouteBuilders() throws Exception {
        ContextScanDefinition contextScanDef;
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && !packageScanDef.getPackages().isEmpty()) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String string : packageScanDef.getIncludes()) {
                String string2 = this.getContext().resolvePropertyPlaceholders(string);
                filter.addIncludePattern(string2);
            }
            for (String string : packageScanDef.getExcludes()) {
                String string3 = this.getContext().resolvePropertyPlaceholders(string);
                filter.addExcludePattern(string3);
            }
            String[] normalized = this.normalizePackages(this.getContext(), packageScanDef.getPackages());
            this.findRouteBuildersByPackageScan(normalized, filter, this.builders);
        }
        if ((contextScanDef = this.getContextScan()) != null) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            for (String include : contextScanDef.getIncludes()) {
                include = this.getContext().resolvePropertyPlaceholders(include);
                filter.addIncludePattern(include);
            }
            for (String exclude : contextScanDef.getExcludes()) {
                exclude = this.getContext().resolvePropertyPlaceholders(exclude);
                filter.addExcludePattern(exclude);
            }
            boolean bl = contextScanDef.getIncludeNonSingletons() != null && Boolean.parseBoolean(contextScanDef.getIncludeNonSingletons());
            this.findRouteBuildersByContextScan(filter, bl, this.builders);
        }
    }

    protected abstract void findRouteBuildersByPackageScan(String[] var1, PackageScanFilter var2, List<RoutesBuilder> var3) throws Exception;

    protected abstract void findRouteBuildersByContextScan(PackageScanFilter var1, boolean var2, List<RoutesBuilder> var3) throws Exception;

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(T context, List<String> unnormalized) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            name = context.resolvePropertyPlaceholders(name);
            if (!org.apache.camel.util.ObjectHelper.isNotEmpty(name = StringHelper.normalizeClassName(name))) continue;
            LOG.trace("Using package: {} to scan for RouteBuilder classes", (Object)name);
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }

    private void setupCustomServices() {
        ReactiveExecutor reactiveExecutor;
        MessageHistoryFactory messageHistoryFactory;
        StreamCachingStrategy streamCachingStrategy;
        NodeIdFactory nodeIdFactory;
        UuidGenerator uuidGenerator;
        Debugger debugger;
        ProcessorFactory processorFactory;
        ThreadPoolFactory threadPoolFactory;
        ExecutorServiceManager executorServiceStrategy;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        ModelJAXBContextFactory modelJAXBContextFactory = this.getBeanForType(ModelJAXBContextFactory.class);
        if (modelJAXBContextFactory != null) {
            LOG.info("Using custom ModelJAXBContextFactory: {}", (Object)modelJAXBContextFactory);
            this.getContext().adapt(ExtendedCamelContext.class).setModelJAXBContextFactory(modelJAXBContextFactory);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info("Using custom ClassResolver: {}", (Object)classResolver);
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info("Using custom FactoryFinderResolver: {}", (Object)factoryFinderResolver);
            this.getContext().adapt(ExtendedCamelContext.class).setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((executorServiceStrategy = this.getBeanForType(ExecutorServiceManager.class)) != null) {
            LOG.info("Using custom ExecutorServiceStrategy: {}", (Object)executorServiceStrategy);
            this.getContext().setExecutorServiceManager(executorServiceStrategy);
        }
        if ((threadPoolFactory = this.getBeanForType(ThreadPoolFactory.class)) != null) {
            LOG.info("Using custom ThreadPoolFactory: {}", (Object)threadPoolFactory);
            this.getContext().getExecutorServiceManager().setThreadPoolFactory(threadPoolFactory);
        }
        if ((processorFactory = this.getBeanForType(ProcessorFactory.class)) != null) {
            LOG.info("Using custom ProcessorFactory: {}", (Object)processorFactory);
            this.getContext().adapt(ExtendedCamelContext.class).setProcessorFactory(processorFactory);
        }
        if ((debugger = this.getBeanForType(Debugger.class)) != null) {
            LOG.info("Using custom Debugger: {}", (Object)debugger);
            this.getContext().setDebugger(debugger);
        }
        if ((uuidGenerator = this.getBeanForType(UuidGenerator.class)) != null) {
            LOG.info("Using custom UuidGenerator: {}", (Object)uuidGenerator);
            this.getContext().setUuidGenerator(uuidGenerator);
        }
        if ((nodeIdFactory = this.getBeanForType(NodeIdFactory.class)) != null) {
            LOG.info("Using custom NodeIdFactory: {}", (Object)nodeIdFactory);
            this.getContext().adapt(ExtendedCamelContext.class).setNodeIdFactory(nodeIdFactory);
        }
        if ((streamCachingStrategy = this.getBeanForType(StreamCachingStrategy.class)) != null) {
            LOG.info("Using custom StreamCachingStrategy: {}", (Object)streamCachingStrategy);
            this.getContext().setStreamCachingStrategy(streamCachingStrategy);
        }
        if ((messageHistoryFactory = this.getBeanForType(MessageHistoryFactory.class)) != null) {
            LOG.info("Using custom MessageHistoryFactory: {}", (Object)messageHistoryFactory);
            this.getContext().setMessageHistoryFactory(messageHistoryFactory);
        }
        if ((reactiveExecutor = this.getBeanForType(ReactiveExecutor.class)) != null) {
            this.getContext().adapt(ExtendedCamelContext.class).setReactiveExecutor(reactiveExecutor);
        }
    }
}

