/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.util.AntPathMatcher;

public class PatternBasedPackageScanFilter
implements PackageScanFilter {
    private final AntPathMatcher matcher = new AntPathMatcher();
    private List<String> excludePatterns;
    private List<String> includePatterns;

    public void addExcludePattern(String excludePattern) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.excludePatterns.add(excludePattern);
    }

    public void addIncludePattern(String includePattern) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.includePatterns.add(includePattern);
    }

    public void addIncludePatterns(Collection<String> includes) {
        if (this.includePatterns == null) {
            this.includePatterns = new ArrayList<String>();
        }
        this.includePatterns.addAll(includes);
    }

    public void addExcludePatterns(Collection<String> excludes) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new ArrayList<String>();
        }
        this.excludePatterns.addAll(excludes);
    }

    @Override
    public boolean matches(Class<?> candidateClass) {
        String candidate = candidateClass.getName();
        if (this.includePatterns != null || this.excludePatterns != null) {
            if (this.excludePatterns != null && !this.excludePatterns.isEmpty() && this.matchesAny(this.excludePatterns, candidate)) {
                return false;
            }
            if (this.includePatterns != null && !this.includePatterns.isEmpty()) {
                return this.matchesAny(this.includePatterns, candidate);
            }
        }
        return true;
    }

    private boolean matchesAny(List<String> patterns, String candidate) {
        for (String pattern : patterns) {
            if (!this.matcher.match(pattern, candidate)) continue;
            return true;
        }
        return false;
    }
}

