/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.AggregationStrategyBiFunctionAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.reifier.ProcessorReifier;

public class MulticastReifier
extends ProcessorReifier<MulticastDefinition> {
    public MulticastReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (MulticastDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor answer = this.createChildProcessor(true);
        if (!(answer instanceof MulticastProcessor)) {
            ArrayList<Processor> list = new ArrayList<Processor>(1);
            list.add(answer);
            answer = this.createCompositeProcessor(list);
        }
        return answer;
    }

    @Override
    protected Processor createCompositeProcessor(List<Processor> list) throws Exception {
        AggregationStrategy strategy = this.createAggregationStrategy();
        boolean isParallelProcessing = this.parseBoolean(((MulticastDefinition)this.definition).getParallelProcessing(), false);
        boolean isShareUnitOfWork = this.parseBoolean(((MulticastDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isStreaming = this.parseBoolean(((MulticastDefinition)this.definition).getStreaming(), false);
        boolean isStopOnException = this.parseBoolean(((MulticastDefinition)this.definition).getStopOnException(), false);
        boolean isParallelAggregate = this.parseBoolean(((MulticastDefinition)this.definition).getParallelAggregate(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("Multicast", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        long timeout = this.parseDuration(((MulticastDefinition)this.definition).getTimeout(), 0L);
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        Processor prepare = ((MulticastDefinition)this.definition).getOnPrepareProcessor();
        if (prepare == null && ((MulticastDefinition)this.definition).getOnPrepare() != null) {
            prepare = this.mandatoryLookup(((MulticastDefinition)this.definition).getOnPrepare(), Processor.class);
        }
        MulticastProcessor answer = new MulticastProcessor(this.camelContext, this.route, list, strategy, isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout, prepare, isShareUnitOfWork, isParallelAggregate);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((MulticastDefinition)this.definition).getAggregationStrategyBean();
        String ref = this.parseString(((MulticastDefinition)this.definition).getAggregationStrategy());
        if (strategy == null && ref != null) {
            Object aggStrategy = this.lookupByName(ref);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy instanceof BiFunction) {
                AggregationStrategyBiFunctionAdapter adapter = new AggregationStrategyBiFunctionAdapter((BiFunction)aggStrategy);
                if (((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.parseString(((MulticastDefinition)this.definition).getAggregationStrategyMethodName()));
                if (((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((MulticastDefinition)this.definition).getAggregationStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((MulticastDefinition)this.definition).getAggregationStrategy());
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        CamelContextAware.trySetCamelContext(strategy, this.camelContext);
        if (this.parseBoolean(((MulticastDefinition)this.definition).getShareUnitOfWork(), false)) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

