/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.function.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.PausableDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PausableProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.resume.ConsumerListener;
import org.apache.camel.util.ObjectHelper;

public class PausableReifier
extends ProcessorReifier<PausableDefinition> {
    public PausableReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (PausableDefinition)PausableDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        ConsumerListener<?, ?> consumerListener = this.resolveConsumerListener();
        ObjectHelper.notNull(consumerListener, "consumerListener");
        this.route.setConsumerListener(consumerListener);
        return new PausableProcessor(consumerListener, childProcessor);
    }

    protected ConsumerListener<?, ?> resolveConsumerListener() {
        ConsumerListener consumerListener = ((PausableDefinition)this.definition).getConsumerListenerBean();
        if (consumerListener == null) {
            String ref = ((PausableDefinition)this.definition).getConsumerListener();
            consumerListener = this.mandatoryLookup(ref, ConsumerListener.class);
        }
        Predicate<?> supplier = this.resolveUntilCheck();
        consumerListener.setResumableCheck(supplier);
        return consumerListener;
    }

    protected Predicate<?> resolveUntilCheck() {
        Predicate supplier = ((PausableDefinition)this.definition).getUntilCheckBean();
        if (supplier == null) {
            String ref = ((PausableDefinition)this.definition).getUntilCheck();
            supplier = this.mandatoryLookup(ref, Predicate.class);
        }
        return supplier;
    }
}

