/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.xml;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spring.SpringCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class PackageScanRouteBuilderFinder {
    private static final Logger LOG = LoggerFactory.getLogger(PackageScanRouteBuilderFinder.class);
    private final SpringCamelContext camelContext;
    private final String[] packages;
    private final PackageScanClassResolver resolver;
    private final ApplicationContext applicationContext;
    private final BeanPostProcessor beanPostProcessor;

    public PackageScanRouteBuilderFinder(SpringCamelContext camelContext, String[] packages, ClassLoader classLoader, BeanPostProcessor postProcessor, PackageScanClassResolver resolver) {
        this.camelContext = camelContext;
        this.applicationContext = camelContext.getApplicationContext();
        this.packages = packages;
        this.beanPostProcessor = postProcessor;
        this.resolver = resolver;
        resolver.addClassLoader(classLoader);
    }

    public void appendBuilders(List<RoutesBuilder> list) {
        Set<Class<?>> classes = this.resolver.findImplementations(RoutesBuilder.class, this.packages);
        for (Class<?> aClass : classes) {
            LOG.trace("Found RouteBuilder class: {}", aClass);
            if (this.shouldIgnoreBean(aClass)) {
                LOG.debug("Ignoring RouteBuilder class: {}", aClass);
                continue;
            }
            if (!this.isValidClass(aClass)) {
                LOG.debug("Ignoring invalid RouteBuilder class: {}", aClass);
                continue;
            }
            RoutesBuilder builder = this.instantiateBuilder(aClass);
            if (this.beanPostProcessor != null) {
                this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
            }
            LOG.debug("Adding instantiated RouteBuilder: {}", (Object)builder);
            list.add(builder);
        }
    }

    protected boolean shouldIgnoreBean(Class<?> type) {
        Map beans = this.applicationContext.getBeansOfType(type, true, true);
        return beans != null && !beans.isEmpty();
    }

    protected boolean isValidClass(Class<?> type) {
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        return !Modifier.isAbstract(type.getModifiers()) && !type.isInterface();
    }

    protected RoutesBuilder instantiateBuilder(Class<? extends RoutesBuilder> type) {
        return this.camelContext.getInjector().newInstance(type);
    }
}

