/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlPrepareStatementStrategy
implements SqlPrepareStatementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSqlPrepareStatementStrategy.class);
    private final char separator;

    public DefaultSqlPrepareStatementStrategy() {
        this(',');
    }

    public DefaultSqlPrepareStatementStrategy(char separator) {
        this.separator = separator;
    }

    @Override
    public String prepareQuery(String query, boolean allowNamedParameters) throws SQLException {
        String answer = allowNamedParameters && this.hasNamedParameters(query) ? query.replaceAll("\\:\\?\\w+", "\\?") : query;
        LOG.trace("Prepared query: {}", (Object)answer);
        return answer;
    }

    @Override
    public Iterator<?> createPopulateIterator(final String query, String preparedQuery, int expectedParams, final Exchange exchange, Object value) throws SQLException {
        if (this.hasNamedParameters(query)) {
            try {
                final Map bodyMap = (Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, value);
                final Map headerMap = exchange.getIn().hasHeaders() ? exchange.getIn().getHeaders() : null;
                return new Iterator<Object>(){
                    private NamedQueryParser parser;
                    private Object nextParam;
                    private boolean done;
                    {
                        this.parser = new NamedQueryParser(query);
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.done) {
                            return false;
                        }
                        if (this.nextParam == null) {
                            this.nextParam = this.parser.next();
                            if (this.nextParam == null) {
                                this.done = true;
                            }
                        }
                        return this.nextParam != null;
                    }

                    @Override
                    public Object next() {
                        Object next;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        boolean contains = bodyMap != null && bodyMap.containsKey(this.nextParam);
                        if (!(contains |= headerMap != null && headerMap.containsKey(this.nextParam))) {
                            throw new RuntimeExchangeException("Cannot find key [" + this.nextParam + "] in message body or headers to use when setting named parameter in query [" + query + "]", exchange);
                        }
                        Object v0 = next = bodyMap != null ? bodyMap.get(this.nextParam) : null;
                        if (next == null) {
                            next = headerMap != null ? headerMap.get(this.nextParam) : null;
                        }
                        this.nextParam = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            catch (Exception e) {
                throw new SQLException("The message body must be a java.util.Map type when using named parameters in the query: " + query, e);
            }
        }
        if (expectedParams == 1 && value instanceof String) {
            return Collections.singletonList(value).iterator();
        }
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)((String)value), (char)this.separator, (boolean)true);
            List<String> list = Arrays.asList(tokens);
            return list.iterator();
        }
        return (Iterator)exchange.getContext().getTypeConverter().convertTo(Iterator.class, value);
    }

    @Override
    public void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        int argNumber = 1;
        if (expectedParams > 0) {
            while (iterator != null && iterator.hasNext()) {
                Object value = iterator.next();
                LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
                ps.setObject(argNumber, value);
                ++argNumber;
            }
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was:" + (argNumber - 1));
        }
    }

    protected boolean hasNamedParameters(String query) {
        NamedQueryParser parser = new NamedQueryParser(query);
        return parser.next() != null;
    }

    private static final class NamedQueryParser {
        private static final Pattern PATTERN = Pattern.compile("\\:\\?(\\w+)");
        private final Matcher matcher;

        private NamedQueryParser(String query) {
            this.matcher = PATTERN.matcher(query);
        }

        public String next() {
            if (!this.matcher.find()) {
                return null;
            }
            return this.matcher.group(1);
        }
    }
}

