/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.util.StringQuoteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;

public class DefaultSqlPrepareStatementStrategy
implements SqlPrepareStatementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSqlPrepareStatementStrategy.class);
    private final char separator;

    public DefaultSqlPrepareStatementStrategy() {
        this(',');
    }

    public DefaultSqlPrepareStatementStrategy(char separator) {
        this.separator = separator;
    }

    @Override
    public String prepareQuery(String query, boolean allowNamedParameters) throws SQLException {
        String answer = allowNamedParameters && this.hasNamedParameters(query) ? query.replaceAll("\\:\\?\\w+|\\:\\?\\$\\{[^\\}]+\\}", "\\?") : query;
        LOG.trace("Prepared query: {}", (Object)answer);
        return answer;
    }

    @Override
    public Iterator<?> createPopulateIterator(String query, String preparedQuery, int expectedParams, Exchange exchange, Object value) throws SQLException {
        if (this.hasNamedParameters(query)) {
            return new PopulateIterator(query, exchange, value);
        }
        if (expectedParams == 1 && value instanceof String) {
            return Collections.singletonList(value).iterator();
        }
        if (value instanceof String) {
            String[] tokens = StringQuoteHelper.splitSafeQuote((String)((String)value), (char)this.separator, (boolean)true);
            List<String> list = Arrays.asList(tokens);
            return list.iterator();
        }
        return (Iterator)exchange.getContext().getTypeConverter().convertTo(Iterator.class, value);
    }

    @Override
    public void populateStatement(PreparedStatement ps, Iterator<?> iterator, int expectedParams) throws SQLException {
        if (expectedParams <= 0) {
            return;
        }
        Object[] args = new Object[expectedParams];
        int i = 0;
        int argNumber = 1;
        while (iterator != null && iterator.hasNext()) {
            Object value = iterator.next();
            LOG.trace("Setting parameter #{} with value: {}", (Object)argNumber, value);
            if (argNumber <= expectedParams) {
                args[i] = value;
            }
            ++argNumber;
            ++i;
        }
        if (argNumber - 1 != expectedParams) {
            throw new SQLException("Number of parameters mismatch. Expected: " + expectedParams + ", was: " + (argNumber - 1));
        }
        ArgumentPreparedStatementSetter setter = new ArgumentPreparedStatementSetter(args);
        setter.setValues(ps);
    }

    protected boolean hasNamedParameters(String query) {
        NamedQueryParser parser = new NamedQueryParser(query);
        return parser.next() != null;
    }

    private static final class PopulateIterator
    implements Iterator<Object> {
        private static final String MISSING_PARAMETER_EXCEPTION = "Cannot find key [%s] in message body or headers to use when setting named parameter in query [%s]";
        private final String query;
        private final NamedQueryParser parser;
        private final Exchange exchange;
        private final Map<?, ?> bodyMap;
        private final Map<?, ?> headersMap;
        private String nextParam;

        private PopulateIterator(String query, Exchange exchange, Object body) {
            this.query = query;
            this.parser = new NamedQueryParser(query);
            this.exchange = exchange;
            this.bodyMap = PopulateIterator.safeMap((Map)exchange.getContext().getTypeConverter().tryConvertTo(Map.class, body));
            this.headersMap = PopulateIterator.safeMap(exchange.getIn().getHeaders());
            this.nextParam = this.parser.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextParam != null;
        }

        @Override
        public Object next() {
            if (this.nextParam == null) {
                throw new NoSuchElementException();
            }
            try {
                if (this.nextParam.startsWith("${") && this.nextParam.endsWith("}")) {
                    Object object = SimpleLanguage.expression((String)this.nextParam).evaluate(this.exchange, Object.class);
                    return object;
                }
                if (this.bodyMap.containsKey(this.nextParam)) {
                    Object obj = this.bodyMap.get(this.nextParam);
                    return obj;
                }
                if (this.headersMap.containsKey(this.nextParam)) {
                    Object obj = this.headersMap.get(this.nextParam);
                    return obj;
                }
                throw new RuntimeExchangeException(String.format(MISSING_PARAMETER_EXCEPTION, this.nextParam, this.query), this.exchange);
            }
            finally {
                this.nextParam = this.parser.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static Map<?, ?> safeMap(Map<?, ?> map) {
            return map == null || map.isEmpty() ? Collections.emptyMap() : map;
        }
    }

    private static final class NamedQueryParser {
        private static final Pattern PATTERN = Pattern.compile("\\:\\?(\\w+|\\$\\{[^\\}]+\\})");
        private final Matcher matcher;

        private NamedQueryParser(String query) {
            this.matcher = PATTERN.matcher(query);
        }

        public String next() {
            if (!this.matcher.find()) {
                return null;
            }
            return this.matcher.group(1);
        }
    }
}

