/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.component.sql.DefaultSqlEndpoint;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.component.sql.SqlProcessingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;

public class DefaultSqlProcessingStrategy
implements SqlProcessingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSqlProcessingStrategy.class);
    private final SqlPrepareStatementStrategy sqlPrepareStatementStrategy;

    public DefaultSqlProcessingStrategy(SqlPrepareStatementStrategy sqlPrepareStatementStrategy) {
        this.sqlPrepareStatementStrategy = sqlPrepareStatementStrategy;
    }

    @Override
    public int commit(DefaultSqlEndpoint endpoint, final Exchange exchange, final Object data, JdbcTemplate jdbcTemplate, final String query) throws Exception {
        final String preparedQuery = this.sqlPrepareStatementStrategy.prepareQuery(query, endpoint.isAllowNamedParameters(), exchange);
        return jdbcTemplate.execute(preparedQuery, new PreparedStatementCallback<Integer>(){

            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int expected = ps.getParameterMetaData().getParameterCount();
                Iterator<?> iterator = DefaultSqlProcessingStrategy.this.sqlPrepareStatementStrategy.createPopulateIterator(query, preparedQuery, expected, exchange, data);
                if (iterator != null) {
                    DefaultSqlProcessingStrategy.this.sqlPrepareStatementStrategy.populateStatement(ps, iterator, expected);
                    LOG.trace("Execute query {}", (Object)query);
                    ps.execute();
                    int updateCount = ps.getUpdateCount();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Update count {}", (Object)updateCount);
                    }
                    return updateCount;
                }
                return 0;
            }
        });
    }

    @Override
    public int commitBatchComplete(DefaultSqlEndpoint endpoint, JdbcTemplate jdbcTemplate, final String query) throws Exception {
        String preparedQuery = this.sqlPrepareStatementStrategy.prepareQuery(query, endpoint.isAllowNamedParameters(), null);
        return jdbcTemplate.execute(preparedQuery, new PreparedStatementCallback<Integer>(){

            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int expected = ps.getParameterMetaData().getParameterCount();
                if (expected != 0) {
                    throw new IllegalArgumentException("Query onConsumeBatchComplete " + query + " cannot have parameters, was " + expected);
                }
                LOG.trace("Execute query {}", (Object)query);
                ps.execute();
                int updateCount = ps.getUpdateCount();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Update count {}", (Object)updateCount);
                }
                return updateCount;
            }
        });
    }
}

