/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class FileKeyPairProvider
extends AbstractKeyPairProvider {
    private String[] files;
    private PasswordFinder passwordFinder;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(String[] files) {
        this.files = files;
    }

    public FileKeyPairProvider(String[] files, PasswordFinder passwordFinder) {
        this.files = files;
        this.passwordFinder = passwordFinder;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        ArrayList<KeyPair> keys = new ArrayList<KeyPair>();
        for (int i = 0; i < this.files.length; ++i) {
            try {
                PEMParser r = new PEMParser(new InputStreamReader(new FileInputStream(this.files[i])));
                try {
                    Object o = r.readObject();
                    JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                    pemConverter.setProvider("BC");
                    if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                        JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                        PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.getPassword());
                        o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                    }
                    if (o instanceof PEMKeyPair) {
                        o = pemConverter.getKeyPair((PEMKeyPair)o);
                        keys.add((KeyPair)o);
                        continue;
                    }
                    if (!(o instanceof KeyPair)) continue;
                    keys.add((KeyPair)o);
                    continue;
                }
                finally {
                    r.close();
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to read key {}: {}", (Object)this.files[i], (Object)e);
            }
        }
        return keys;
    }
}

