/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.List;
import org.apache.sshd.client.auth.deprecated.UserAuth;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.ClientUserAuthServiceNew;
import org.apache.sshd.client.session.ClientUserAuthServiceOld;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.CloseableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientUserAuthService
implements Service {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ClientSessionImpl session;
    protected ClientUserAuthServiceNew delegateNew;
    protected ClientUserAuthServiceOld delegateOld;
    protected boolean started;

    public ClientUserAuthService(Session s) {
        if (!(s instanceof ClientSessionImpl)) {
            throw new IllegalStateException("Client side service used on server side");
        }
        this.session = (ClientSessionImpl)s;
    }

    @Override
    public ClientSessionImpl getSession() {
        return this.session;
    }

    @Override
    public void start() {
        if (this.delegateNew != null) {
            this.delegateNew.start();
        } else if (this.delegateOld != null) {
            this.delegateOld.start();
        }
        this.started = true;
    }

    @Override
    public void process(byte cmd, Buffer buffer) throws Exception {
        if (this.delegateNew != null) {
            this.delegateNew.process(cmd, buffer);
        } else if (this.delegateOld != null) {
            this.delegateOld.process(cmd, buffer);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public CloseFuture close(boolean immediately) {
        if (this.delegateNew != null) {
            return this.delegateNew.close(immediately);
        }
        if (this.delegateOld != null) {
            return this.delegateOld.close(immediately);
        }
        return CloseableUtils.closed();
    }

    public AuthFuture auth(UserAuth userAuth) throws IOException {
        if (this.delegateNew != null) {
            throw new IllegalStateException();
        }
        if (this.delegateOld == null) {
            this.delegateOld = new ClientUserAuthServiceOld(this.session);
            if (this.started) {
                this.delegateOld.start();
            }
        }
        return this.delegateOld.auth(userAuth);
    }

    public AuthFuture auth(List<Object> identities, String service) throws IOException {
        if (this.delegateOld != null || this.delegateNew != null) {
            throw new IllegalStateException();
        }
        this.delegateNew = new ClientUserAuthServiceNew(this.session);
        if (this.started) {
            this.delegateNew.start();
        }
        return this.delegateNew.auth(identities, service);
    }

    public static class Factory
    implements ServiceFactory {
        public String getName() {
            return "ssh-userauth";
        }

        public Service create(Session session) throws IOException {
            return new ClientUserAuthService(session);
        }
    }
}

