/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.sftp;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.SftpClient;
import org.apache.sshd.client.channel.ChannelSubsystem;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.util.Buffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSftpClient
implements SftpClient {
    public static final int SSH_FXP_INIT = 1;
    public static final int SSH_FXP_VERSION = 2;
    public static final int SSH_FXP_OPEN = 3;
    public static final int SSH_FXP_CLOSE = 4;
    public static final int SSH_FXP_READ = 5;
    public static final int SSH_FXP_WRITE = 6;
    public static final int SSH_FXP_LSTAT = 7;
    public static final int SSH_FXP_FSTAT = 8;
    public static final int SSH_FXP_SETSTAT = 9;
    public static final int SSH_FXP_FSETSTAT = 10;
    public static final int SSH_FXP_OPENDIR = 11;
    public static final int SSH_FXP_READDIR = 12;
    public static final int SSH_FXP_REMOVE = 13;
    public static final int SSH_FXP_MKDIR = 14;
    public static final int SSH_FXP_RMDIR = 15;
    public static final int SSH_FXP_REALPATH = 16;
    public static final int SSH_FXP_STAT = 17;
    public static final int SSH_FXP_RENAME = 18;
    public static final int SSH_FXP_READLINK = 19;
    public static final int SSH_FXP_SYMLINK = 20;
    public static final int SSH_FXP_STATUS = 101;
    public static final int SSH_FXP_HANDLE = 102;
    public static final int SSH_FXP_DATA = 103;
    public static final int SSH_FXP_NAME = 104;
    public static final int SSH_FXP_ATTRS = 105;
    public static final int SSH_FXP_EXTENDED = 200;
    public static final int SSH_FXP_EXTENDED_REPLY = 201;
    public static final int SSH_FX_OK = 0;
    public static final int SSH_FX_EOF = 1;
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    public static final int SSH_FX_PERMISSION_DENIED = 3;
    public static final int SSH_FX_FAILURE = 4;
    public static final int SSH_FX_BAD_MESSAGE = 5;
    public static final int SSH_FX_NO_CONNECTION = 6;
    public static final int SSH_FX_CONNECTION_LOST = 7;
    public static final int SSH_FX_OP_UNSUPPORTED = 8;
    public static final int SSH_FILEXFER_ATTR_SIZE = 1;
    public static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    public static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    public static final int SSH_FILEXFER_ATTR_ACMODTIME = 8;
    public static final int SSH_FILEXFER_ATTR_EXTENDED = Integer.MIN_VALUE;
    public static final int SSH_FXF_READ = 1;
    public static final int SSH_FXF_WRITE = 2;
    public static final int SSH_FXF_APPEND = 4;
    public static final int SSH_FXF_CREAT = 8;
    public static final int SSH_FXF_TRUNC = 16;
    public static final int SSH_FXF_EXCL = 32;
    private final ClientSession clientSession;
    private final ChannelSubsystem channel;
    private final Map<Integer, Buffer> messages;
    private final AtomicInteger cmdId = new AtomicInteger(100);
    private final Buffer receiveBuffer = new Buffer();
    private boolean closing;

    public DefaultSftpClient(ClientSession clientSession) throws IOException {
        this.clientSession = clientSession;
        this.channel = clientSession.createSubsystemChannel("sftp");
        this.messages = new HashMap<Integer, Buffer>();
        try {
            this.channel.setOut(new OutputStream(){

                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b}, 0, 1);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    DefaultSftpClient.this.data(b, off, len);
                }
            });
            this.channel.setErr(new ByteArrayOutputStream());
            this.channel.open().await();
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        this.channel.onClose(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map map = DefaultSftpClient.this.messages;
                synchronized (map) {
                    DefaultSftpClient.this.closing = true;
                    DefaultSftpClient.this.messages.notifyAll();
                }
            }
        });
        this.init();
    }

    @Override
    public void close() throws IOException {
        this.channel.close(false);
    }

    protected int data(byte[] buf, int start, int len) throws IOException {
        Buffer incoming = new Buffer(buf, start, len);
        if (this.receiveBuffer.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
            incoming = this.receiveBuffer;
        }
        int rpos = incoming.rpos();
        while (this.receive(incoming)) {
        }
        int read = incoming.rpos() - rpos;
        this.receiveBuffer.compact();
        if (this.receiveBuffer != incoming && incoming.available() > 0) {
            this.receiveBuffer.putBuffer(incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Buffer incoming) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putBuffer(incoming);
        buffer.rpos(5);
        int id = buffer.getInt();
        buffer.rpos(0);
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            this.messages.put(id, buffer);
            this.messages.notifyAll();
        }
    }

    protected int send(int cmd, Buffer buffer) throws IOException {
        int id = this.cmdId.incrementAndGet();
        DataOutputStream dos = new DataOutputStream(this.channel.getInvertedIn());
        dos.writeInt(5 + buffer.available());
        dos.writeByte(cmd);
        dos.writeInt(id);
        dos.write(buffer.array(), buffer.rpos(), buffer.available());
        dos.flush();
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Buffer receive(int id) throws IOException {
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            while (true) {
                if (this.closing) {
                    throw new SshException("Channel has been closed");
                }
                Buffer buffer = this.messages.get(id);
                if (buffer != null) {
                    return buffer;
                }
                try {
                    this.messages.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
        }
    }

    protected Buffer read() throws IOException {
        int l;
        DataInputStream dis = new DataInputStream(this.channel.getInvertedOut());
        int length = dis.readInt();
        if (length < 5) {
            throw new IllegalArgumentException();
        }
        Buffer buffer = new Buffer(length + 4);
        buffer.putInt(length);
        for (int nb = length; nb > 0; nb -= l) {
            l = dis.read(buffer.array(), buffer.wpos(), nb);
            if (l < 0) {
                throw new IllegalArgumentException();
            }
            buffer.wpos(buffer.wpos() + l);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws IOException {
        DataOutputStream dos = new DataOutputStream(this.channel.getInvertedIn());
        dos.writeInt(5);
        dos.writeByte(1);
        dos.writeInt(3);
        dos.flush();
        Buffer buffer = null;
        Map<Integer, Buffer> map = this.messages;
        synchronized (map) {
            while (this.messages.isEmpty()) {
                try {
                    this.messages.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            buffer = this.messages.remove(this.messages.keySet().iterator().next());
        }
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 2) {
            if (id != 3) {
                throw new SshException("Unable to use SFTP v3, server replied with version " + id);
            }
        } else {
            if (type == 101) {
                int substatus = buffer.getInt();
                String msg = buffer.getString();
                String lang = buffer.getString();
                throw new SshException("SFTP error (" + substatus + "): " + msg);
            }
            throw new SshException("Unexpected SFTP packet received: " + type);
        }
    }

    protected void checkStatus(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (substatus != 0) {
                throw new SshException("SFTP error (" + substatus + "): " + msg);
            }
        } else {
            throw new SshException("Unexpected SFTP packet received: " + type);
        }
    }

    protected SftpClient.Handle checkHandle(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            throw new SshException("SFTP error (" + substatus + "): " + msg);
        }
        if (type == 102) {
            String handle = buffer.getString();
            return new SftpClient.Handle(handle);
        }
        throw new SshException("Unexpected SFTP packet received: " + type);
    }

    protected SftpClient.Attributes checkAttributes(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            throw new SshException("SFTP error (" + substatus + "): " + msg);
        }
        if (type == 105) {
            return this.readAttributes(buffer);
        }
        throw new SshException("Unexpected SFTP packet received: " + type);
    }

    protected String checkOneName(Buffer buffer) throws IOException {
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            throw new SshException("SFTP error (" + substatus + "): " + msg);
        }
        if (type == 104) {
            int len = buffer.getInt();
            if (len != 1) {
                throw new SshException("SFTP error: received " + len + " names instead of 1");
            }
            String name = buffer.getString();
            String longName = buffer.getString();
            SftpClient.Attributes attrs = this.readAttributes(buffer);
            return name;
        }
        throw new SshException("Unexpected SFTP packet received: " + type);
    }

    protected SftpClient.Attributes readAttributes(Buffer buffer) throws IOException {
        SftpClient.Attributes attrs = new SftpClient.Attributes();
        int flags = buffer.getInt();
        if ((flags & 1) != 0) {
            attrs.flags.add(SftpClient.Attribute.Size);
            attrs.size = buffer.getLong();
        }
        if ((flags & 2) != 0) {
            attrs.flags.add(SftpClient.Attribute.UidGid);
            attrs.uid = buffer.getInt();
            attrs.gid = buffer.getInt();
        }
        if ((flags & 4) != 0) {
            attrs.flags.add(SftpClient.Attribute.Perms);
            attrs.perms = buffer.getInt();
        }
        if ((flags & 8) != 0) {
            attrs.flags.add(SftpClient.Attribute.AcModTime);
            attrs.atime = buffer.getInt();
            attrs.mtime = buffer.getInt();
        }
        return attrs;
    }

    protected void writeAttributes(Buffer buffer, SftpClient.Attributes attributes) throws IOException {
        int flags = 0;
        for (SftpClient.Attribute a : attributes.flags) {
            switch (a) {
                case Size: {
                    flags |= 1;
                    break;
                }
                case UidGid: {
                    flags |= 2;
                    break;
                }
                case Perms: {
                    flags |= 4;
                    break;
                }
                case AcModTime: {
                    flags |= 8;
                }
            }
        }
        buffer.putInt(flags);
        if ((flags & 1) != 0) {
            buffer.putLong(attributes.size);
        }
        if ((flags & 2) != 0) {
            buffer.putInt(attributes.uid);
            buffer.putInt(attributes.gid);
        }
        if ((flags & 4) != 0) {
            buffer.putInt(attributes.perms);
        }
        if ((flags & 8) != 0) {
            buffer.putInt(attributes.atime);
            buffer.putInt(attributes.mtime);
        }
    }

    @Override
    public SftpClient.Handle open(String path, EnumSet<SftpClient.OpenMode> options) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        int mode = 0;
        for (SftpClient.OpenMode m : options) {
            switch (m) {
                case Read: {
                    mode |= 1;
                    break;
                }
                case Write: {
                    mode |= 2;
                    break;
                }
                case Append: {
                    mode |= 4;
                    break;
                }
                case Create: {
                    mode |= 8;
                    break;
                }
                case Truncate: {
                    mode |= 0x10;
                    break;
                }
                case Exclusive: {
                    mode |= 0x20;
                }
            }
        }
        buffer.putInt(mode);
        buffer.putInt(0L);
        return this.checkHandle(this.receive(this.send(3, buffer)));
    }

    @Override
    public void close(SftpClient.Handle handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        this.checkStatus(this.receive(this.send(4, buffer)));
    }

    @Override
    public void remove(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        this.checkStatus(this.receive(this.send(13, buffer)));
    }

    @Override
    public void rename(String oldPath, String newPath) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(oldPath);
        buffer.putString(newPath);
        this.checkStatus(this.receive(this.send(18, buffer)));
    }

    @Override
    public int read(SftpClient.Handle handle, long fileOffset, byte[] dst, int dstoff, int len) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        buffer.putLong(fileOffset);
        buffer.putInt(len);
        buffer = this.receive(this.send(5, buffer));
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (substatus == 1) {
                return -1;
            }
            throw new SshException("SFTP error (" + substatus + "): " + msg);
        }
        if (type == 103) {
            len = buffer.getInt();
            buffer.getRawBytes(dst, dstoff, len);
            return len;
        }
        throw new SshException("Unexpected SFTP packet received: " + type);
    }

    @Override
    public void write(SftpClient.Handle handle, long fileOffset, byte[] src, int srcoff, int len) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        buffer.putLong(fileOffset);
        buffer.putBytes(src, srcoff, len);
        this.checkStatus(this.receive(this.send(6, buffer)));
    }

    @Override
    public void mkdir(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        buffer.putInt(0L);
        this.checkStatus(this.receive(this.send(14, buffer)));
    }

    @Override
    public void rmdir(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        this.checkStatus(this.receive(this.send(15, buffer)));
    }

    @Override
    public SftpClient.Handle openDir(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        return this.checkHandle(this.receive(this.send(11, buffer)));
    }

    @Override
    public SftpClient.DirEntry[] readDir(SftpClient.Handle handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        buffer = this.receive(this.send(12, buffer));
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        if (type == 101) {
            int substatus = buffer.getInt();
            String msg = buffer.getString();
            String lang = buffer.getString();
            if (substatus == 1) {
                return null;
            }
            throw new SshException("SFTP error (" + substatus + "): " + msg);
        }
        if (type == 104) {
            int len = buffer.getInt();
            SftpClient.DirEntry[] entries = new SftpClient.DirEntry[len];
            for (int i = 0; i < len; ++i) {
                String name = buffer.getString();
                String longName = buffer.getString();
                SftpClient.Attributes attrs = this.readAttributes(buffer);
                entries[i] = new SftpClient.DirEntry(name, longName, attrs);
            }
            return entries;
        }
        throw new SshException("Unexpected SFTP packet received: " + type);
    }

    @Override
    public String canonicalPath(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        return this.checkOneName(this.receive(this.send(16, buffer)));
    }

    @Override
    public SftpClient.Attributes stat(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        return this.checkAttributes(this.receive(this.send(17, buffer)));
    }

    @Override
    public SftpClient.Attributes lstat(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        return this.checkAttributes(this.receive(this.send(7, buffer)));
    }

    @Override
    public SftpClient.Attributes stat(SftpClient.Handle handle) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        return this.checkAttributes(this.receive(this.send(8, buffer)));
    }

    @Override
    public void setStat(String path, SftpClient.Attributes attributes) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        this.writeAttributes(buffer, attributes);
        this.checkStatus(this.receive(this.send(9, buffer)));
    }

    @Override
    public void setStat(SftpClient.Handle handle, SftpClient.Attributes attributes) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(handle.id);
        this.writeAttributes(buffer, attributes);
        this.checkStatus(this.receive(this.send(10, buffer)));
    }

    @Override
    public String readLink(String path) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(path);
        return this.checkOneName(this.receive(this.send(19, buffer)));
    }

    @Override
    public void symLink(String linkPath, String targetPath) throws IOException {
        Buffer buffer = new Buffer();
        buffer.putString(linkPath);
        buffer.putString(targetPath);
        this.checkStatus(this.receive(this.send(18, buffer)));
    }

    @Override
    public Iterable<SftpClient.DirEntry> readDir(final String path) throws IOException {
        return new Iterable<SftpClient.DirEntry>(){

            @Override
            public Iterator<SftpClient.DirEntry> iterator() {
                return new Iterator<SftpClient.DirEntry>(){
                    SftpClient.Handle handle;
                    SftpClient.DirEntry[] entries;
                    int index;
                    {
                        this.open();
                        this.load();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entries != null && this.index < this.entries.length;
                    }

                    @Override
                    public SftpClient.DirEntry next() {
                        SftpClient.DirEntry entry = this.entries[this.index++];
                        if (this.index >= this.entries.length) {
                            this.load();
                        }
                        return entry;
                    }

                    private void open() {
                        try {
                            this.handle = DefaultSftpClient.this.openDir(path);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    private void load() {
                        try {
                            this.entries = DefaultSftpClient.this.readDir(this.handle);
                            this.index = 0;
                            if (this.entries == null) {
                                DefaultSftpClient.this.close(this.handle);
                            }
                        }
                        catch (IOException e) {
                            this.entries = null;
                            try {
                                DefaultSftpClient.this.close(this.handle);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public InputStream read(final String path) throws IOException {
        return new InputStream(){
            byte[] buffer = new byte[32768];
            int index = 0;
            int available = 0;
            SftpClient.Handle handle = DefaultSftpClient.this.open(path, EnumSet.of(SftpClient.OpenMode.Read));
            long offset;

            public int read() throws IOException {
                byte[] buffer = new byte[1];
                int read = this.read(buffer, 0, 1);
                if (read > 0) {
                    return buffer[0];
                }
                return read;
            }

            public int read(byte[] b, int off, int len) throws IOException {
                int idx = off;
                while (len > 0) {
                    if (this.index >= this.available) {
                        this.available = DefaultSftpClient.this.read(this.handle, this.offset, this.buffer, 0, this.buffer.length);
                        if (this.available < 0) {
                            if (idx != off) break;
                            return -1;
                        }
                        this.offset += (long)this.available;
                        this.index = 0;
                    }
                    if (this.index >= this.available) break;
                    int nb = Math.min(len, this.available - this.index);
                    System.arraycopy(this.buffer, this.index, b, idx, nb);
                    this.index += nb;
                    idx += nb;
                    len -= nb;
                }
                return idx - off;
            }

            public void close() throws IOException {
                DefaultSftpClient.this.close(this.handle);
            }
        };
    }

    @Override
    public OutputStream write(final String path) throws IOException {
        return new OutputStream(){
            byte[] buffer = new byte[32768];
            int index = 0;
            SftpClient.Handle handle = DefaultSftpClient.this.open(path, EnumSet.of(SftpClient.OpenMode.Write));
            long offset;

            public void write(int b) throws IOException {
                byte[] buffer = new byte[]{(byte)b};
                this.write(buffer, 0, 1);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                int nb;
                do {
                    nb = Math.min(len, this.buffer.length - this.index);
                    System.arraycopy(b, off, this.buffer, this.index, nb);
                    this.index += nb;
                    if (this.index != this.buffer.length) continue;
                    this.flush();
                } while ((len -= nb) > 0);
            }

            public void flush() throws IOException {
                DefaultSftpClient.this.write(this.handle, this.offset, this.buffer, 0, this.index);
                this.offset += (long)this.index;
                this.index = 0;
            }

            public void close() throws IOException {
                DefaultSftpClient.this.close(this.handle);
            }
        };
    }
}

