/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileKeyPairProvider
extends AbstractKeyPairProvider {
    private String[] files;
    private PasswordFinder passwordFinder;

    public FileKeyPairProvider() {
    }

    public FileKeyPairProvider(String[] files) {
        this.files = files;
    }

    public FileKeyPairProvider(String[] files, PasswordFinder passwordFinder) {
        this.files = files;
        this.passwordFinder = passwordFinder;
    }

    public String[] getFiles() {
        return this.files;
    }

    public void setFiles(String[] files) {
        this.files = files;
    }

    public PasswordFinder getPasswordFinder() {
        return this.passwordFinder;
    }

    public void setPasswordFinder(PasswordFinder passwordFinder) {
        this.passwordFinder = passwordFinder;
    }

    @Override
    public Iterable<KeyPair> loadKeys() {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new IllegalStateException("BouncyCastle must be registered as a JCE provider");
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return new Iterator<KeyPair>(){
                    private final Iterator<String> iterator;
                    private KeyPair nextKeyPair;
                    private boolean nextKeyPairSet;
                    {
                        this.iterator = Arrays.asList(FileKeyPairProvider.this.files).iterator();
                        this.nextKeyPairSet = false;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextKeyPairSet || this.setNextObject();
                    }

                    @Override
                    public KeyPair next() {
                        if (!this.nextKeyPairSet && !this.setNextObject()) {
                            throw new NoSuchElementException();
                        }
                        this.nextKeyPairSet = false;
                        return this.nextKeyPair;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private boolean setNextObject() {
                        while (this.iterator.hasNext()) {
                            String file = this.iterator.next();
                            this.nextKeyPair = FileKeyPairProvider.this.doLoadKey(file);
                            if (this.nextKeyPair == null) continue;
                            this.nextKeyPairSet = true;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeyPair doLoadKey(String file) {
        try {
            PEMParser r = new PEMParser(new InputStreamReader(new FileInputStream(file)));
            try {
                KeyPair keyPair;
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider("BC");
                if (this.passwordFinder != null && o instanceof PEMEncryptedKeyPair) {
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(this.passwordFinder.getPassword());
                    o = pemConverter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor));
                }
                if (o instanceof PEMKeyPair) {
                    o = pemConverter.getKeyPair((PEMKeyPair)o);
                    keyPair = (KeyPair)o;
                    return keyPair;
                }
                if (!(o instanceof KeyPair)) return null;
                keyPair = (KeyPair)o;
                return keyPair;
            }
            finally {
                r.close();
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to read key " + file, (Throwable)e);
        }
        return null;
    }
}

