/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtils.class);
    private static String securityProvider = null;
    private static Boolean registerBouncyCastle;
    private static boolean registrationDone;
    private static Boolean hasEcc;

    public static boolean hasEcc() {
        if (hasEcc == null) {
            try {
                SecurityUtils.getKeyPairGenerator("EC");
                hasEcc = true;
            }
            catch (Throwable t) {
                hasEcc = false;
            }
        }
        return hasEcc;
    }

    public static synchronized void setSecurityProvider(String securityProvider) {
        SecurityUtils.securityProvider = securityProvider;
        registrationDone = false;
    }

    public static synchronized void setRegisterBouncyCastle(boolean registerBouncyCastle) {
        SecurityUtils.registerBouncyCastle = registerBouncyCastle;
        registrationDone = false;
    }

    public static synchronized String getSecurityProvider() {
        SecurityUtils.register();
        return securityProvider;
    }

    public static synchronized boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return BOUNCY_CASTLE.equals(securityProvider);
    }

    private static void register() {
        if (!registrationDone) {
            String prop;
            if (registerBouncyCastle == null && (prop = System.getProperty("org.apache.sshd.registerBouncyCastle")) != null) {
                registerBouncyCastle = Boolean.parseBoolean(prop);
            }
            if (securityProvider == null && (registerBouncyCastle == null || registerBouncyCastle.booleanValue())) {
                try {
                    new BouncyCastleRegistration().run();
                }
                catch (Throwable t) {
                    if (registerBouncyCastle == null) {
                        LOG.info("BouncyCastle not registered, using the default JCE provider");
                    }
                    LOG.error("Failed to register BouncyCastle as the defaut JCE provider");
                    throw new RuntimeException("Failed to register BouncyCastle as the defaut JCE provider", t);
                }
            }
            registrationDone = true;
        }
    }

    public static synchronized KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Cipher.getInstance(transformation);
        }
        return Cipher.getInstance(transformation, SecurityUtils.getSecurityProvider());
    }

    public static synchronized MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return MessageDigest.getInstance(algorithm);
        }
        return MessageDigest.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyPairGenerator.getInstance(algorithm);
        }
        return KeyPairGenerator.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized KeyAgreement getKeyAgreement(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return KeyAgreement.getInstance(algorithm);
        }
        return KeyAgreement.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized Mac getMac(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Mac.getInstance(algorithm);
        }
        return Mac.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    public static synchronized Signature getSignature(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityUtils.register();
        if (SecurityUtils.getSecurityProvider() == null) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, SecurityUtils.getSecurityProvider());
    }

    private static class BouncyCastleRegistration {
        private BouncyCastleRegistration() {
        }

        public void run() throws Exception {
            if (Security.getProvider(SecurityUtils.BOUNCY_CASTLE) == null) {
                LOG.info("Trying to register BouncyCastle as a JCE provider");
                Security.addProvider(new BouncyCastleProvider());
                MessageDigest.getInstance("MD5", SecurityUtils.BOUNCY_CASTLE);
                KeyAgreement.getInstance("DH", SecurityUtils.BOUNCY_CASTLE);
                LOG.info("Registration succeeded");
            } else {
                LOG.info("BouncyCastle already registered as a JCE provider");
            }
            securityProvider = SecurityUtils.BOUNCY_CASTLE;
        }
    }
}

