/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.kex;

import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.sshd.common.Digest;
import org.apache.sshd.common.KeyExchange;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Random;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.digest.SHA1;
import org.apache.sshd.common.kex.DH;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.kex.Moduli;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DHGEX
implements KeyExchange {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServerSession session;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private Digest hash;
    private DH dh;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private byte[] H;
    int min;
    int prf;
    int max;
    private byte expected;

    public void init(AbstractSession s, byte[] V_S, byte[] V_C, byte[] I_S, byte[] I_C) throws Exception {
        if (!(s instanceof ServerSession)) {
            throw new IllegalStateException("Using a server side KeyExchange on a client");
        }
        this.session = (ServerSession)s;
        this.V_S = V_S;
        this.V_C = V_C;
        this.I_S = I_S;
        this.I_C = I_C;
        this.expected = (byte)34;
    }

    public boolean next(Buffer buffer) throws Exception {
        byte cmd = buffer.getByte();
        if (cmd != this.expected) {
            throw new SshException(3, "Protocol error: expected packet " + this.expected + ", got " + cmd);
        }
        if (cmd == 34) {
            this.log.debug("Received SSH_MSG_KEX_DH_GEX_REQUEST");
            this.min = buffer.getInt();
            this.prf = buffer.getInt();
            this.max = buffer.getInt();
            if (this.max < this.min || this.prf < this.min || this.max < this.prf) {
                throw new SshException(3, "Protocol error: bad parameters " + this.min + " !< " + this.prf + " !< " + this.max);
            }
            this.dh = this.chooseDH(this.min, this.prf, this.max);
            this.f = this.dh.getE();
            this.hash = this.dh.getHash();
            this.hash.init();
            this.log.debug("Send SSH_MSG_KEX_DH_GEX_GROUP");
            buffer = this.session.createBuffer((byte)31);
            buffer.putMPInt(this.dh.getP());
            buffer.putMPInt(this.dh.getG());
            this.session.writePacket(buffer);
            this.expected = (byte)32;
            return false;
        }
        if (cmd == 32) {
            this.log.debug("Received SSH_MSG_KEX_DH_GEX_INIT");
            this.e = buffer.getMPIntAsBytes();
            this.dh.setF(this.e);
            this.K = this.dh.getK();
            KeyPair kp = this.session.getHostKey();
            String algo = this.session.getNegotiated(1);
            Signature sig = (Signature)NamedFactory.Utils.create(this.session.getFactoryManager().getSignatureFactories(), algo);
            sig.init(kp.getPublic(), kp.getPrivate());
            buffer = new Buffer();
            buffer.putRawPublicKey(kp.getPublic());
            byte[] K_S = buffer.getCompactData();
            buffer.clear();
            buffer.putString(this.V_C);
            buffer.putString(this.V_S);
            buffer.putString(this.I_C);
            buffer.putString(this.I_S);
            buffer.putString(K_S);
            buffer.putInt(this.min);
            buffer.putInt(this.prf);
            buffer.putInt(this.max);
            buffer.putMPInt(this.dh.getP());
            buffer.putMPInt(this.dh.getG());
            buffer.putMPInt(this.e);
            buffer.putMPInt(this.f);
            buffer.putMPInt(this.K);
            this.hash.update(buffer.array(), 0, buffer.available());
            this.H = this.hash.digest();
            buffer.clear();
            sig.update(this.H, 0, this.H.length);
            buffer.putString(algo);
            buffer.putString(sig.sign());
            byte[] sigH = buffer.getCompactData();
            if (this.log.isDebugEnabled()) {
                this.log.debug("K_S:  {}", (Object)BufferUtils.printHex(K_S));
                this.log.debug("f:    {}", (Object)BufferUtils.printHex(this.f));
                this.log.debug("sigH: {}", (Object)BufferUtils.printHex(sigH));
            }
            this.log.debug("Send SSH_MSG_KEX_DH_GEX_REPLY");
            buffer.clear();
            buffer.rpos(5);
            buffer.wpos(5);
            buffer.putByte((byte)33);
            buffer.putString(K_S);
            buffer.putString(this.f);
            buffer.putString(sigH);
            this.session.writePacket(buffer);
            return true;
        }
        return false;
    }

    private DH chooseDH(int min, int prf, int max) throws Exception {
        URL moduli = this.getClass().getResource("/org/apache/sshd/moduli");
        List<Moduli.DhGroup> groups = Moduli.parseModuli(moduli);
        min = Math.max(min, 1024);
        prf = Math.max(prf, 1024);
        prf = Math.min(prf, SecurityUtils.isBouncyCastleRegistered() ? 8192 : 1024);
        max = Math.min(max, 8192);
        int bestSize = 0;
        ArrayList<Moduli.DhGroup> selected = new ArrayList<Moduli.DhGroup>();
        for (Moduli.DhGroup group : groups) {
            if (group.size < min || group.size > max) continue;
            if (group.size > prf && group.size < bestSize || group.size > bestSize && bestSize < prf) {
                bestSize = group.size;
                selected.clear();
            }
            if (group.size != bestSize) continue;
            selected.add(group);
        }
        if (selected.isEmpty()) {
            throw new IllegalArgumentException("No suitable primes");
        }
        Random random = this.session.getFactoryManager().getRandomFactory().create();
        int which = random.random(selected.size());
        Moduli.DhGroup group = (Moduli.DhGroup)selected.get(which);
        return this.getDH(group.p, group.g);
    }

    protected DH getDH(BigInteger p, BigInteger g) throws Exception {
        DH dh = new DH(new SHA1.Factory());
        dh.setP(p);
        dh.setG(g);
        return dh;
    }

    public Digest getHash() {
        return this.hash;
    }

    public byte[] getH() {
        return this.H;
    }

    public byte[] getK() {
        return this.K;
    }

    public PublicKey getServerKey() {
        return this.session.getHostKey().getPublic();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<KeyExchange> {
        @Override
        public String getName() {
            return "diffie-hellman-group-exchange-sha1";
        }

        @Override
        public KeyExchange create() {
            return new DHGEX();
        }
    }
}

