/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.keyprovider;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class PEMGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public PEMGeneratorHostKeyProvider() {
    }

    public PEMGeneratorHostKeyProvider(String path) {
        super(path);
    }

    public PEMGeneratorHostKeyProvider(String path, String algorithm) {
        super(path, algorithm);
    }

    public PEMGeneratorHostKeyProvider(String path, String algorithm, int keySize) {
        super(path, algorithm, keySize);
    }

    protected KeyPair doReadKeyPair(InputStream is) throws Exception {
        PEMParser r = new PEMParser(new InputStreamReader(is));
        Object o = r.readObject();
        JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
        pemConverter.setProvider("BC");
        if (o instanceof PEMKeyPair) {
            o = pemConverter.getKeyPair((PEMKeyPair)o);
            return (KeyPair)o;
        }
        if (o instanceof KeyPair) {
            return (KeyPair)o;
        }
        return null;
    }

    protected void doWriteKeyPair(KeyPair kp, OutputStream os) throws Exception {
        PEMWriter w = new PEMWriter(new OutputStreamWriter(os));
        w.writeObject(kp);
        w.flush();
    }
}

