/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyValidationException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.util.io.TeeInputStream;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        return this.getSymmetricAlgorithm(pGPPrivateKey, PGPUtil.getProvider(string));
    }

    public int getSymmetricAlgorithm(PGPPrivateKey pGPPrivateKey, Provider provider) throws PGPException, NoSuchProviderException {
        return this.getSymmetricAlgorithm(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(provider).setContentProvider(provider).build(pGPPrivateKey));
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        return byArray[0];
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string) throws PGPException, NoSuchProviderException {
        return this.getDataStream(pGPPrivateKey, string, string);
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, Provider provider) throws PGPException {
        return this.getDataStream(pGPPrivateKey, provider, provider);
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, String string, String string2) throws PGPException, NoSuchProviderException {
        return this.getDataStream(pGPPrivateKey, PGPUtil.getProvider(string), PGPUtil.getProvider(string2));
    }

    public InputStream getDataStream(PGPPrivateKey pGPPrivateKey, Provider provider, Provider provider2) throws PGPException {
        return this.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(provider).setContentProvider(provider2).build(pGPPrivateKey));
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (!this.confirmCheckSum(byArray)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        if (byArray[0] != 0) {
            try {
                int n;
                int n2;
                boolean bl = this.encData instanceof SymmetricEncIntegrityPacket;
                byte[] byArray2 = new byte[byArray.length - 3];
                System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                PGPDataDecryptor pGPDataDecryptor = publicKeyDataDecryptorFactory.createDataDecryptor(bl, byArray[0] & 0xFF, byArray2);
                this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(this.encData.getInputStream()));
                if (bl) {
                    this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                    this.integrityCalculator = pGPDataDecryptor.getIntegrityCalculator();
                    this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
                }
                byte[] byArray3 = new byte[pGPDataDecryptor.getBlockSize()];
                for (n2 = 0; n2 != byArray3.length; ++n2) {
                    n = this.encStream.read();
                    if (n < 0) {
                        throw new EOFException("unexpected end of stream.");
                    }
                    byArray3[n2] = (byte)n;
                }
                n2 = this.encStream.read();
                n = this.encStream.read();
                if (n2 < 0 || n < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }
}

