/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            asymmetricBlockCipher.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("exception encrypting session info: " + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }
}

