/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import javax.crypto.Cipher;
import org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.bouncycastle.jcajce.ProviderJcaJceHelper;
import org.bouncycastle.jce.interfaces.ElGamalKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, BigInteger[] bigIntegerArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, bigIntegerArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new PublicKeyDataDecryptorFactory(){

            public byte[] recoverSessionData(int n, BigInteger[] bigIntegerArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(pGPPrivateKey), bigIntegerArray);
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }
        };
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, BigInteger[] bigIntegerArray) throws PGPException {
        Object object;
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            object = bigIntegerArray[0].toByteArray();
            if (object[0] == false) {
                cipher.update((byte[])object, 1, ((Object)object).length - 1);
            } else {
                cipher.update((byte[])object);
            }
        } else {
            object = (ElGamalKey)((Object)privateKey);
            int n2 = (object.getParameters().getP().bitLength() + 7) / 8;
            byte[] byArray = new byte[n2];
            byte[] byArray2 = bigIntegerArray[0].toByteArray();
            if (byArray2.length > n2) {
                cipher.update(byArray2, 1, byArray2.length - 1);
            } else {
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                cipher.update(byArray);
            }
            byArray2 = bigIntegerArray[1].toByteArray();
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = 0;
            }
            if (byArray2.length > n2) {
                cipher.update(byArray2, 1, byArray2.length - 1);
            } else {
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
                cipher.update(byArray);
            }
        }
        try {
            object = cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
        return object;
    }
}

