/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.codec;

import java.io.IOException;
import java.util.ArrayList;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.AbstractProtocolCodec;
import org.fusesource.hawtdispatch.util.BufferPools;
import org.fusesource.stomp.client.Constants;
import org.fusesource.stomp.codec.StompFrame;

public class StompProtocolCodec
extends AbstractProtocolCodec {
    private static final BufferPools BUFFER_POOLS = new BufferPools();
    private static final int max_command_length = 20;
    public int max_header_length = 10240;
    public int max_headers = 1000;
    public int max_data_length = 0x6400000;
    public boolean trim = false;
    final AbstractProtocolCodec.Action read_action = new AbstractProtocolCodec.Action(){

        public Object apply() throws IOException {
            Buffer line = StompProtocolCodec.this.readUntil((byte)10, 20, "The maximum command length was exceeded");
            if (line != null) {
                Buffer action = line.moveTail(-1);
                if (StompProtocolCodec.this.trim) {
                    action = action.trim();
                }
                if (action.length() > 0) {
                    StompFrame frame = new StompFrame(action.ascii());
                    StompProtocolCodec.this.nextDecodeAction = StompProtocolCodec.this.read_headers(frame);
                    return StompProtocolCodec.this.nextDecodeAction.apply();
                }
            }
            return null;
        }
    };

    public StompProtocolCodec() {
        this.bufferPools = BUFFER_POOLS;
    }

    protected void encode(Object value) throws IOException {
        StompFrame frame = (StompFrame)value;
        frame.write(this.nextWriteBuffer);
    }

    protected AbstractProtocolCodec.Action initialDecodeAction() {
        return this.read_action;
    }

    private AbstractProtocolCodec.Action read_headers(final StompFrame frame) {
        final AsciiBuffer[] contentLengthValue = new AsciiBuffer[1];
        final ArrayList headers = new ArrayList(10);
        return new AbstractProtocolCodec.Action(){

            public Object apply() throws IOException {
                Buffer line = StompProtocolCodec.this.readUntil((byte)10, StompProtocolCodec.this.max_header_length, "The maximum header length was exceeded");
                if (line != null) {
                    line = line.moveTail(-1);
                    if (line.length > 0) {
                        if (StompProtocolCodec.this.max_headers != -1 && headers.size() > StompProtocolCodec.this.max_headers) {
                            throw new IOException("The maximum number of headers was exceeded");
                        }
                        try {
                            int seperatorIndex = line.indexOf((byte)58);
                            if (seperatorIndex < 0) {
                                throw new IOException("Header line missing seperator [" + line.ascii() + "]");
                            }
                            Buffer name = line.slice(0, seperatorIndex);
                            if (StompProtocolCodec.this.trim) {
                                name = name.trim();
                            }
                            Buffer value = line.slice(seperatorIndex + 1, line.length());
                            if (StompProtocolCodec.this.trim) {
                                value = value.trim();
                            }
                            StompFrame.HeaderEntry entry = new StompFrame.HeaderEntry(name.ascii(), value.ascii());
                            if (entry.key.equals(Constants.CONTENT_LENGTH)) {
                                contentLengthValue[0] = entry.value;
                            }
                            headers.add(entry);
                        }
                        catch (Exception e) {
                            throw new IOException("Unable to parser header line [" + line + "]");
                        }
                    }
                    frame.setHeaders(headers);
                    AsciiBuffer contentLength = contentLengthValue[0];
                    if (contentLength != null) {
                        int length = 0;
                        try {
                            length = Integer.parseInt(contentLength.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Specified content-length is not a valid integer");
                        }
                        if (StompProtocolCodec.this.max_data_length != -1 && length > StompProtocolCodec.this.max_data_length) {
                            throw new IOException("The maximum data length was exceeded");
                        }
                        StompProtocolCodec.this.nextDecodeAction = StompProtocolCodec.this.read_binary_body(frame, length);
                    } else {
                        StompProtocolCodec.this.nextDecodeAction = StompProtocolCodec.this.read_text_body(frame);
                    }
                    return StompProtocolCodec.this.nextDecodeAction.apply();
                }
                return null;
            }
        };
    }

    private AbstractProtocolCodec.Action read_binary_body(final StompFrame frame, final int contentLength) {
        return new AbstractProtocolCodec.Action(){

            public Object apply() throws IOException {
                Buffer content = StompProtocolCodec.this.readBytes(contentLength + 1);
                if (content != null) {
                    if (content.get(contentLength) != 0) {
                        throw new IOException("Expected null termintor after " + contentLength + " content bytes");
                    }
                    frame.content(content.moveTail(-1));
                    StompProtocolCodec.this.nextDecodeAction = StompProtocolCodec.this.read_action;
                    return frame;
                }
                return null;
            }
        };
    }

    private AbstractProtocolCodec.Action read_text_body(final StompFrame frame) {
        return new AbstractProtocolCodec.Action(){

            public Object apply() throws IOException {
                Buffer content = StompProtocolCodec.this.readUntil((byte)0);
                if (content != null) {
                    StompProtocolCodec.this.nextDecodeAction = StompProtocolCodec.this.read_action;
                    frame.content(content.moveTail(-1));
                    return frame;
                }
                return null;
            }
        };
    }
}

