/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.stomp.jms.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MarshallingSupport {
    public static final byte NULL = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte BYTE_TYPE = 2;
    public static final byte CHAR_TYPE = 3;
    public static final byte SHORT_TYPE = 4;
    public static final byte INTEGER_TYPE = 5;
    public static final byte LONG_TYPE = 6;
    public static final byte DOUBLE_TYPE = 7;
    public static final byte FLOAT_TYPE = 8;
    public static final byte STRING_TYPE = 9;
    public static final byte BYTE_ARRAY_TYPE = 10;
    public static final byte MAP_TYPE = 11;
    public static final byte LIST_TYPE = 12;
    public static final byte BIG_STRING_TYPE = 13;

    private MarshallingSupport() {
    }

    public static void marshalPrimitiveMap(Map map, DataByteArrayOutputStream out) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(map.size());
            for (String name : map.keySet()) {
                out.writeUTF(name);
                Object value = map.get(name);
                MarshallingSupport.marshalPrimitive(out, value);
            }
        }
    }

    public static Map<String, Object> unmarshalPrimitiveMap(DataInputStream in) throws IOException {
        return MarshallingSupport.unmarshalPrimitiveMap(in, Integer.MAX_VALUE);
    }

    public static Map<String, Object> unmarshalPrimitiveMap(DataInputStream in, int maxPropertySize) throws IOException {
        int size = in.readInt();
        if (size > maxPropertySize) {
            throw new IOException("Primitive map is larger than the allowed size: " + size);
        }
        if (size < 0) {
            return null;
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            rc.put(name, MarshallingSupport.unmarshalPrimitive(in));
        }
        return rc;
    }

    public static void marshalPrimitiveList(List list, DataByteArrayOutputStream out) throws IOException {
        out.writeInt(list.size());
        for (Object element : list) {
            MarshallingSupport.marshalPrimitive(out, element);
        }
    }

    public static List<Object> unmarshalPrimitiveList(DataInputStream in) throws IOException {
        int size = in.readInt();
        ArrayList<Object> answer = new ArrayList<Object>(size);
        while (size-- > 0) {
            answer.add(MarshallingSupport.unmarshalPrimitive(in));
        }
        return answer;
    }

    public static void marshalPrimitive(DataByteArrayOutputStream out, Object value) throws IOException {
        if (value == null) {
            MarshallingSupport.marshalNull(out);
        } else if (value.getClass() == Boolean.class) {
            MarshallingSupport.marshalBoolean(out, (Boolean)value);
        } else if (value.getClass() == Byte.class) {
            MarshallingSupport.marshalByte(out, (Byte)value);
        } else if (value.getClass() == Character.class) {
            MarshallingSupport.marshalChar(out, ((Character)value).charValue());
        } else if (value.getClass() == Short.class) {
            MarshallingSupport.marshalShort(out, (Short)value);
        } else if (value.getClass() == Integer.class) {
            MarshallingSupport.marshalInt(out, (Integer)value);
        } else if (value.getClass() == Long.class) {
            MarshallingSupport.marshalLong(out, (Long)value);
        } else if (value.getClass() == Float.class) {
            MarshallingSupport.marshalFloat(out, ((Float)value).floatValue());
        } else if (value.getClass() == Double.class) {
            MarshallingSupport.marshalDouble(out, (Double)value);
        } else if (value.getClass() == byte[].class) {
            MarshallingSupport.marshalByteArray(out, (byte[])value);
        } else if (value.getClass() == String.class) {
            MarshallingSupport.marshalString(out, (String)value);
        } else if (value instanceof Map) {
            out.writeByte(11);
            MarshallingSupport.marshalPrimitiveMap((Map)value, out);
        } else if (value instanceof List) {
            out.writeByte(12);
            MarshallingSupport.marshalPrimitiveList((List)value, out);
        } else {
            throw new IOException("Object is not a primitive: " + value);
        }
    }

    public static Object unmarshalPrimitive(DataInputStream in) throws IOException {
        Object value = null;
        byte type = in.readByte();
        switch (type) {
            case 2: {
                value = in.readByte();
                break;
            }
            case 1: {
                value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 3: {
                value = Character.valueOf(in.readChar());
                break;
            }
            case 4: {
                value = in.readShort();
                break;
            }
            case 5: {
                value = in.readInt();
                break;
            }
            case 6: {
                value = in.readLong();
                break;
            }
            case 8: {
                value = new Float(in.readFloat());
                break;
            }
            case 7: {
                value = new Double(in.readDouble());
                break;
            }
            case 10: {
                value = new byte[in.readInt()];
                in.readFully((byte[])value);
                break;
            }
            case 9: {
                value = in.readUTF();
                break;
            }
            case 13: {
                value = in.readUTF();
                break;
            }
            case 11: {
                value = MarshallingSupport.unmarshalPrimitiveMap(in);
                break;
            }
            case 12: {
                value = MarshallingSupport.unmarshalPrimitiveList(in);
                break;
            }
            case 0: {
                value = null;
                break;
            }
            default: {
                throw new IOException("Unknown primitive type: " + type);
            }
        }
        return value;
    }

    public static void marshalNull(DataByteArrayOutputStream out) throws IOException {
        out.writeByte(0);
    }

    public static void marshalBoolean(DataByteArrayOutputStream dataOut, boolean value) throws IOException {
        dataOut.writeByte(1);
        dataOut.writeBoolean(value);
    }

    public static void marshalByte(DataByteArrayOutputStream out, byte value) throws IOException {
        out.writeByte(2);
        out.writeByte(value);
    }

    public static void marshalChar(DataByteArrayOutputStream out, char value) throws IOException {
        out.writeByte(3);
        out.writeChar(value);
    }

    public static void marshalShort(DataByteArrayOutputStream out, short value) throws IOException {
        out.writeByte(4);
        out.writeShort(value);
    }

    public static void marshalInt(DataByteArrayOutputStream out, int value) throws IOException {
        out.writeByte(5);
        out.writeInt(value);
    }

    public static void marshalLong(DataByteArrayOutputStream out, long value) throws IOException {
        out.writeByte(6);
        out.writeLong(value);
    }

    public static void marshalFloat(DataByteArrayOutputStream out, float value) throws IOException {
        out.writeByte(8);
        out.writeFloat(value);
    }

    public static void marshalDouble(DataByteArrayOutputStream out, double value) throws IOException {
        out.writeByte(7);
        out.writeDouble(value);
    }

    public static void marshalByteArray(DataByteArrayOutputStream out, byte[] value) throws IOException {
        MarshallingSupport.marshalByteArray(out, value, 0, value.length);
    }

    public static void marshalByteArray(DataByteArrayOutputStream out, byte[] value, int offset, int length) throws IOException {
        out.writeByte(10);
        out.writeInt(length);
        out.write(value, offset, length);
    }

    public static void marshalString(DataByteArrayOutputStream out, String s) throws IOException {
        if (s.length() < 8191) {
            out.writeByte(9);
            out.writeUTF(s);
        } else {
            out.writeByte(13);
            out.writeUTF(s);
        }
    }
}

