/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stringtemplate;

import java.io.StringWriter;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.stringtemplate.StringTemplateConstants;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.stringtemplate.v4.NoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

@UriEndpoint(firstVersion="1.2.0", scheme="string-template", title="String Template", syntax="string-template:resourceUri", producerOnly=true, category={Category.TRANSFORMATION, Category.SCRIPT}, headersClass=StringTemplateConstants.class)
public class StringTemplateEndpoint
extends ResourceEndpoint {
    @UriParam(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @UriParam(defaultValue="<")
    private char delimiterStart;
    @UriParam(defaultValue=">")
    private char delimiterStop;

    public StringTemplateEndpoint() {
        this.delimiterStart = STGroup.defaultGroup.delimiterStartChar;
        this.delimiterStop = STGroup.defaultGroup.delimiterStopChar;
    }

    public StringTemplateEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
        this.delimiterStart = STGroup.defaultGroup.delimiterStartChar;
        this.delimiterStop = STGroup.defaultGroup.delimiterStopChar;
    }

    @Override
    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public char getDelimiterStart() {
        return this.delimiterStart;
    }

    public void setDelimiterStart(char delimiterStart) {
        this.delimiterStart = delimiterStart;
    }

    public char getDelimiterStop() {
        return this.delimiterStop;
    }

    public void setDelimiterStop(char delimiterStop) {
        this.delimiterStop = delimiterStop;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public StringTemplateEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.getResourceUri(), newResourceUri);
        this.log.debug("Getting endpoint with URI: {}", (Object)newUri);
        return this.getCamelContext().getEndpoint(newUri, StringTemplateEndpoint.class);
    }

    @Override
    protected void onExchange(Exchange exchange) throws Exception {
        String template = null;
        String path = this.getResourceUri();
        ObjectHelper.notNull(path, "resourceUri");
        StringWriter buffer = new StringWriter();
        Map variableMap = null;
        if (this.allowTemplateFromHeader) {
            String newResourceUri = exchange.getIn().getHeader("CamelStringTemplateResourceUri", String.class);
            if (newResourceUri != null) {
                exchange.getIn().removeHeader("CamelStringTemplateResourceUri");
                this.log.debug("{} set to {} creating new endpoint to handle exchange", (Object)"CamelStringTemplateResourceUri", (Object)newResourceUri);
                StringTemplateEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
                newEndpoint.onExchange(exchange);
                return;
            }
            variableMap = exchange.getIn().getHeader("CamelStringTemplateVariableMap", Map.class);
            template = exchange.getIn().getHeader("CamelStringTemplateTemplate", String.class);
        }
        if (variableMap == null) {
            variableMap = ExchangeHelper.createVariableMap(exchange, this.isAllowContextMapAll());
        }
        if (template != null) {
            this.log.debug("StringTemplate content read from header {} for endpoint {}", (Object)"CamelStringTemplateTemplate", (Object)this.getEndpointUri());
            exchange.getIn().removeHeader("CamelStringTemplateTemplate");
        } else {
            this.log.debug("StringTemplate content read from resource {} with resourceUri: {} for endpoint {}", new Object[]{this.getResourceUri(), path, this.getEndpointUri()});
            template = exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, this.getResourceAsInputStream());
        }
        ST stTemplate = new ST(template, this.delimiterStart, this.delimiterStop);
        for (Map.Entry entry : variableMap.entrySet()) {
            stTemplate.add((String)entry.getKey(), entry.getValue());
        }
        this.log.debug("StringTemplate is writing using attributes: {}", (Object)variableMap);
        stTemplate.write(new NoIndentWriter(buffer));
        ExchangeHelper.setInOutBodyPatternAware(exchange, buffer.toString());
        exchange.getMessage().setHeader("CamelStringTemplateResourceUri", this.getResourceUri());
    }
}

