/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.ser.XmlSerializerProvider;
import com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected static final JacksonXmlModule DEFAULT_XML_MODULE = new JacksonXmlModule();
    protected static final DefaultXmlPrettyPrinter DEFAULT_XML_PRETTY_PRINTER = new DefaultXmlPrettyPrinter();
    protected final JacksonXmlModule _xmlModule;

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XMLInputFactory inputF, XMLOutputFactory outF) {
        this(new XmlFactory(inputF, outF));
    }

    public XmlMapper(XMLInputFactory inputF) {
        this(new XmlFactory(inputF));
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(xmlFactory, DEFAULT_XML_MODULE);
    }

    public XmlMapper(JacksonXmlModule module) {
        this(new XmlFactory(), module);
    }

    public XmlMapper(XmlFactory xmlFactory, JacksonXmlModule module) {
        super(xmlFactory, new XmlSerializerProvider(new XmlRootNameLookup()), null);
        this._xmlModule = module;
        if (module != null) {
            this.registerModule(module);
        }
        this._serializationConfig = this._serializationConfig.withDefaultPrettyPrinter(DEFAULT_XML_PRETTY_PRINTER);
    }

    protected XmlMapper(XmlMapper mapper) {
        super(mapper);
        this._xmlModule = mapper._xmlModule;
    }

    @Override
    public XmlMapper copy() {
        this._checkInvalidCopy(XmlMapper.class);
        return new XmlMapper(this);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected void setXMLTextElementName(String name) {
        ((XmlFactory)this._jsonFactory).setXMLTextElementName(name);
    }

    public XmlMapper setDefaultUseWrapper(boolean state) {
        AnnotationIntrospector ai0 = this.getDeserializationConfig().getAnnotationIntrospector();
        for (AnnotationIntrospector ai : ai0.allIntrospectors()) {
            if (!(ai instanceof XmlAnnotationIntrospector)) continue;
            ((XmlAnnotationIntrospector)((Object)ai)).setDefaultUseWrapper(state);
        }
        return this;
    }

    @Override
    public XmlFactory getFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public ObjectMapper configure(ToXmlGenerator.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper configure(FromXmlParser.Feature f, boolean state) {
        ((XmlFactory)this._jsonFactory).configure(f, state);
        return this;
    }

    public ObjectMapper enable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper enable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).enable(f);
        return this;
    }

    public ObjectMapper disable(ToXmlGenerator.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public ObjectMapper disable(FromXmlParser.Feature f) {
        ((XmlFactory)this._jsonFactory).disable(f);
        return this;
    }

    public <T> T readValue(XMLStreamReader r, Class<T> valueType) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(XMLStreamReader r, TypeReference<T> valueTypeRef) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(XMLStreamReader r, JavaType valueType) throws IOException {
        FromXmlParser p = this.getFactory().createParser(r);
        return super.readValue((JsonParser)p, valueType);
    }

    public void writeValue(XMLStreamWriter w0, Object value) throws IOException {
        ToXmlGenerator g = this.getFactory().createGenerator(w0);
        super.writeValue(g, value);
    }

    @Deprecated
    protected PrettyPrinter _defaultPrettyPrinter() {
        return new DefaultXmlPrettyPrinter();
    }
}

