/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.config;

import io.swagger.config.FilterFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXMLReader
implements SwaggerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebXMLReader.class);
    protected String basePath;
    protected String host;
    protected String filterClass;
    protected String apiVersion;
    protected String title;
    protected String[] schemes = new String[0];

    public WebXMLReader(ServletConfig servletConfig) {
        String[] parts;
        this.apiVersion = servletConfig.getInitParameter("api.version");
        if (this.apiVersion == null) {
            this.apiVersion = "Swagger Server";
        }
        this.host = servletConfig.getInitParameter("swagger.api.host");
        String schemesString = servletConfig.getInitParameter("swagger.api.schemes");
        if (schemesString != null) {
            parts = schemesString.split(",");
            ArrayList<String> schemes = new ArrayList<String>();
            for (String scheme : parts) {
                String s = scheme.trim();
                if (s.isEmpty()) continue;
                schemes.add(s);
            }
            this.schemes = schemes.toArray(new String[schemes.size()]);
        }
        this.title = servletConfig.getInitParameter("swagger.api.title");
        if (this.title == null) {
            this.title = "";
        }
        this.basePath = servletConfig.getInitParameter("swagger.api.basepath");
        if (this.basePath != null && (parts = this.basePath.split("://")).length > 1) {
            int pos = parts[1].indexOf("/");
            if (pos >= 0) {
                this.schemes = new String[]{parts[0]};
                this.basePath = parts[1].substring(pos);
                this.host = parts[1].substring(0, pos);
            } else {
                this.schemes = new String[]{parts[0]};
                this.basePath = null;
                this.host = parts[1];
            }
        }
        this.filterClass = servletConfig.getInitParameter("swagger.filter");
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter(filter);
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
    }

    @Override
    public String getFilterClass() {
        return this.filterClass;
    }

    @Override
    public Swagger configure(Swagger swagger) {
        if (swagger != null) {
            Info info = swagger.getInfo();
            if (info == null) {
                swagger.info(new Info());
            }
            swagger.basePath(this.basePath).host(this.host).getInfo().title(this.title).version(this.apiVersion);
            for (String scheme : this.schemes) {
                swagger.scheme(Scheme.forValue(scheme));
            }
        }
        return swagger;
    }
}

