/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.RestApiResponseAdapter;
import org.apache.camel.swagger.RestSwaggerReader;
import org.apache.camel.swagger.SwaggerHelper;
import org.apache.camel.util.CamelVersionHelper;
import org.apache.camel.util.EndpointHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSwaggerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerSupport.class);
    private RestSwaggerReader reader = new RestSwaggerReader();
    private boolean cors;

    public void initSwagger(BeanConfig swaggerConfig, Map<String, Object> config) {
        String s = (String)config.get("swagger.version");
        if (s != null) {
            swaggerConfig.setVersion(s);
        }
        if ((s = (String)config.get("base.path")) != null) {
            swaggerConfig.setBasePath(s);
        }
        if ((s = (String)config.get("host")) != null) {
            swaggerConfig.setHost(s);
        }
        if ((s = (String)config.get("cors")) != null) {
            this.cors = "true".equalsIgnoreCase(s);
        }
        if ((s = (String)config.get("schemes")) == null) {
            s = (String)config.get("schemas");
        }
        if (s != null) {
            String[] schemes = s.split(",");
            swaggerConfig.setSchemes(schemes);
        } else {
            swaggerConfig.setSchemes(new String[]{"http"});
        }
        String version = (String)config.get("api.version");
        String title = (String)config.get("api.title");
        String description = (String)config.get("api.description");
        String termsOfService = (String)config.get("api.termsOfService");
        String licenseName = (String)config.get("api.license.name");
        String licenseUrl = (String)config.get("api.license.url");
        String contactName = (String)config.get("api.contact.name");
        String contactUrl = (String)config.get("api.contact.url");
        String contactEmail = (String)config.get("api.contact.email");
        Info info = new Info();
        info.setVersion(version);
        info.setTitle(title);
        info.setDescription(description);
        info.setTermsOfService(termsOfService);
        if (licenseName != null || licenseUrl != null) {
            License license = new License();
            license.setName(licenseName);
            license.setUrl(licenseUrl);
            info.setLicense(license);
        }
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = new Contact();
            contact.setName(contactName);
            contact.setUrl(contactUrl);
            contact.setEmail(contactEmail);
            info.setContact(contact);
        }
        swaggerConfig.setInfo(info);
    }

    public List<RestDefinition> getRestDefinitions(String camelId) throws Exception {
        String xml;
        ObjectName found = null;
        boolean supportResolvePlaceholder = false;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> names = server.queryNames(new ObjectName("org.apache.camel:type=context,*"), null);
        for (ObjectName on : names) {
            String id = on.getKeyProperty("name");
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            if (camelId != null && !camelId.equals(id)) continue;
            String version = (String)server.getAttribute(on, "CamelVersion");
            if (CamelVersionHelper.isGE((String)"2.15.0", (String)version)) {
                found = on;
            }
            if (!CamelVersionHelper.isGE((String)"2.15.3", (String)version)) continue;
            supportResolvePlaceholder = true;
        }
        if (found != null && (xml = supportResolvePlaceholder ? (String)server.invoke(found, "dumpRestsAsXml", new Object[]{true}, new String[]{"boolean"}) : (String)server.invoke(found, "dumpRestsAsXml", null, null)) != null) {
            LOG.debug("DumpRestAsXml:\n{}", (Object)xml);
            RestsDefinition rests = (RestsDefinition)ModelHelper.createModelFromXml(null, (String)xml, RestsDefinition.class);
            if (rests != null) {
                return rests.getRests();
            }
        }
        return null;
    }

    public List<String> findCamelContexts() throws Exception {
        ArrayList<String> answer = new ArrayList<String>();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> names = server.queryNames(new ObjectName("*:type=context,*"), null);
        for (ObjectName on : names) {
            String id = on.getKeyProperty("name");
            if (id.startsWith("\"") && id.endsWith("\"")) {
                id = id.substring(1, id.length() - 1);
            }
            try {
                String version = (String)server.getAttribute(on, "CamelVersion");
                if (!CamelVersionHelper.isGE((String)"2.15.0", (String)version)) continue;
                answer.add(id);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {}
        }
        return answer;
    }

    public void renderResourceListing(RestApiResponseAdapter response, BeanConfig swaggerConfig, String contextId, String route, boolean json, boolean yaml, ClassResolver classResolver, RestConfiguration configuration) throws Exception {
        List<RestDefinition> rests;
        LOG.trace("renderResourceListing");
        if (this.cors) {
            RestSwaggerSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        if ((rests = this.getRestDefinitions(contextId)) != null) {
            if (json) {
                response.setHeader("Content-Type", "application/json");
                Swagger swagger = this.reader.read(rests, route, swaggerConfig, contextId, classResolver);
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                byte[] bytes = mapper.writeValueAsBytes(swagger);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            } else {
                response.setHeader("Content-Type", "text/yaml");
                Swagger swagger = this.reader.read(rests, route, swaggerConfig, contextId, classResolver);
                if (!configuration.isApiVendorExtension()) {
                    SwaggerHelper.clearVendorExtensions(swagger);
                }
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                byte[] jsonData = mapper.writeValueAsBytes(swagger);
                JsonNode node = mapper.readTree(jsonData);
                byte[] bytes = Yaml.mapper().writerWithDefaultPrettyPrinter().writeValueAsBytes(node);
                int len = bytes.length;
                response.setHeader("Content-Length", "" + len);
                response.writeBytes(bytes);
            }
        } else {
            response.noContent();
        }
    }

    public void renderCamelContexts(RestApiResponseAdapter response, String contextId, String contextIdPattern, boolean json, boolean yaml, RestConfiguration configuration) throws Exception {
        int i;
        LOG.trace("renderCamelContexts");
        if (this.cors) {
            RestSwaggerSupport.setupCorsHeaders(response, configuration.getCorsHeaders());
        }
        List<String> contexts = this.findCamelContexts();
        if (contextIdPattern != null) {
            Iterator<String> it = contexts.iterator();
            while (it.hasNext()) {
                String name = it.next();
                boolean match = "#name#".equals(contextIdPattern) ? name.equals(contextId) : EndpointHelper.matchPattern((String)name, (String)contextIdPattern);
                if (match) continue;
                it.remove();
            }
        }
        StringBuffer sb = new StringBuffer();
        if (json) {
            response.setHeader("Content-Type", "application/json");
            sb.append("[\n");
            for (i = 0; i < contexts.size(); ++i) {
                String name = contexts.get(i);
                sb.append("{\"name\": \"").append(name).append("\"}");
                if (i >= contexts.size() - 1) continue;
                sb.append(",\n");
            }
            sb.append("\n]");
        } else {
            response.setHeader("Content-Type", "text/yaml");
            for (i = 0; i < contexts.size(); ++i) {
                String name = contexts.get(i);
                sb.append("- \"").append(name).append("\"\n");
            }
        }
        int len = sb.length();
        response.setHeader("Content-Length", "" + len);
        response.writeBytes(sb.toString().getBytes());
    }

    private static void setupCorsHeaders(RestApiResponseAdapter response, Map<String, String> corsHeaders) {
        String maxAge;
        String allowHeaders;
        String allowMethods;
        String allowOrigin;
        String string = allowOrigin = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Origin") : null;
        if (allowOrigin == null) {
            allowOrigin = "*";
        }
        String string2 = allowMethods = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Methods") : null;
        if (allowMethods == null) {
            allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
        }
        String string3 = allowHeaders = corsHeaders != null ? corsHeaders.get("Access-Control-Allow-Headers") : null;
        if (allowHeaders == null) {
            allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
        }
        String string4 = maxAge = corsHeaders != null ? corsHeaders.get("Access-Control-Max-Age") : null;
        if (maxAge == null) {
            maxAge = "3600";
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using CORS headers[");
            LOG.trace("  Access-Control-Allow-Origin={}", (Object)allowOrigin);
            LOG.trace("  Access-Control-Allow-Methods={}", (Object)allowMethods);
            LOG.trace("  Access-Control-Allow-Headers={}", (Object)allowHeaders);
            LOG.trace("  Access-Control-Max-Age={}", (Object)maxAge);
            LOG.trace("]");
        }
        response.setHeader("Access-Control-Allow-Origin", allowOrigin);
        response.setHeader("Access-Control-Allow-Methods", allowMethods);
        response.setHeader("Access-Control-Allow-Headers", allowHeaders);
        response.setHeader("Access-Control-Max-Age", maxAge);
    }
}

