/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.nio.charset.Charset;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ShareableChannelHandlerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.codec.frame.DelimiterBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.serialization.ClassResolvers;
import org.jboss.netty.handler.codec.serialization.ObjectDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;

public final class ChannelHandlerFactories {
    private ChannelHandlerFactories() {
    }

    public static ChannelHandlerFactory newStringEncoder(Charset charset) {
        return new ShareableChannelHandlerFactory(new StringEncoder(charset));
    }

    public static ChannelHandlerFactory newStringDecoder(Charset charset) {
        return new ShareableChannelHandlerFactory(new StringDecoder(charset));
    }

    public static ChannelHandlerFactory newObjectDecoder() {
        return new ChannelHandlerFactory(){

            @Override
            public ChannelHandler newChannelHandler() {
                return new ObjectDecoder(ClassResolvers.weakCachingResolver(null));
            }
        };
    }

    public static ChannelHandlerFactory newObjectEncoder() {
        return new ShareableChannelHandlerFactory(new ObjectEncoder());
    }

    public static ChannelHandlerFactory newDelimiterBasedFrameDecoder(final int maxFrameLength, final ChannelBuffer[] delimiters) {
        return new ChannelHandlerFactory(){

            @Override
            public ChannelHandler newChannelHandler() {
                return new DelimiterBasedFrameDecoder(maxFrameLength, true, delimiters);
            }
        };
    }

    public static ChannelHandlerFactory newLengthFieldBasedFrameDecoder(final int maxFrameLength, final int lengthFieldOffset, final int lengthFieldLength, final int lengthAdjustment, final int initialBytesToStrip) {
        return new ChannelHandlerFactory(){

            @Override
            public ChannelHandler newChannelHandler() {
                return new LengthFieldBasedFrameDecoder(maxFrameLength, lengthFieldOffset, lengthFieldLength, lengthAdjustment, initialBytesToStrip);
            }
        };
    }
}

