/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientPipelineFactory;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.handlers.ClientChannelHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientPipelineFactory
extends ClientPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientPipelineFactory.class);
    private final NettyProducer producer;
    private SSLContext sslContext;

    public DefaultClientPipelineFactory(NettyProducer producer) {
        this.producer = producer;
        try {
            this.sslContext = this.createSSLContext(producer);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            sslHandler.setCloseOnSSLException(true);
            LOG.debug("Client SSL handler configured and added to the ChannelPipeline: {}", (Object)sslHandler);
            this.addToPipeline("ssl", channelPipeline, sslHandler);
        }
        List<ChannelHandler> decoders = this.producer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            this.addToPipeline("decoder-" + x, channelPipeline, decoder);
        }
        List<ChannelHandler> encoders = this.producer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            this.addToPipeline("encoder-" + x, channelPipeline, encoder);
        }
        if (this.producer.getConfiguration().getRequestTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using request timeout {} millis", (Object)this.producer.getConfiguration().getRequestTimeout());
            }
            ReadTimeoutHandler timeout = new ReadTimeoutHandler(NettyComponent.getTimer(), this.producer.getConfiguration().getRequestTimeout(), TimeUnit.MILLISECONDS);
            this.addToPipeline("timeout", channelPipeline, timeout);
        }
        this.addToPipeline("handler", channelPipeline, new ClientChannelHandler(this.producer));
        LOG.trace("Created ChannelPipeline: {}", (Object)channelPipeline);
        return channelPipeline;
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, ChannelHandler handler) {
        pipeline.addLast(name, handler);
    }

    private SSLContext createSSLContext(NettyProducer producer) throws Exception {
        SSLContext answer;
        NettyConfiguration configuration = producer.getConfiguration();
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext();
        } else {
            if (configuration.getKeyStoreFile() == null && configuration.getKeyStoreResource() == null) {
                LOG.debug("keystorefile is null");
            }
            if (configuration.getTrustStoreFile() == null && configuration.getTrustStoreResource() == null) {
                LOG.debug("truststorefile is null");
            }
            if (configuration.getPassphrase().toCharArray() == null) {
                LOG.debug("passphrase is null");
            }
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), configuration.getPassphrase().toCharArray());
            } else {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext().getClassResolver(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), configuration.getPassphrase().toCharArray());
            }
        }
        return answer;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            if (this.producer.getConfiguration().getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.producer.getConfiguration().getEnabledProtocols().split(","));
            }
            engine.setUseClientMode(true);
            return new SslHandler(engine);
        }
        return null;
    }

    @Override
    public ClientPipelineFactory createPipelineFactory(NettyProducer producer) {
        return new DefaultClientPipelineFactory(producer);
    }
}

