/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog.netty;

import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class Rfc5425FrameDecoder
extends FrameDecoder
implements ChannelHandlerFactory {
    private Integer currentFramelength;

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.currentFramelength == null) {
            int length;
            int index = Rfc5425FrameDecoder.indexOf(buffer, ChannelBuffers.wrappedBuffer(new byte[]{32}));
            StringBuffer lengthbuffer = new StringBuffer();
            if (index > -1) {
                lengthbuffer.append(new String(buffer.readBytes(index).array()));
            }
            try {
                length = Integer.parseInt(lengthbuffer.toString()) + 1;
            }
            catch (NumberFormatException e) {
                length = -1;
            }
            if (length < 0) {
                buffer.resetReaderIndex();
                return null;
            }
            this.currentFramelength = length;
        }
        if (buffer.readableBytes() < this.currentFramelength) {
            return null;
        }
        int lengthToRead = this.currentFramelength;
        this.currentFramelength = null;
        return buffer.readBytes(lengthToRead);
    }

    private static int indexOf(ChannelBuffer haystack, ChannelBuffer needle) {
        for (int i = haystack.readerIndex(); i < haystack.writerIndex(); ++i) {
            int needleIndex;
            int haystackIndex = i;
            for (needleIndex = 0; needleIndex < needle.capacity() && haystack.getByte(haystackIndex) == needle.getByte(needleIndex); ++needleIndex) {
                if (++haystackIndex != haystack.writerIndex() || needleIndex == needle.capacity() - 1) continue;
                return -1;
            }
            if (needleIndex != needle.capacity()) continue;
            return i - haystack.readerIndex();
        }
        return -1;
    }

    @Override
    public ChannelHandler newChannelHandler() {
        return new Rfc5425FrameDecoder();
    }
}

