/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.apache.camel.util.concurrent.CamelThreadFactory;

public final class NettyWorkerPoolBuilder {
    private String name = "NettyWorker";
    private String pattern;
    private int workerCount;
    private boolean nativeTransport;
    private volatile EventLoopGroup workerPool;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public void setNativeTransport(boolean nativeTransport) {
        this.nativeTransport = nativeTransport;
    }

    public NettyWorkerPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyWorkerPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyWorkerPoolBuilder withWorkerCount(int workerCount) {
        this.setWorkerCount(workerCount);
        return this;
    }

    public NettyWorkerPoolBuilder withNativeTransport(boolean nativeTransport) {
        this.setNativeTransport(nativeTransport);
        return this;
    }

    public EventLoopGroup build() {
        this.workerPool = this.nativeTransport ? new EpollEventLoopGroup(this.workerCount, new CamelThreadFactory(this.pattern, this.name, false)) : new NioEventLoopGroup(this.workerCount, new CamelThreadFactory(this.pattern, this.name, false));
        return this.workerPool;
    }

    public void destroy() {
        if (this.workerPool != null) {
            this.workerPool.shutdownGracefully();
            this.workerPool = null;
        }
    }
}

