/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.camel.component.netty.codec.DelimiterBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramPacketDelimiterDecoder
extends MessageToMessageDecoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramPacketDelimiterDecoder.class);
    private final DelimiterBasedFrameDecoder delegateDecoder;

    public DatagramPacketDelimiterDecoder(int maxFrameLength, ByteBuf[] delimiters) {
        this(maxFrameLength, true, delimiters);
    }

    public DatagramPacketDelimiterDecoder(int maxFrameLength, boolean stripDelimiter, ByteBuf[] delimiters) {
        this.delegateDecoder = new DelimiterBasedFrameDecoder(maxFrameLength, stripDelimiter, delimiters);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof ByteBuf) {
            ByteBuf payload = (ByteBuf)msg.content();
            Object result = this.delegateDecoder.decode(ctx, payload);
            DefaultAddressedEnvelope<Object, InetSocketAddress> addressEvelop = new DefaultAddressedEnvelope<Object, InetSocketAddress>(result, msg.recipient(), msg.sender());
            out.add(addressEvelop);
        } else {
            LOG.debug("Ignoring message content as it is not an io.netty.buffer.ByteBuf instance.");
        }
    }
}

