/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.component.syslog.SyslogConverter;
import org.apache.camel.component.syslog.SyslogMessage;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="syslog")
public class SyslogDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    @Override
    public String getDataFormatName() {
        return "syslog";
    }

    @Override
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        SyslogMessage message = ExchangeHelper.convertToMandatoryType(exchange, SyslogMessage.class, body);
        stream.write(SyslogConverter.toString(message).getBytes());
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        Date time;
        String body = ExchangeHelper.convertToMandatoryType(exchange, String.class, inputStream);
        SyslogMessage message = SyslogConverter.parseMessage(body.getBytes());
        exchange.getOut().setHeader("CamelSyslogFacility", (Object)message.getFacility());
        exchange.getOut().setHeader("CamelSyslogSeverity", (Object)message.getSeverity());
        exchange.getOut().setHeader("CamelSyslogHostname", message.getHostname());
        Date date = time = message.getTimestamp() != null ? message.getTimestamp().getTime() : null;
        if (time != null) {
            exchange.getOut().setHeader("CamelSyslogTimestamp", time);
        }
        if (exchange.getIn().getHeader("CamelMinaLocalAddress") != null) {
            message.setLocalAddress(exchange.getIn().getHeader("CamelMinaLocalAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogLocalAddress", message.getLocalAddress());
        }
        if (exchange.getIn().getHeader("CamelMinaRemoteAddress") != null) {
            message.setRemoteAddress(exchange.getIn().getHeader("CamelMinaRemoteAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogRemoteAddress", message.getRemoteAddress());
        }
        if (exchange.getIn().getHeader("CamelNettyLocalAddress") != null) {
            message.setLocalAddress(exchange.getIn().getHeader("CamelNettyLocalAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogLocalAddress", message.getLocalAddress());
        }
        if (exchange.getIn().getHeader("CamelNettyRemoteAddress") != null) {
            message.setRemoteAddress(exchange.getIn().getHeader("CamelNettyRemoteAddress", String.class));
            exchange.getOut().setHeader("CamelSyslogRemoteAddress", message.getRemoteAddress());
        }
        return message;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

