/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.syslog.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.camel.component.netty.ChannelHandlerFactory;

public class Rfc5425FrameDecoder
extends ByteToMessageDecoder
implements ChannelHandlerFactory {
    private Integer currentFramelength;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.currentFramelength == null) {
            int length;
            int index = Rfc5425FrameDecoder.indexOf(in, Unpooled.wrappedBuffer(new byte[]{32}));
            StringBuffer lengthbuffer = new StringBuffer();
            if (index > -1) {
                ByteBuf byteBuf = in.readBytes(index);
                byte[] dest = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(dest);
                lengthbuffer.append(new String(dest));
            }
            try {
                length = Integer.parseInt(lengthbuffer.toString()) + 1;
            }
            catch (NumberFormatException e) {
                length = -1;
            }
            if (length < 0) {
                in.resetReaderIndex();
                return;
            }
            this.currentFramelength = length;
        }
        if (in.readableBytes() < this.currentFramelength) {
            return;
        }
        int lengthToRead = this.currentFramelength;
        this.currentFramelength = null;
        out.add(in.readBytes(lengthToRead));
    }

    private static int indexOf(ByteBuf haystack, ByteBuf needle) {
        for (int i = haystack.readerIndex(); i < haystack.writerIndex(); ++i) {
            int needleIndex;
            int haystackIndex = i;
            for (needleIndex = 0; needleIndex < needle.capacity() && haystack.getByte(haystackIndex) == needle.getByte(needleIndex); ++needleIndex) {
                if (++haystackIndex != haystack.writerIndex() || needleIndex == needle.capacity() - 1) continue;
                return -1;
            }
            if (needleIndex != needle.capacity()) continue;
            return i - haystack.readerIndex();
        }
        return -1;
    }

    @Override
    public ChannelHandler newChannelHandler() {
        return new Rfc5425FrameDecoder();
    }
}

