/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.service;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.camel.component.telegram.TelegramService;
import org.apache.camel.component.telegram.model.OutgoingAudioMessage;
import org.apache.camel.component.telegram.model.OutgoingDocumentMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.OutgoingPhotoMessage;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.OutgoingVideoMessage;
import org.apache.camel.component.telegram.model.UpdateResult;
import org.apache.camel.component.telegram.service.RestBotAPI;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;

public class TelegramServiceRestBotAPIAdapter
implements TelegramService {
    private RestBotAPI api = JAXRSClientFactory.create("https://api.telegram.org", RestBotAPI.class, Collections.singletonList(new JacksonJsonProvider()));

    public TelegramServiceRestBotAPIAdapter() {
        WebClient.getConfig(this.api).getHttpConduit().getClient().setAllowChunking(false);
    }

    @Override
    public UpdateResult getUpdates(String authorizationToken, Long offset, Integer limit, Integer timeoutSeconds) {
        return this.api.getUpdates(authorizationToken, offset, limit, timeoutSeconds);
    }

    @Override
    public void sendMessage(String authorizationToken, OutgoingMessage message) {
        if (message instanceof OutgoingTextMessage) {
            this.sendMessage(authorizationToken, (OutgoingTextMessage)message);
        } else if (message instanceof OutgoingPhotoMessage) {
            this.sendMessage(authorizationToken, (OutgoingPhotoMessage)message);
        } else if (message instanceof OutgoingAudioMessage) {
            this.sendMessage(authorizationToken, (OutgoingAudioMessage)message);
        } else if (message instanceof OutgoingVideoMessage) {
            this.sendMessage(authorizationToken, (OutgoingVideoMessage)message);
        } else if (message instanceof OutgoingDocumentMessage) {
            this.sendMessage(authorizationToken, (OutgoingDocumentMessage)message);
        } else {
            throw new IllegalArgumentException("Unsupported message type " + (message != null ? message.getClass().getName() : null));
        }
    }

    private void sendMessage(String authorizationToken, OutgoingTextMessage message) {
        this.api.sendMessage(authorizationToken, message.getChatId(), message.getText(), message.getParseMode(), message.getDisableWebPagePreview(), message.getDisableNotification(), message.getReplyToMessageId());
    }

    private void sendMessage(String authorizationToken, OutgoingPhotoMessage message) {
        LinkedList<Attachment> parts = new LinkedList<Attachment>();
        this.fillCommonMediaParts(parts, message);
        parts.add(this.buildMediaPart("photo", message.getFilenameWithExtension(), message.getPhoto()));
        if (message.getCaption() != null) {
            parts.add(this.buildTextPart("caption", message.getCaption()));
        }
        this.api.sendPhoto(authorizationToken, parts);
    }

    private void sendMessage(String authorizationToken, OutgoingAudioMessage message) {
        LinkedList<Attachment> parts = new LinkedList<Attachment>();
        this.fillCommonMediaParts(parts, message);
        parts.add(this.buildMediaPart("audio", message.getFilenameWithExtension(), message.getAudio()));
        if (message.getTitle() != null) {
            parts.add(this.buildTextPart("title", message.getTitle()));
        }
        if (message.getDurationSeconds() != null) {
            parts.add(this.buildTextPart("duration", String.valueOf(message.getDurationSeconds())));
        }
        if (message.getPerformer() != null) {
            parts.add(this.buildTextPart("performer", message.getPerformer()));
        }
        this.api.sendAudio(authorizationToken, parts);
    }

    private void sendMessage(String authorizationToken, OutgoingVideoMessage message) {
        LinkedList<Attachment> parts = new LinkedList<Attachment>();
        this.fillCommonMediaParts(parts, message);
        parts.add(this.buildMediaPart("video", message.getFilenameWithExtension(), message.getVideo()));
        if (message.getCaption() != null) {
            parts.add(this.buildTextPart("caption", message.getCaption()));
        }
        if (message.getDurationSeconds() != null) {
            parts.add(this.buildTextPart("duration", String.valueOf(message.getDurationSeconds())));
        }
        if (message.getWidth() != null) {
            parts.add(this.buildTextPart("width", String.valueOf(message.getWidth())));
        }
        if (message.getHeight() != null) {
            parts.add(this.buildTextPart("height", String.valueOf(message.getHeight())));
        }
        this.api.sendVideo(authorizationToken, parts);
    }

    private void sendMessage(String authorizationToken, OutgoingDocumentMessage message) {
        LinkedList<Attachment> parts = new LinkedList<Attachment>();
        this.fillCommonMediaParts(parts, message);
        parts.add(this.buildMediaPart("document", message.getFilenameWithExtension(), message.getDocument()));
        if (message.getCaption() != null) {
            parts.add(this.buildTextPart("caption", message.getCaption()));
        }
        this.api.sendDocument(authorizationToken, parts);
    }

    private void fillCommonMediaParts(List<Attachment> parts, OutgoingMessage message) {
        parts.add(this.buildTextPart("chat_id", message.getChatId()));
        if (message.getReplyToMessageId() != null) {
            parts.add(this.buildTextPart("reply_to_message_id", String.valueOf(message.getReplyToMessageId())));
        }
        if (message.getDisableNotification() != null) {
            parts.add(this.buildTextPart("disable_notification", String.valueOf(message.getDisableNotification())));
        }
    }

    private Attachment buildTextPart(String name, String value) {
        MultivaluedHashMap<String, String> m = new MultivaluedHashMap<String, String>();
        m.putSingle("Content-Type", "text/plain");
        m.putSingle("Content-Disposition", "form-data; name=\"" + this.escapeMimeName(name) + "\"");
        Attachment a = new Attachment(m, value);
        return a;
    }

    private Attachment buildMediaPart(String name, String fileNameWithExtension, byte[] value) {
        Attachment a = new Attachment(name, new ByteArrayInputStream(value), new ContentDisposition("form-data; name=\"" + this.escapeMimeName(name) + "\"; filename=\"" + this.escapeMimeName(fileNameWithExtension) + "\""));
        return a;
    }

    private String escapeMimeName(String name) {
        return name.replace("\"", "");
    }
}

