/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.util;

import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.telegram.TelegramMediaType;
import org.apache.camel.component.telegram.TelegramParseMode;
import org.apache.camel.component.telegram.model.IncomingMessage;
import org.apache.camel.component.telegram.model.OutgoingAudioMessage;
import org.apache.camel.component.telegram.model.OutgoingDocumentMessage;
import org.apache.camel.component.telegram.model.OutgoingMessage;
import org.apache.camel.component.telegram.model.OutgoingPhotoMessage;
import org.apache.camel.component.telegram.model.OutgoingTextMessage;
import org.apache.camel.component.telegram.model.OutgoingVideoMessage;
import org.apache.camel.component.telegram.model.Update;

@Converter
public final class TelegramConverter {
    private TelegramConverter() {
    }

    @Converter
    public static String toString(Update update) {
        return update != null ? TelegramConverter.toString(update.getMessage()) : null;
    }

    @Converter
    public static String toString(IncomingMessage message) {
        return message != null ? message.getText() : null;
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(Object message, Exchange exchange) {
        String content = (String)exchange.getIn().getBody(String.class);
        return TelegramConverter.toOutgoingMessage(content, exchange);
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(String message, Exchange exchange) {
        OutgoingTextMessage result;
        if (message == null) {
            return null;
        }
        Object typeObj = exchange.getIn().getHeader("CamelTelegramMediaType");
        TelegramMediaType type = typeObj instanceof String ? TelegramMediaType.valueOf((String)typeObj) : (TelegramMediaType)((Object)typeObj);
        if (type == null) {
            type = TelegramMediaType.TEXT;
        }
        switch (type) {
            case TEXT: {
                OutgoingTextMessage txt = new OutgoingTextMessage();
                txt.setText(message);
                TelegramParseMode parseMode = TelegramConverter.getParseMode(exchange);
                if (parseMode != null) {
                    txt.setParseMode(parseMode.getCode());
                }
                result = txt;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported conversion from String to media type " + (Object)((Object)type));
            }
        }
        return result;
    }

    @Converter
    public static OutgoingMessage toOutgoingMessage(byte[] message, Exchange exchange) {
        OutgoingMessage result;
        if (message == null) {
            return null;
        }
        Object typeObj = exchange.getIn().getHeader("CamelTelegramMediaType");
        TelegramMediaType type = typeObj instanceof String ? TelegramMediaType.valueOf((String)typeObj) : (TelegramMediaType)((Object)typeObj);
        if (type == null) {
            throw new IllegalStateException("Binary message require the header CamelTelegramMediaType to be set with an appropriate org.apache.camel.component.telegram.TelegramMediaType object");
        }
        switch (type) {
            case PHOTO_JPG: 
            case PHOTO_PNG: {
                OutgoingPhotoMessage img = new OutgoingPhotoMessage();
                String caption = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                String fileName = "photo." + type.getFileExtension();
                img.setCaption(caption);
                img.setFilenameWithExtension(fileName);
                img.setPhoto(message);
                result = img;
                break;
            }
            case AUDIO: {
                OutgoingAudioMessage audio = new OutgoingAudioMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                String fileName = "audio." + type.getFileExtension();
                audio.setTitle(title);
                audio.setFilenameWithExtension(fileName);
                audio.setAudio(message);
                result = audio;
                break;
            }
            case VIDEO: {
                OutgoingVideoMessage video = new OutgoingVideoMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                String fileName = "video." + type.getFileExtension();
                video.setCaption(title);
                video.setFilenameWithExtension(fileName);
                video.setVideo(message);
                result = video;
                break;
            }
            default: {
                OutgoingDocumentMessage document = new OutgoingDocumentMessage();
                String title = (String)exchange.getIn().getHeader("CamelTelegramMediaTitleCaption");
                document.setCaption(title);
                document.setFilenameWithExtension("file");
                document.setDocument(message);
                result = document;
                break;
            }
        }
        return result;
    }

    private static TelegramParseMode getParseMode(Exchange exchange) {
        TelegramParseMode mode = null;
        Object parseMode = exchange.getIn().getHeader("CamelTelegramParseMode");
        mode = parseMode instanceof String ? TelegramParseMode.valueOf((String)parseMode) : (TelegramParseMode)((Object)parseMode);
        return mode;
    }
}

