/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.AbstractEndpointFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.DataBindingProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;

public class AbstractJAXRSFactoryBean
extends AbstractEndpointFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXRSFactoryBean.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractJAXRSFactoryBean.class);
    protected List<String> schemaLocations;
    protected JAXRSServiceFactoryBean serviceFactory;
    protected List<Object> entityProviders = new LinkedList<Object>();
    private Comparator<?> providerComparator;

    protected AbstractJAXRSFactoryBean(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
        this.setBindingId("http://apache.org/cxf/binding/jaxrs");
    }

    @Override
    public Bus getBus() {
        Bus b = super.getBus();
        this.checkBindingFactory(b);
        return b;
    }

    @Override
    public void setServiceName(QName name) {
        super.setServiceName(name);
        this.serviceFactory.setServiceName(name);
    }

    private void checkBindingFactory(Bus bus) {
        BindingFactoryManager bfm = bus.getExtension(BindingFactoryManager.class);
        try {
            bfm.getBindingFactory("http://apache.org/cxf/binding/jaxrs");
        }
        catch (Throwable b) {
            bfm.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", new JAXRSBindingFactory(bus));
        }
    }

    @Override
    public void setBus(Bus bus) {
        super.setBus(bus);
        this.checkBindingFactory(bus);
        this.serviceFactory.setBus(bus);
    }

    protected EndpointInfo createEndpointInfo(Service service) throws BusException {
        String transportId = this.getTransportId();
        if (transportId == null && this.getAddress() != null) {
            DestinationFactory df = this.getDestinationFactory();
            if (df == null) {
                DestinationFactoryManager dfm = this.getBus().getExtension(DestinationFactoryManager.class);
                df = dfm.getDestinationFactoryForUri(this.getAddress());
                super.setDestinationFactory(df);
            }
            if (df != null) {
                transportId = df.getTransportIds().get(0);
            }
        }
        if (transportId == null) {
            transportId = "http://cxf.apache.org/transports/http";
        }
        this.setTransportId(transportId);
        EndpointInfo ei = new EndpointInfo();
        ei.setTransportId(transportId);
        ei.setName(this.serviceFactory.getService().getName());
        ei.setAddress(this.getAddress());
        BindingInfo bindingInfo = this.createBindingInfo();
        ei.setBinding(bindingInfo);
        if (!StringUtils.isEmpty(this.publishedEndpointUrl)) {
            ei.setProperty("publishedEndpointUrl", this.publishedEndpointUrl);
        }
        ei.setName(service.getName());
        this.serviceFactory.sendEvent(FactoryBeanListener.Event.ENDPOINTINFO_CREATED, ei);
        return ei;
    }

    @Override
    protected BindingInfo createBindingInfo() {
        BindingFactoryManager mgr = this.getBus().getExtension(BindingFactoryManager.class);
        String binding = this.getBindingId();
        BindingConfiguration bindingConfig = this.getBindingConfig();
        if (binding == null && bindingConfig != null) {
            binding = bindingConfig.getBindingId();
        }
        if (binding == null) {
            binding = "http://apache.org/cxf/binding/jaxrs";
        }
        try {
            BindingFactory bindingFactory = mgr.getBindingFactory(binding);
            this.setBindingFactory(bindingFactory);
            BindingInfo bi = bindingFactory.createBindingInfo(this.serviceFactory.getService(), binding, bindingConfig);
            for (BindingOperationInfo boi : bi.getOperations()) {
                this.serviceFactory.sendEvent(FactoryBeanListener.Event.BINDING_OPERATION_CREATED, bi, boi, null);
            }
            this.serviceFactory.sendEvent(FactoryBeanListener.Event.BINDING_CREATED, bi);
            return bi;
        }
        catch (BusException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public JAXRSServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(JAXRSServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Override
    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Service service = this.serviceFactory.getService();
        if (service == null) {
            service = this.serviceFactory.create();
        }
        EndpointInfo ei = this.createEndpointInfo(service);
        EndpointImpl ep = new EndpointImpl(this.getBus(), service, ei);
        if (this.properties != null) {
            ep.putAll(this.properties);
        }
        if (this.getInInterceptors() != null) {
            ep.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            ep.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            ep.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            ep.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        List<ClassResourceInfo> list = this.serviceFactory.getRealClassResourceInfo();
        for (ClassResourceInfo cri : list) {
            this.initializeAnnotationInterceptors((Endpoint)ep, cri.getServiceClass());
            this.serviceFactory.sendEvent(FactoryBeanListener.Event.ENDPOINT_SELECTED, ei, ep, cri.getServiceClass(), null);
        }
        ep.put(JAXRSServiceFactoryBean.class.getName(), this.serviceFactory);
        return ep;
    }

    public void setSchemaLocation(String schema) {
        this.setSchemaLocations(Collections.singletonList(schema));
    }

    public void setSchemaLocations(List<String> schemas) {
        this.schemaLocations = schemas;
    }

    public List<?> getProviders() {
        return this.entityProviders;
    }

    public void setProviders(List<? extends Object> providers) {
        ArrayList<Object> newBeans = new ArrayList<Object>();
        AbstractJAXRSFactoryBean.addToBeans(newBeans, providers);
        this.entityProviders.addAll(newBeans);
    }

    public void setProvider(Object provider) {
        this.entityProviders.add(provider);
    }

    protected void checkResources(boolean server) {
        List<ClassResourceInfo> list = this.serviceFactory.getRealClassResourceInfo();
        if (server) {
            Iterator<ClassResourceInfo> it = list.iterator();
            while (it.hasNext()) {
                ClassResourceInfo cri = it.next();
                if (this.isValidClassResourceInfo(cri)) continue;
                it.remove();
            }
        }
        if (list.size() == 0) {
            Message msg = new Message("NO_RESOURCES_AVAILABLE", BUNDLE, new Object[0]);
            LOG.severe(msg.toString());
            throw new ServiceConstructionException(msg);
        }
    }

    protected boolean isValidClassResourceInfo(ClassResourceInfo cri) {
        Class<?> serviceCls = cri.getServiceClass();
        return !cri.isCreatedFromModel() || serviceCls != cri.getResourceClass() || InjectionUtils.isConcreteClass(serviceCls);
    }

    protected void setupFactory(ProviderFactory factory, Endpoint ep) {
        if (this.providerComparator != null) {
            factory.setProviderComparator(this.providerComparator);
        }
        if (this.entityProviders != null) {
            factory.setUserProviders(this.entityProviders);
        }
        this.setDataBindingProvider(factory, ep.getService());
        factory.setBus(this.getBus());
        factory.initProviders(this.serviceFactory.getRealClassResourceInfo());
        if (this.schemaLocations != null) {
            factory.setSchemaLocations(this.schemaLocations);
        }
        ep.put(factory.getClass().getName(), factory);
    }

    protected void setDataBindingProvider(ProviderFactory factory, Service s) {
        DataBinding db;
        org.apache.cxf.annotations.DataBinding ann;
        List<ClassResourceInfo> cris = this.serviceFactory.getRealClassResourceInfo();
        if (this.getDataBinding() == null && !cris.isEmpty() && (ann = cris.get(0).getServiceClass().getAnnotation(org.apache.cxf.annotations.DataBinding.class)) != null) {
            try {
                this.setDataBinding(ann.value().newInstance());
            }
            catch (Exception ex) {
                LOG.warning("DataBinding " + ann.value() + " can not be loaded");
            }
        }
        if ((db = this.getDataBinding()) == null) {
            return;
        }
        if (s instanceof JAXRSServiceImpl) {
            ((JAXRSServiceImpl)s).setCreateServiceModel(true);
        }
        db.initialize(s);
        factory.setUserProviders(Collections.singletonList(new DataBindingProvider(db)));
    }

    public void setModelBeans(UserResource ... resources) {
        this.setModelBeans(Arrays.asList(resources));
    }

    public void setModelBeans(List<UserResource> resources) {
        this.serviceFactory.setUserResources(resources);
    }

    public void setModelBeansWithServiceClass(List<UserResource> resources, Class<?> ... sClasses) {
        this.serviceFactory.setUserResourcesWithServiceClass(resources, sClasses);
    }

    public void setModelRef(String modelRef) {
        List<UserResource> resources = ResourceUtils.getUserResources(modelRef, this.getBus());
        if (resources != null) {
            this.serviceFactory.setUserResources(resources);
        }
    }

    public void setModelRefWithServiceClass(String modelRef, Class<?> ... sClasses) {
        List<UserResource> resources = ResourceUtils.getUserResources(modelRef, this.getBus());
        if (resources != null) {
            this.serviceFactory.setUserResourcesWithServiceClass(resources, sClasses);
        }
    }

    public void setProviderComparator(Comparator<?> providerComparator) {
        this.providerComparator = providerComparator;
    }
}

