/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InFaultChainInitiatorObserver;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.ClientMessageObserver;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.FrontendClientAdapter;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.spec.ClientRequestFilterInterceptor;
import org.apache.cxf.jaxrs.client.spec.ClientResponseFilterInterceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.MessageObserver;

public abstract class AbstractClient
implements Client {
    public static final String EXECUTOR_SERVICE_PROPERTY = "executorService";
    protected static final String REQUEST_CONTEXT = "RequestContext";
    protected static final String RESPONSE_CONTEXT = "ResponseContext";
    protected static final String KEEP_CONDUIT_ALIVE = "KeepConduitAlive";
    protected static final String HTTP_SCHEME = "http";
    private static final String PROXY_PROPERTY = "jaxrs.proxy";
    private static final String HEADER_SPLIT_PROPERTY = "org.apache.cxf.http.header.split";
    private static final String SERVICE_NOT_AVAIL_PROPERTY = "org.apache.cxf.transport.service_not_available";
    private static final String COMPLETE_IF_SERVICE_NOT_AVAIL_PROPERTY = "org.apache.cxf.transport.complete_if_service_not_available";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractClient.class);
    private static final Set<String> KNOWN_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE"));
    protected ClientConfiguration cfg = new ClientConfiguration();
    private ClientState state;
    private AtomicBoolean closed = new AtomicBoolean();

    protected AbstractClient(ClientState initialState) {
        this.state = initialState;
    }

    @Override
    public Client query(String name, Object ... values) {
        this.addMatrixQueryParamsToBuilder(this.getCurrentBuilder(), name, ParameterType.QUERY, null, values);
        return this;
    }

    @Override
    public Client header(String name, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if ("Content-Type".equals(name)) {
            if (values.length > 1) {
                throw new IllegalArgumentException("Content-Type can have a single value only");
            }
            this.type(this.convertParamValue(values[0], null));
        } else {
            for (Object o : values) {
                this.possiblyAddHeader(name, this.convertParamValue(o, null));
            }
        }
        return this;
    }

    @Override
    public Client headers(MultivaluedMap<String, String> map) {
        this.state.getRequestHeaders().putAll(map);
        return this;
    }

    @Override
    public Client accept(MediaType ... types) {
        for (MediaType mt : types) {
            this.possiblyAddHeader("Accept", JAXRSUtils.mediaTypeToString(mt, new String[0]));
        }
        return this;
    }

    @Override
    public Client type(MediaType ct) {
        return this.type(JAXRSUtils.mediaTypeToString(ct, new String[0]));
    }

    @Override
    public Client type(String type) {
        this.state.getRequestHeaders().putSingle("Content-Type", type);
        return this;
    }

    @Override
    public Client accept(String ... types) {
        for (String type : types) {
            this.possiblyAddHeader("Accept", type);
        }
        return this;
    }

    @Override
    public Client cookie(Cookie cookie) {
        this.possiblyAddHeader("Cookie", cookie.toString());
        return this;
    }

    @Override
    public Client authorization(Object auth) {
        String value = this.convertParamValue(auth, null);
        this.state.getRequestHeaders().putSingle("Authorization", value);
        return this;
    }

    @Override
    public Client modified(Date date, boolean ifNot) {
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        String hName = ifNot ? "If-Unmodified-Since" : "If-Modified-Since";
        this.state.getRequestHeaders().putSingle(hName, dateFormat.format(date));
        return this;
    }

    @Override
    public Client language(String language) {
        this.state.getRequestHeaders().putSingle("Content-Language", language);
        return this;
    }

    @Override
    public Client match(EntityTag tag, boolean ifNot) {
        String hName = ifNot ? "If-None-Match" : "If-Match";
        this.state.getRequestHeaders().putSingle(hName, tag.toString());
        return this;
    }

    @Override
    public Client acceptLanguage(String ... languages) {
        for (String s : languages) {
            this.possiblyAddHeader("Accept-Language", s);
        }
        return this;
    }

    @Override
    public Client acceptEncoding(String ... encs) {
        for (String s : encs) {
            this.possiblyAddHeader("Accept-Encoding", s);
        }
        return this;
    }

    @Override
    public Client encoding(String enc) {
        this.state.getRequestHeaders().putSingle("Content-Encoding", enc);
        return this;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>(false, true);
        map.putAll((Map<String, String>)this.state.getRequestHeaders());
        return map;
    }

    @Override
    public URI getBaseURI() {
        return this.state.getBaseURI();
    }

    @Override
    public URI getCurrentURI() {
        return this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]);
    }

    @Override
    public Response getResponse() {
        return this.state.getResponse();
    }

    @Override
    public Client reset() {
        this.state.reset();
        return this;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.cfg.getBus() == null) {
                return;
            }
            for (Closeable c : this.cfg.getEndpoint().getCleanupHooks()) {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
            ClientLifeCycleManager mgr = this.cfg.getBus().getExtension(ClientLifeCycleManager.class);
            if (null != mgr) {
                mgr.clientDestroyed(new FrontendClientAdapter(this.getConfiguration()));
            }
            if (this.cfg.getConduitSelector() instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.cfg.getConduitSelector())).close();
                }
                catch (IOException iOException) {}
            } else {
                this.cfg.getConduit().close();
            }
            this.state.reset();
            if (this.cfg.isShutdownBusOnClose()) {
                this.cfg.getBus().shutdown(false);
            }
            this.state = null;
            this.cfg = null;
        }
        this.closed = null;
    }

    private void possiblyAddHeader(String name, String value) {
        if (!this.isDuplicate(name, value)) {
            this.state.getRequestHeaders().add(name, value);
        }
    }

    private boolean isDuplicate(String name, String value) {
        List values = (List)this.state.getRequestHeaders().get(name);
        return values != null && values.contains(value);
    }

    protected ClientState getState() {
        return this.state;
    }

    protected UriBuilder getCurrentBuilder() {
        return this.state.getCurrentBuilder();
    }

    protected void resetResponse() {
        this.state.setResponse(null);
    }

    protected void resetBaseAddress(URI uri) {
        this.state.setBaseURI(uri);
    }

    protected void resetCurrentBuilder(URI uri) {
        this.state.setCurrentBuilder(new UriBuilderImpl(uri));
    }

    protected MultivaluedMap<String, String> getTemplateParametersMap(URITemplate template, List<Object> values) {
        if (values != null && values.size() != 0) {
            List<String> vars = template.getVariables();
            MetadataMap<String, String> templatesMap = new MetadataMap<String, String>(vars.size());
            for (int i = 0; i < vars.size(); ++i) {
                if (i >= values.size()) continue;
                templatesMap.add(vars.get(i), values.get(i).toString());
            }
            return templatesMap;
        }
        return null;
    }

    protected Response.ResponseBuilder setResponseBuilder(Message outMessage, Exchange exchange) throws Exception {
        Message responseMessage;
        Response response = exchange.get(Response.class);
        if (response != null) {
            outMessage.getExchange().getInMessage().put(Message.PROTOCOL_HEADERS, response.getStringHeaders());
            return JAXRSUtils.fromResponse(JAXRSUtils.copyResponseIfNeeded(response));
        }
        Integer status = this.getResponseCode(exchange);
        Response.ResponseBuilder currentResponseBuilder = JAXRSUtils.toResponseBuilder(status);
        Message message = responseMessage = exchange.getInMessage() != null ? exchange.getInMessage() : exchange.getInFaultMessage();
        if (responseMessage == null) {
            return currentResponseBuilder;
        }
        Map protocolHeaders = CastUtils.cast((Map)responseMessage.get(Message.PROTOCOL_HEADERS));
        boolean splitHeaders = MessageUtils.getContextualBoolean(outMessage, HEADER_SPLIT_PROPERTY);
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            if (HttpUtils.isDateRelatedHeader((String)entry.getKey())) {
                currentResponseBuilder.header((String)entry.getKey(), ((List)entry.getValue()).get(0));
                continue;
            }
            for (Object valObject : (List)entry.getValue()) {
                if (splitHeaders && valObject instanceof String) {
                    String[] values;
                    String val = (String)valObject;
                    if (val == null || val.length() == 0) {
                        values = new String[]{""};
                    } else if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
                        values = this.parseQuotedHeaderValue(val);
                    } else {
                        String[] stringArray;
                        boolean splitPossible;
                        boolean bl = splitPossible = !"Set-Cookie".equalsIgnoreCase((String)entry.getKey()) || !val.toUpperCase().contains("Expires".toUpperCase());
                        if (splitPossible) {
                            stringArray = val.split(",");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = val;
                        }
                        values = stringArray;
                    }
                    for (String s : values) {
                        String theValue = s.trim();
                        if (theValue.length() <= 0) continue;
                        currentResponseBuilder.header((String)entry.getKey(), theValue);
                    }
                    continue;
                }
                currentResponseBuilder.header((String)entry.getKey(), valObject);
            }
        }
        String ct = (String)responseMessage.get("Content-Type");
        if (ct != null) {
            currentResponseBuilder.type(ct);
        }
        InputStream mStream = responseMessage.getContent(InputStream.class);
        currentResponseBuilder.entity(mStream);
        return currentResponseBuilder;
    }

    protected <T> void writeBody(T o, Message outMessage, Class<?> cls, Type type, Annotation[] anns, OutputStream os) {
        if (o == null) {
            return;
        }
        MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
        Class<?> theClass = cls;
        Object contentTypeHeader = headers.getFirst("Content-Type");
        if (contentTypeHeader == null) {
            contentTypeHeader = "*/*";
        }
        MediaType contentType = JAXRSUtils.toMediaType(contentTypeHeader.toString());
        List<WriterInterceptor> writers = ClientProviderFactory.getInstance(outMessage).createMessageBodyWriterInterceptor(theClass, type, anns, contentType, outMessage, null);
        if (writers != null) {
            try {
                JAXRSUtils.writeMessageBody(writers, o, theClass, type, anns, contentType, headers, outMessage);
                OutputStream realOs = outMessage.get(OutputStream.class);
                if (realOs != null) {
                    realOs.flush();
                }
            }
            catch (Exception ex) {
                AbstractClient.reportMessageHandlerProblem("MSG_WRITER_PROBLEM", cls, contentType, ex);
            }
        } else {
            AbstractClient.reportMessageHandlerProblem("NO_MSG_WRITER", cls, contentType, null);
        }
    }

    protected WebApplicationException convertToWebApplicationException(Response r) {
        try {
            Class<?> exceptionClass = ExceptionUtils.getWebApplicationExceptionClass(r, WebApplicationException.class);
            Constructor<?> ctr = exceptionClass.getConstructor(Response.class);
            return (WebApplicationException)ctr.newInstance(r);
        }
        catch (Throwable ex2) {
            return new WebApplicationException(r);
        }
    }

    protected <T> T readBody(Response r, Message outMessage, Class<T> cls, Type type, Annotation[] anns) {
        if (cls == Response.class) {
            return cls.cast(r);
        }
        int status = r.getStatus();
        if ((status < 200 || status == 204) && r.getLength() <= 0 || status >= 300) {
            return null;
        }
        return ((ResponseImpl)r).doReadEntity(cls, type, anns);
    }

    protected boolean responseStreamCanBeClosed(Message outMessage, Class<?> cls) {
        return !JAXRSUtils.isStreamingOutType(cls) && MessageUtils.getContextualBoolean(outMessage, "response.stream.auto.close");
    }

    protected void completeExchange(Exchange exchange, boolean proxy) {
        exchange.put(KEEP_CONDUIT_ALIVE, true);
        this.getConfiguration().getConduitSelector().complete(exchange);
        String s = (String)exchange.getOutMessage().get(Message.BASE_PATH);
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            return;
        }
        s = (String)exchange.getOutMessage().get("transport.retransmit.url");
        if (s != null && !this.state.getBaseURI().toString().equals(s)) {
            this.calculateNewRequestURI(URI.create(s), this.getCurrentURI(), proxy);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] preProcessResult(Message message) throws Exception {
        Exchange exchange = message.getExchange();
        Exception ex = message.getContent(Exception.class);
        if (ex == null) {
            ex = message.getExchange().get(Exception.class);
        }
        if (ex == null && !exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                while (exchange.get("IN_CHAIN_COMPLETE") == null) {
                    exchange.wait(this.cfg.getSynchronousTimeout());
                }
            }
        }
        if (ex == null) {
            ex = message.getContent(Exception.class);
        }
        if (ex != null || PropertyUtils.isTrue(exchange.get(SERVICE_NOT_AVAIL_PROPERTY)) && PropertyUtils.isTrue(exchange.get(COMPLETE_IF_SERVICE_NOT_AVAIL_PROPERTY))) {
            this.getConfiguration().getConduitSelector().complete(exchange);
        }
        if (ex != null) {
            this.checkClientException(message, ex);
        }
        this.checkClientException(message, exchange.get(Exception.class));
        List result = exchange.get(List.class);
        return result != null ? result.toArray() : null;
    }

    protected void checkClientException(Message outMessage, Exception ex) throws Exception {
        Exception actualEx = ex instanceof Fault ? ((Fault)ex).getCause() : ex;
        Exchange exchange = outMessage.getExchange();
        Integer responseCode = this.getResponseCode(exchange);
        if (responseCode == null || responseCode < 300 && !(actualEx instanceof IOException) || actualEx instanceof IOException && exchange.get("client.redirect.exception") != null) {
            if (actualEx instanceof ProcessingException) {
                throw (RuntimeException)actualEx;
            }
            if (actualEx != null) {
                Object useProcExProp = exchange.get("wrap.in.processing.exception");
                if (actualEx instanceof RuntimeException && useProcExProp != null && PropertyUtils.isFalse(useProcExProp)) {
                    throw actualEx;
                }
                throw new ProcessingException(actualEx);
            }
            if (!exchange.isOneWay() || this.cfg.isResponseExpectedForOneway()) {
                this.waitForResponseCode(exchange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResponseCode(Exchange exchange) {
        Exchange exchange2 = exchange;
        synchronized (exchange2) {
            if (this.getResponseCode(exchange) == null) {
                try {
                    exchange.wait(this.cfg.getSynchronousTimeout());
                }
                catch (InterruptedException interruptedException) {}
            } else {
                return;
            }
        }
        if (this.getResponseCode(exchange) == null) {
            throw new ProcessingException("Response timeout");
        }
    }

    private Integer getResponseCode(Exchange exchange) {
        Integer responseCode = (Integer)exchange.get(Message.RESPONSE_CODE);
        if (responseCode == null && exchange.getInMessage() != null) {
            responseCode = (Integer)exchange.getInMessage().get(Message.RESPONSE_CODE);
        }
        if (responseCode == null && exchange.isOneWay() && !this.state.getBaseURI().toString().startsWith(HTTP_SCHEME)) {
            responseCode = 202;
        }
        return responseCode;
    }

    protected URI calculateNewRequestURI(Map<String, Object> reqContext) {
        URI newBaseURI = URI.create(reqContext.get(Message.ENDPOINT_ADDRESS).toString());
        URI requestURI = URI.create(reqContext.get("org.apache.cxf.request.uri").toString());
        return this.calculateNewRequestURI(newBaseURI, requestURI, PropertyUtils.isTrue(reqContext.get(PROXY_PROPERTY)));
    }

    private URI calculateNewRequestURI(URI newBaseURI, URI requestURI, boolean proxy) {
        String basePath;
        String baseURIPath = newBaseURI.getRawPath();
        String reqURIPath = requestURI.getRawPath();
        UriBuilder builder = new UriBuilderImpl().uri(newBaseURI);
        String string = basePath = reqURIPath.startsWith(baseURIPath) ? baseURIPath : this.getBaseURI().getRawPath();
        String relativePath = reqURIPath.equals(basePath) ? "" : (reqURIPath.startsWith(basePath) ? reqURIPath.substring(basePath.length()) : reqURIPath);
        builder.path(relativePath);
        String newQuery = newBaseURI.getRawQuery();
        if (newQuery == null) {
            builder.replaceQuery(requestURI.getRawQuery());
        } else {
            builder.replaceQuery(newQuery);
        }
        URI newRequestURI = builder.build(new Object[0]);
        this.resetBaseAddress(newBaseURI);
        URI current = proxy ? newBaseURI : newRequestURI;
        this.resetCurrentBuilder(current);
        return newRequestURI;
    }

    protected void doRunInterceptorChain(Message m) {
        try {
            m.getInterceptorChain().doIntercept(m);
        }
        catch (Exception ex) {
            m.setContent(Exception.class, ex);
        }
    }

    protected Object[] retryInvoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
        try {
            Object body = params.length == 0 ? null : params[0];
            Map<String, Object> reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
            MultivaluedMap headers = (MultivaluedMap)reqContext.get(Message.PROTOCOL_HEADERS);
            URI newRequestURI = this.calculateNewRequestURI(reqContext);
            Object response = this.retryInvoke(newRequestURI, headers, body, exchange, context);
            exchange.put(List.class, this.getContentsList(response));
            return new Object[]{response};
        }
        catch (Throwable t) {
            Exception ex = t instanceof Exception ? (Exception)t : new Exception(t);
            exchange.put(Exception.class, ex);
            return null;
        }
    }

    protected abstract Object retryInvoke(URI var1, MultivaluedMap<String, String> var2, Object var3, Exchange var4, Map<String, Object> var5) throws Throwable;

    protected void addMatrixQueryParamsToBuilder(UriBuilder ub, String paramName, ParameterType pt, Annotation[] anns, Object ... pValues) {
        if (pt != ParameterType.MATRIX && pt != ParameterType.QUERY) {
            throw new IllegalArgumentException("This method currently deal with matrix and query parameters only");
        }
        if (!"".equals(paramName)) {
            if (pValues != null && pValues.length > 0) {
                for (Object pValue : pValues) {
                    if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                        List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                        Iterator it = c.iterator();
                        while (it.hasNext()) {
                            this.convertMatrixOrQueryToBuilder(ub, paramName, it.next(), pt, anns);
                        }
                        continue;
                    }
                    this.convertMatrixOrQueryToBuilder(ub, paramName, pValue, pt, anns);
                }
            } else {
                this.addMatrixOrQueryToBuilder(ub, paramName, pt, pValues);
            }
        } else {
            Object pValue = pValues[0];
            MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(pValue, "");
            for (Map.Entry entry : values.entrySet()) {
                for (Object v : (List)entry.getValue()) {
                    this.convertMatrixOrQueryToBuilder(ub, (String)entry.getKey(), v, pt, anns);
                }
            }
        }
    }

    private void convertMatrixOrQueryToBuilder(UriBuilder ub, String paramName, Object pValue, ParameterType pt, Annotation[] anns) {
        String convertedValue = this.convertParamValue(pValue, anns);
        this.addMatrixOrQueryToBuilder(ub, paramName, pt, convertedValue);
    }

    private void addMatrixOrQueryToBuilder(UriBuilder ub, String paramName, ParameterType pt, Object ... pValue) {
        if (pt == ParameterType.MATRIX) {
            ub.matrixParam(paramName, pValue);
        } else {
            ub.queryParam(paramName, pValue);
        }
    }

    protected String convertParamValue(Object pValue, Annotation[] anns) {
        return this.convertParamValue(pValue, pValue == null ? null : pValue.getClass(), anns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String convertParamValue(Object pValue, Class<?> pClass, Annotation[] anns) {
        if (pValue == null && pClass == null) {
            return null;
        }
        ClientProviderFactory pf = ClientProviderFactory.getInstance(this.cfg.getEndpoint());
        if (pf != null) {
            ParamConverter<?> prov;
            MessageImpl m = null;
            if (pf.isParamConverterContextsAvailable()) {
                m = new MessageImpl();
                m.put("org.apache.cxf.client", Boolean.TRUE);
                m.setExchange(new ExchangeImpl());
                m.getExchange().setOutMessage(m);
                m.getExchange().put(Endpoint.class, this.cfg.getEndpoint());
            }
            if ((prov = pf.createParameterHandler(pClass, pClass, anns, m)) != null) {
                try {
                    String string = prov.toString(pValue);
                    return string;
                }
                finally {
                    if (m != null) {
                        pf.clearThreadLocalProxies();
                    }
                }
            }
        }
        return pValue == null ? null : pValue.toString();
    }

    protected static void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable ex) {
        String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
        Throwable actualEx = ex instanceof Fault ? ((Fault)ex).getCause() : ex;
        throw new ProcessingException(errorMessage, actualEx);
    }

    protected static void setAllHeaders(MultivaluedMap<String, String> headers, HttpURLConnection conn) {
        for (Map.Entry entry : headers.entrySet()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String value = (String)((List)entry.getValue()).get(i);
                b.append(value);
                if (i + 1 >= ((List)entry.getValue()).size()) continue;
                b.append(',');
            }
            conn.setRequestProperty((String)entry.getKey(), b.toString());
        }
    }

    protected String[] parseQuotedHeaderValue(String originalValue) {
        ArrayList<String> results = new ArrayList<String>();
        char[] chars = originalValue.toCharArray();
        int lastIndex = chars.length - 1;
        boolean quote = false;
        StringBuilder sb = new StringBuilder();
        block5: for (int pos = 0; pos <= lastIndex; ++pos) {
            char c = chars[pos];
            if (pos == lastIndex) {
                sb.append(c);
                results.add(sb.toString());
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append(c);
                    quote = !quote;
                    continue block5;
                }
                case '\\': {
                    if (quote) {
                        if (++pos <= lastIndex) {
                            c = chars[pos];
                            sb.append(c);
                        }
                        if (pos != lastIndex) continue block5;
                        results.add(sb.toString());
                        continue block5;
                    }
                    sb.append(c);
                    continue block5;
                }
                case ',': {
                    if (quote) {
                        sb.append(c);
                        continue block5;
                    }
                    results.add(sb.toString());
                    sb = new StringBuilder();
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return results.toArray(new String[results.size()]);
    }

    protected ClientConfiguration getConfiguration() {
        return this.cfg;
    }

    protected void setConfiguration(ClientConfiguration config) {
        this.cfg = config;
    }

    protected void prepareConduitSelector(Message message, URI currentURI, boolean proxy) {
        try {
            this.cfg.prepareConduitSelector(message);
        }
        catch (Fault ex) {
            LOG.warning("Failure to prepare a message from conduit selector");
        }
        message.getExchange().put(ConduitSelector.class, this.cfg.getConduitSelector());
        message.getExchange().put(Service.class, this.cfg.getConduitSelector().getEndpoint().getService());
        String address = (String)message.get(Message.ENDPOINT_ADDRESS);
        if (address.startsWith(HTTP_SCHEME) && !address.equals(currentURI.toString())) {
            URI baseAddress = URI.create(address);
            currentURI = this.calculateNewRequestURI(baseAddress, currentURI, proxy);
            message.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
            message.put("org.apache.cxf.request.uri", currentURI.toString());
        }
        message.put(Message.BASE_PATH, this.getBaseURI().toString());
    }

    protected static PhaseInterceptorChain setupOutInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getOutInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getOutInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getOutInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getOutPhases(), i1, i2, i3);
        chain.add(new ClientRequestFilterInterceptor());
        return chain;
    }

    protected static PhaseInterceptorChain setupInInterceptorChain(ClientConfiguration cfg) {
        PhaseManager pm = cfg.getBus().getExtension(PhaseManager.class);
        List<Interceptor<? extends Message>> i1 = cfg.getBus().getInInterceptors();
        List<Interceptor<? extends Message>> i2 = cfg.getInInterceptors();
        List<Interceptor<? extends Message>> i3 = cfg.getConduitSelector().getEndpoint().getInInterceptors();
        PhaseInterceptorChain chain = new PhaseChainCache().get(pm.getInPhases(), i1, i2, i3);
        chain.add(new ClientResponseFilterInterceptor());
        return chain;
    }

    protected static MessageObserver setupInFaultObserver(final ClientConfiguration cfg) {
        return new InFaultChainInitiatorObserver(cfg.getBus()){

            @Override
            protected void initializeInterceptors(Exchange ex, PhaseInterceptorChain chain) {
                chain.add(cfg.getInFaultInterceptors());
                chain.add(new ConnectionFaultInterceptor());
            }
        };
    }

    protected void setSupportOnewayResponseProperty(Message outMessage) {
        if (!outMessage.getExchange().isOneWay()) {
            outMessage.put("org.apache.cxf.transport.processOneWayResponse", true);
        }
    }

    private void checkClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Client is closed");
        }
    }

    protected Message createMessage(Object body, String httpMethod, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        this.checkClosed();
        Message m = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage();
        m.put("org.apache.cxf.client", Boolean.TRUE);
        m.put("org.apache.cxf.message.inbound", Boolean.FALSE);
        this.setRequestMethod(m, httpMethod);
        m.put(Message.PROTOCOL_HEADERS, headers);
        if (currentURI.isAbsolute() && currentURI.getScheme().startsWith(HTTP_SCHEME)) {
            m.put(Message.ENDPOINT_ADDRESS, currentURI.toString());
        } else {
            m.put(Message.ENDPOINT_ADDRESS, this.state.getBaseURI().toString());
        }
        Object requestURIProperty = this.cfg.getRequestContext().get("org.apache.cxf.request.uri");
        if (requestURIProperty == null) {
            m.put("org.apache.cxf.request.uri", currentURI.toString());
        } else {
            m.put("org.apache.cxf.request.uri", requestURIProperty.toString());
        }
        String ct = headers.getFirst("Content-Type");
        m.put("Content-Type", ct);
        body = this.checkIfBodyEmpty(body, ct);
        this.setEmptyRequestPropertyIfNeeded(m, body);
        m.setContent(List.class, this.getContentsList(body));
        m.put("jaxrs.template.parameters", this.getState().getTemplates());
        PhaseInterceptorChain chain = AbstractClient.setupOutInterceptorChain(this.cfg);
        chain.setFaultObserver(AbstractClient.setupInFaultObserver(this.cfg));
        m.setInterceptorChain(chain);
        exchange = this.createExchange(m, exchange);
        exchange.put("org.apache.cxf.rest.message", Boolean.TRUE);
        exchange.setOneWay("true".equals(headers.getFirst("OnewayRequest")));
        exchange.put(Retryable.class, new RetryableImpl());
        this.setContexts(m, exchange, invocationContext, proxy);
        this.prepareConduitSelector(m, currentURI, proxy);
        return m;
    }

    private void setRequestMethod(Message m, String httpMethod) {
        m.put("org.apache.cxf.request.method", httpMethod);
        if (!KNOWN_METHODS.contains(httpMethod)) {
            if (!m.containsKey("use.async.http.conduit")) {
                m.put("use.async.http.conduit", true);
            }
            if (!m.containsKey("use.httpurlconnection.method.reflection")) {
                m.put("use.httpurlconnection.method.reflection", true);
            }
        }
    }

    protected void setEmptyRequestPropertyIfNeeded(Message outMessage, Object body) {
        if (body == null) {
            outMessage.put("org.apache.cxf.empty.request", true);
        }
    }

    protected Object checkIfBodyEmpty(Object body, String contentType) {
        if (body != null && (body.getClass() == String.class && ((String)body).length() == 0 || body.getClass() == Form.class && ((Form)body).asMap().isEmpty() || Map.class.isAssignableFrom(body.getClass()) && ((Map)body).isEmpty() && !"application/json".equals(contentType) || body instanceof byte[] && ((byte[])body).length == 0)) {
            body = null;
        }
        return body;
    }

    protected Map<String, Object> getRequestContext(Message outMessage) {
        Map invContext = CastUtils.cast((Map)outMessage.get("org.apache.cxf.invocation.context"));
        return CastUtils.cast((Map)invContext.get(REQUEST_CONTEXT));
    }

    protected List<?> getContentsList(Object body) {
        return body == null ? new MessageContentsList() : new MessageContentsList(body);
    }

    protected Exchange createExchange(Message m, Exchange exchange) {
        if (exchange == null) {
            exchange = new ExchangeImpl();
        }
        exchange.setSynchronous(true);
        exchange.setOutMessage(m);
        exchange.put(Bus.class, this.cfg.getBus());
        exchange.put(MessageObserver.class, new ClientMessageObserver(this.cfg));
        exchange.put(Endpoint.class, this.cfg.getConduitSelector().getEndpoint());
        exchange.put("org.apache.cxf.transport.no_io_exceptions", true);
        exchange.put(StaxInEndingInterceptor.STAX_IN_NOCLOSE, Boolean.TRUE);
        m.setExchange(exchange);
        return exchange;
    }

    protected void setAsyncMessageObserverIfNeeded(Exchange exchange) {
        ExecutorService executor;
        if (!exchange.isSynchronous() && (executor = (ExecutorService)this.cfg.getRequestContext().get(EXECUTOR_SERVICE_PROPERTY)) != null) {
            exchange.put(Executor.class, executor);
            final ClientMessageObserver observer = new ClientMessageObserver(this.cfg);
            exchange.put(MessageObserver.class, new MessageObserver(){

                @Override
                public void onMessage(final Message message) {
                    if (!message.getExchange().containsKey(Executor.class.getName() + ".USING_SPECIFIED")) {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                observer.onMessage(message);
                            }
                        });
                    } else {
                        observer.onMessage(message);
                    }
                }
            });
        }
    }

    protected void setContexts(Message message, Exchange exchange, Map<String, Object> context, boolean proxy) {
        Map reqContext = null;
        Map resContext = null;
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        reqContext = CastUtils.cast((Map)context.get(REQUEST_CONTEXT));
        resContext = CastUtils.cast((Map)context.get(RESPONSE_CONTEXT));
        if (reqContext == null) {
            reqContext = new HashMap<String, Object>(this.cfg.getRequestContext());
            context.put(REQUEST_CONTEXT, reqContext);
        }
        reqContext.put(Message.PROTOCOL_HEADERS, message.get(Message.PROTOCOL_HEADERS));
        reqContext.put("org.apache.cxf.request.uri", message.get("org.apache.cxf.request.uri"));
        reqContext.put(Message.ENDPOINT_ADDRESS, message.get(Message.ENDPOINT_ADDRESS));
        reqContext.put(PROXY_PROPERTY, proxy);
        if (resContext == null) {
            resContext = new HashMap();
            context.put(RESPONSE_CONTEXT, resContext);
        }
        message.put("org.apache.cxf.invocation.context", context);
        message.putAll(reqContext);
        exchange.putAll(reqContext);
    }

    protected void setPlainOperationNameProperty(Message outMessage, String name) {
        outMessage.getExchange().put("org.apache.cxf.resource.operation.name", name);
    }

    protected static Type getCallbackType(InvocationCallback<?> callback) {
        Class<?> cls = callback.getClass();
        ParameterizedType pt = AbstractClient.findCallbackType(cls);
        Type actualType = null;
        int n = 0;
        Type[] typeArray = pt.getActualTypeArguments();
        int n2 = typeArray.length;
        if (n < n2) {
            Type tp;
            actualType = tp = typeArray[n];
        }
        if (actualType instanceof TypeVariable) {
            actualType = InjectionUtils.getSuperType(cls, (TypeVariable)actualType);
        }
        return actualType;
    }

    protected static ParameterizedType findCallbackType(Class<?> cls) {
        if (cls == null || cls == Object.class) {
            return null;
        }
        for (Type c2 : cls.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(c2 instanceof ParameterizedType) || !InvocationCallback.class.equals((Object)(pt = (ParameterizedType)c2).getRawType())) continue;
            return pt;
        }
        return AbstractClient.findCallbackType(cls.getSuperclass());
    }

    protected static Class<?> getCallbackClass(Type outType) {
        Class respClass = null;
        if (outType instanceof Class) {
            respClass = (Class)outType;
        } else if (outType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)outType;
            if (pt.getRawType() instanceof Class) {
                respClass = (Class)pt.getRawType();
            }
        } else if (outType == null) {
            respClass = Response.class;
        }
        return respClass;
    }

    protected void resetResponseStateImmediatelyIfNeeded() {
        if (this.state instanceof ThreadLocalClientState && this.cfg.isResetThreadLocalStateImmediately()) {
            this.state.reset();
        }
    }

    protected abstract class AbstractClientAsyncResponseInterceptor
    extends AbstractPhaseInterceptor<Message> {
        AbstractClientAsyncResponseInterceptor() {
            super("unmarshal");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) throws Fault {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().put("IN_CHAIN_COMPLETE", Boolean.TRUE);
                message.getExchange().notifyAll();
            }
            if (message.getExchange().isSynchronous()) {
                return;
            }
            this.handleAsyncResponse(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleFault(Message message) {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().put("IN_CHAIN_COMPLETE", Boolean.TRUE);
                message.getExchange().notifyAll();
            }
            if (message.getExchange().isSynchronous()) {
                return;
            }
            this.handleAsyncFault(message);
        }

        private void handleAsyncResponse(Message message) {
            JaxrsClientCallback cb = message.getExchange().get(JaxrsClientCallback.class);
            Response r = null;
            try {
                Object[] results = AbstractClient.this.preProcessResult(message);
                if (results != null && results.length == 1) {
                    r = (Response)results[0];
                }
            }
            catch (Exception ex) {
                WebApplicationException t = ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : new ProcessingException(ex));
                cb.handleException(message, t);
                return;
            }
            this.doHandleAsyncResponse(message, r, cb);
        }

        protected abstract void doHandleAsyncResponse(Message var1, Response var2, JaxrsClientCallback<?> var3);

        protected void closeAsyncResponseIfPossible(Response r, Message outMessage, JaxrsClientCallback<?> cb) {
            if (AbstractClient.this.responseStreamCanBeClosed(outMessage, cb.getResponseClass())) {
                r.close();
            }
        }

        protected void handleAsyncFault(Message message) {
        }
    }

    private static class ConnectionFaultInterceptor
    extends AbstractPhaseInterceptor<Message> {
        ConnectionFaultInterceptor() {
            super("pre-stream");
        }

        @Override
        public void handleMessage(Message message) throws Fault {
            if (!message.getExchange().isSynchronous()) {
                Throwable ex = message.getContent(Exception.class);
                if (ex == null) {
                    ex = message.getExchange().get(Exception.class);
                }
                if (ex != null) {
                    JaxrsClientCallback cb = message.getExchange().get(JaxrsClientCallback.class);
                    if (ex instanceof Fault) {
                        ex = ex.getCause();
                    }
                    ex = ex instanceof ProcessingException ? ex : new ProcessingException(ex);
                    cb.handleException(message, ex);
                }
            }
        }
    }

    private class RetryableImpl
    implements Retryable {
        private RetryableImpl() {
        }

        @Override
        public Object[] invoke(BindingOperationInfo oi, Object[] params, Map<String, Object> context, Exchange exchange) throws Exception {
            return AbstractClient.this.retryInvoke(oi, params, context, exchange);
        }
    }

    protected abstract class AbstractBodyWriter
    extends AbstractOutDatabindingInterceptor {
        public AbstractBodyWriter() {
            super("write");
        }

        @Override
        public void handleMessage(Message outMessage) throws Fault {
            XMLStreamWriter writer;
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            OutputStream os = outMessage.getContent(OutputStream.class);
            if (os == null && (writer = outMessage.getContent(XMLStreamWriter.class)) == null) {
                return;
            }
            Object body = objs.get(0);
            Annotation[] customAnns = (Annotation[])outMessage.get(Annotation.class.getName());
            Type t = outMessage.get(Type.class);
            this.doWriteBody(outMessage, body, t, customAnns, os);
        }

        protected abstract void doWriteBody(Message var1, Object var2, Type var3, Annotation[] var4, OutputStream var5) throws Fault;
    }
}

