/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.CompletionStageRxInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class InvocationBuilderImpl
implements Invocation.Builder {
    private static final String PROPERTY_KEY = "jaxrs.filter.properties";
    private WebClient webClient;
    private SyncInvoker sync;
    private Configuration config;

    public InvocationBuilderImpl(WebClient webClient, Configuration config) {
        this.webClient = webClient;
        this.sync = webClient.sync();
        this.config = config;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    @Override
    public Response delete() {
        return this.sync.delete();
    }

    @Override
    public <T> T delete(Class<T> cls) {
        return this.sync.delete(cls);
    }

    @Override
    public <T> T delete(GenericType<T> type) {
        return this.sync.delete(type);
    }

    @Override
    public Response get() {
        return this.sync.get();
    }

    @Override
    public <T> T get(Class<T> cls) {
        return this.sync.get(cls);
    }

    @Override
    public <T> T get(GenericType<T> type) {
        return this.sync.get(type);
    }

    @Override
    public Response head() {
        return this.sync.head();
    }

    @Override
    public Response method(String method) {
        return this.sync.method(method);
    }

    @Override
    public <T> T method(String method, Class<T> cls) {
        return this.sync.method(method, cls);
    }

    @Override
    public <T> T method(String method, GenericType<T> type) {
        return this.sync.method(method, type);
    }

    @Override
    public Response method(String method, Entity<?> entity) {
        return this.sync.method(method, entity);
    }

    @Override
    public <T> T method(String method, Entity<?> entity, Class<T> cls) {
        return this.sync.method(method, entity, cls);
    }

    @Override
    public <T> T method(String method, Entity<?> entity, GenericType<T> type) {
        return this.sync.method(method, entity, type);
    }

    @Override
    public Response options() {
        return this.sync.options();
    }

    @Override
    public <T> T options(Class<T> cls) {
        return this.sync.options(cls);
    }

    @Override
    public <T> T options(GenericType<T> type) {
        return this.sync.options(type);
    }

    @Override
    public Response post(Entity<?> entity) {
        return this.sync.post(entity);
    }

    @Override
    public <T> T post(Entity<?> entity, Class<T> cls) {
        return this.sync.post(entity, cls);
    }

    @Override
    public <T> T post(Entity<?> entity, GenericType<T> type) {
        return this.sync.post(entity, type);
    }

    @Override
    public Response put(Entity<?> entity) {
        return this.sync.put(entity);
    }

    @Override
    public <T> T put(Entity<?> entity, Class<T> cls) {
        return this.sync.put(entity, cls);
    }

    @Override
    public <T> T put(Entity<?> entity, GenericType<T> type) {
        return this.sync.put(entity, type);
    }

    @Override
    public Response trace() {
        return this.sync.trace();
    }

    @Override
    public <T> T trace(Class<T> cls) {
        return this.sync.trace(cls);
    }

    @Override
    public <T> T trace(GenericType<T> type) {
        return this.sync.trace(type);
    }

    @Override
    public Invocation.Builder accept(String ... types) {
        this.webClient.accept(types);
        return this;
    }

    @Override
    public Invocation.Builder accept(MediaType ... types) {
        this.webClient.accept(types);
        return this;
    }

    @Override
    public Invocation.Builder acceptEncoding(String ... enc) {
        this.webClient.acceptEncoding(enc);
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(Locale ... lang) {
        for (Locale l : lang) {
            this.webClient.acceptLanguage(HttpUtils.toHttpLanguage(l));
        }
        return this;
    }

    @Override
    public Invocation.Builder acceptLanguage(String ... lang) {
        this.webClient.acceptLanguage(lang);
        return this;
    }

    @Override
    public Invocation.Builder cacheControl(CacheControl control) {
        this.webClient.header("Cache-Control", control.toString());
        return this;
    }

    @Override
    public Invocation.Builder cookie(Cookie cookie) {
        this.webClient.cookie(cookie);
        return this;
    }

    @Override
    public Invocation.Builder cookie(String name, String value) {
        this.webClient.header("Cookie", name + "=" + value);
        return this;
    }

    @Override
    public Invocation.Builder header(String name, Object value) {
        RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
        this.doSetHeader(rd, name, value);
        return this;
    }

    @Override
    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
        for (Map.Entry entry : headers.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                this.doSetHeader(rd, (String)entry.getKey(), value);
            }
        }
        return this;
    }

    private void doSetHeader(RuntimeDelegate rd, String name, Object value) {
        RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(rd, value);
        if (hd != null) {
            value = hd.toString(value);
        }
        this.webClient.header(name, value);
    }

    @Override
    public Invocation.Builder property(String name, Object value) {
        Map<String, Object> contextProps = WebClient.getConfig(this.webClient).getRequestContext();
        Map filterProps = CastUtils.cast((Map)contextProps.get(PROPERTY_KEY));
        if (filterProps == null) {
            filterProps = new HashMap();
            contextProps.put(PROPERTY_KEY, filterProps);
        }
        if (value == null) {
            filterProps.remove(name);
        } else {
            filterProps.put(name, value);
        }
        return this;
    }

    @Override
    public AsyncInvoker async() {
        return this.webClient.async();
    }

    @Override
    public Invocation build(String method) {
        return new InvocationImpl(method);
    }

    @Override
    public Invocation build(String method, Entity<?> entity) {
        return new InvocationImpl(method, entity);
    }

    @Override
    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    @Override
    public Invocation buildGet() {
        return this.build("GET");
    }

    @Override
    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    @Override
    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    @Override
    public CompletionStageRxInvoker rx() {
        return this.webClient.rx(this.getConfiguredExecutorService());
    }

    @Override
    public <T extends RxInvoker> T rx(Class<T> rxCls) {
        return this.webClient.rx(rxCls, this.getConfiguredExecutorService());
    }

    private ExecutorService getConfiguredExecutorService() {
        return (ExecutorService)this.config.getProperty("executorService");
    }

    private class InvocationImpl
    implements Invocation {
        private Invocation.Builder invBuilder;
        private String httpMethod;
        private Entity<?> entity;

        InvocationImpl(String httpMethod) {
            this(httpMethod, null);
        }

        InvocationImpl(String httpMethod, Entity<?> entity) {
            this.invBuilder = InvocationBuilderImpl.this;
            this.httpMethod = httpMethod;
            this.entity = entity;
        }

        @Override
        public Response invoke() {
            return this.invBuilder.method(this.httpMethod, this.entity);
        }

        @Override
        public <T> T invoke(Class<T> cls) {
            return this.invBuilder.method(this.httpMethod, this.entity, cls);
        }

        @Override
        public <T> T invoke(GenericType<T> type) {
            return this.invBuilder.method(this.httpMethod, this.entity, type);
        }

        @Override
        public Invocation property(String name, Object value) {
            this.invBuilder.property(name, value);
            return this;
        }

        @Override
        public Future<Response> submit() {
            return this.invBuilder.async().method(this.httpMethod, this.entity);
        }

        @Override
        public <T> Future<T> submit(Class<T> cls) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, cls);
        }

        @Override
        public <T> Future<T> submit(GenericType<T> type) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, type);
        }

        @Override
        public <T> Future<T> submit(InvocationCallback<T> callback) {
            return this.invBuilder.async().method(this.httpMethod, this.entity, callback);
        }
    }
}

