/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.ReaderInputStream;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class ResponseImpl
extends Response {
    private Response.StatusType status;
    private Object entity;
    private Annotation[] entityAnnotations;
    private MultivaluedMap<String, Object> metadata;
    private Message outMessage;
    private boolean entityClosed;
    private boolean entityBufferred;
    private Object lastEntity;

    ResponseImpl(int statusCode) {
        this.status = this.createStatusType(statusCode, null);
    }

    ResponseImpl(int statusCode, Object entity) {
        this(statusCode);
        this.entity = entity;
    }

    ResponseImpl(int statusCode, Object entity, String reasonPhrase) {
        this.status = this.createStatusType(statusCode, reasonPhrase);
        this.entity = entity;
    }

    public void addMetadata(MultivaluedMap<String, Object> meta) {
        this.metadata = meta;
    }

    public void setStatus(int statusCode) {
        this.status = this.createStatusType(statusCode, null);
    }

    public void setStatus(int statusCode, String reasonPhrase) {
        this.status = this.createStatusType(statusCode, reasonPhrase);
    }

    public void setEntity(Object e, Annotation[] anns) {
        this.entity = e;
        this.entityAnnotations = anns;
    }

    public void setEntityAnnotations(Annotation[] anns) {
        this.entityAnnotations = anns;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setOutMessage(Message message) {
        this.outMessage = message;
    }

    public Message getOutMessage() {
        return this.outMessage;
    }

    @Override
    public int getStatus() {
        return this.status.getStatusCode();
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public Object getActualEntity() {
        this.checkEntityIsClosed();
        return this.lastEntity != null ? this.lastEntity : this.entity;
    }

    @Override
    public Object getEntity() {
        return InjectionUtils.getEntity(this.getActualEntity());
    }

    @Override
    public boolean hasEntity() {
        return this.getActualEntity() != null;
    }

    @Override
    public MultivaluedMap<String, Object> getMetadata() {
        return this.getHeaders();
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.metadata;
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        MetadataMap<String, String> headers = new MetadataMap<String, String>(this.metadata.size());
        for (Map.Entry entry : this.metadata.entrySet()) {
            String headerName = (String)entry.getKey();
            headers.put(headerName, this.toListOfStrings(headerName, (List)entry.getValue()));
        }
        return headers;
    }

    @Override
    public String getHeaderString(String header) {
        List methodValues = (List)this.metadata.get(header);
        return HttpUtils.getHeaderString(this.toListOfStrings(header, methodValues));
    }

    private List<String> toListOfStrings(String headerName, List<Object> values) {
        if (values == null) {
            return null;
        }
        ArrayList<String> stringValues = new ArrayList<String>(values.size());
        RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(values.get(0));
        for (Object value : values) {
            String actualValue = hd == null ? value.toString() : hd.toString(value);
            stringValues.add(actualValue);
        }
        return stringValues;
    }

    @Override
    public Set<String> getAllowedMethods() {
        List methodValues = (List)this.metadata.get("Allow");
        if (methodValues == null) {
            return Collections.emptySet();
        }
        HashSet<String> methods = new HashSet<String>();
        for (Object o : methodValues) {
            methods.add(o.toString());
        }
        return methods;
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        List cookieValues = (List)this.metadata.get("Set-Cookie");
        if (cookieValues == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> cookies = new HashMap<String, NewCookie>();
        for (Object o : cookieValues) {
            NewCookie newCookie = NewCookie.valueOf(o.toString());
            cookies.put(newCookie.getName(), newCookie);
        }
        return cookies;
    }

    @Override
    public Date getDate() {
        return this.doGetDate("Date");
    }

    private Date doGetDate(String dateHeader) {
        Object value = this.metadata.getFirst(dateHeader);
        return value == null || value instanceof Date ? (Date)value : HttpUtils.getHttpDate(value.toString());
    }

    @Override
    public EntityTag getEntityTag() {
        Object header = this.metadata.getFirst("ETag");
        return header == null || header instanceof EntityTag ? (EntityTag)header : EntityTag.valueOf(header.toString());
    }

    @Override
    public Locale getLanguage() {
        Object header = this.metadata.getFirst("Content-Language");
        return header == null || header instanceof Locale ? (Locale)header : HttpUtils.getLocale(header.toString());
    }

    @Override
    public Date getLastModified() {
        return this.doGetDate("Last-Modified");
    }

    @Override
    public int getLength() {
        Object header = this.metadata.getFirst("Content-Length");
        return HttpUtils.getContentLength(header == null ? null : header.toString());
    }

    @Override
    public URI getLocation() {
        Object header = this.metadata.getFirst("Location");
        return header == null || header instanceof URI ? (URI)header : URI.create(header.toString());
    }

    @Override
    public MediaType getMediaType() {
        Object header = this.metadata.getFirst("Content-Type");
        return header == null || header instanceof MediaType ? (MediaType)header : JAXRSUtils.toMediaType(header.toString());
    }

    @Override
    public boolean hasLink(String relation) {
        List linkValues = (List)this.metadata.get("Link");
        if (linkValues != null) {
            for (Object o : linkValues) {
                Link link = o instanceof Link ? (Link)o : Link.valueOf(o.toString());
                if (!relation.equals(link.getRel())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Link getLink(String relation) {
        Set<Link> links = this.getAllLinks();
        for (Link link : links) {
            if (link.getRel() == null || !link.getRel().equals(relation)) continue;
            return link;
        }
        return null;
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        return link == null ? null : Link.fromLink(link);
    }

    @Override
    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getAllLinks());
    }

    private Set<Link> getAllLinks() {
        List linkValues = (List)this.metadata.get("Link");
        if (linkValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Link> links = new LinkedHashSet<Link>();
        for (Object o : linkValues) {
            Link link;
            Link link2 = link = o instanceof Link ? (Link)o : Link.valueOf(o.toString());
            if (!link.getUri().isAbsolute()) {
                URI requestURI = URI.create((String)this.outMessage.get("org.apache.cxf.request.uri"));
                link = Link.fromLink(link).baseUri(requestURI).build(new Object[0]);
            }
            links.add(link);
        }
        return links;
    }

    @Override
    public <T> T readEntity(Class<T> cls) throws ProcessingException, IllegalStateException {
        return this.readEntity(cls, new Annotation[0]);
    }

    @Override
    public <T> T readEntity(GenericType<T> genType) throws ProcessingException, IllegalStateException {
        return this.readEntity(genType, new Annotation[0]);
    }

    @Override
    public <T> T readEntity(Class<T> cls, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return this.doReadEntity(cls, cls, anns);
    }

    @Override
    public <T> T readEntity(GenericType<T> genType, Annotation[] anns) throws ProcessingException, IllegalStateException {
        return (T)this.doReadEntity(genType.getRawType(), genType.getType(), anns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doReadEntity(Class<T> cls, Type t, Annotation[] anns) throws ProcessingException, IllegalStateException {
        List<ReaderInterceptor> readers;
        this.checkEntityIsClosed();
        if (this.lastEntity != null && cls.isAssignableFrom(this.lastEntity.getClass()) && !(this.lastEntity instanceof InputStream)) {
            return cls.cast(this.lastEntity);
        }
        MediaType mediaType = this.getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        boolean entityStreamAvailable = this.entityStreamAvailable();
        InputStream entityStream = null;
        if (!entityStreamAvailable) {
            entityStream = this.convertEntityToStreamIfPossible();
            entityStreamAvailable = entityStream != null;
        } else if (this.entity instanceof InputStream) {
            entityStream = (InputStream)InputStream.class.cast(this.entity);
        } else {
            Message inMessage = this.getResponseMessage();
            Reader reader = inMessage.getContent(Reader.class);
            if (reader != null) {
                entityStream = (InputStream)InputStream.class.cast(new ReaderInputStream(reader));
            }
        }
        List<ReaderInterceptor> list = readers = this.outMessage == null ? null : ProviderFactory.getInstance(this.outMessage).createMessageBodyReaderInterceptor(cls, t, anns, mediaType, this.outMessage, entityStreamAvailable, null);
        if (readers != null) {
            try {
                if (this.entityBufferred) {
                    ((InputStream)InputStream.class.cast(this.entity)).reset();
                }
                Message responseMessage = this.getResponseMessage();
                responseMessage.put(Message.PROTOCOL_HEADERS, this.getHeaders());
                this.lastEntity = JAXRSUtils.readFromMessageBodyReader(readers, cls, t, anns, entityStream, mediaType, responseMessage);
                this.autoClose(cls, false);
                T t2 = this.castLastEntity();
                return t2;
            }
            catch (Exception ex) {
                this.autoClose(cls, true);
                this.reportMessageHandlerProblem("MSG_READER_PROBLEM", cls, mediaType, ex);
            }
            finally {
                ProviderFactory pf = ProviderFactory.getInstance(this.outMessage);
                if (pf != null) {
                    pf.clearThreadLocalProxies();
                }
            }
        } else {
            if (this.entity != null && cls.isAssignableFrom(this.entity.getClass())) {
                this.lastEntity = this.entity;
                return this.castLastEntity();
            }
            if (entityStreamAvailable) {
                this.reportMessageHandlerProblem("NO_MSG_READER", cls, mediaType, null);
            }
        }
        throw new IllegalStateException("The entity is not backed by an input stream, entity class is : " + (this.entity != null ? this.entity.getClass().getName() : cls.getName()));
    }

    private <T> T castLastEntity() {
        return (T)this.lastEntity;
    }

    public InputStream convertEntityToStreamIfPossible() {
        String stringEntity = null;
        if (this.entity instanceof String || this.entity instanceof Number) {
            stringEntity = this.entity.toString();
        }
        if (stringEntity != null) {
            try {
                return new ByteArrayInputStream(stringEntity.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }
        return null;
    }

    private boolean entityStreamAvailable() {
        if (this.entity == null) {
            Message inMessage = this.getResponseMessage();
            return inMessage != null && (inMessage.getContent(XMLStreamReader.class) != null || inMessage.getContent(Reader.class) != null);
        }
        return this.entity instanceof InputStream;
    }

    private Message getResponseMessage() {
        Message responseMessage = this.outMessage.getExchange().getInMessage();
        if (responseMessage == null) {
            responseMessage = this.outMessage.getExchange().getInFaultMessage();
        }
        return responseMessage;
    }

    private void reportMessageHandlerProblem(String name, Class<?> cls, MediaType ct, Throwable cause) {
        String errorMessage = JAXRSUtils.logMessageHandlerProblem(name, cls, ct);
        throw new ResponseProcessingException(this, errorMessage, cause);
    }

    protected void autoClose(Class<?> cls, boolean exception) {
        if (!this.entityBufferred && !JAXRSUtils.isStreamingOutType(cls) && (exception || MessageUtils.getContextualBoolean(this.outMessage, "response.stream.auto.close"))) {
            this.close();
        }
    }

    @Override
    public boolean bufferEntity() throws ProcessingException {
        this.checkEntityIsClosed();
        if (!this.entityBufferred && this.entity instanceof InputStream) {
            try {
                InputStream oldEntity = (InputStream)this.entity;
                this.entity = IOUtils.loadIntoBAIS(oldEntity);
                oldEntity.close();
                this.entityBufferred = true;
            }
            catch (IOException ex) {
                throw new ResponseProcessingException((Response)this, (Throwable)ex);
            }
        }
        return this.entityBufferred;
    }

    @Override
    public void close() throws ProcessingException {
        if (!this.entityClosed) {
            if (!this.entityBufferred && this.entity instanceof InputStream) {
                try {
                    ((InputStream)this.entity).close();
                }
                catch (IOException ex) {
                    throw new ResponseProcessingException((Response)this, (Throwable)ex);
                }
            }
            this.entity = null;
            this.entityClosed = true;
        }
    }

    private void checkEntityIsClosed() {
        if (this.entityClosed) {
            throw new IllegalStateException("Entity is not available");
        }
    }

    private Response.StatusType createStatusType(final int statusCode, final String reasonPhrase) {
        return new Response.StatusType(){

            @Override
            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf(statusCode);
            }

            @Override
            public String getReasonPhrase() {
                if (reasonPhrase != null) {
                    return reasonPhrase;
                }
                Response.Status statusEnum = Response.Status.fromStatusCode(statusCode);
                return statusEnum != null ? statusEnum.getReasonPhrase() : "";
            }

            @Override
            public int getStatusCode() {
                return statusCode;
            }
        };
    }
}

