/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.nio;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.WriteListener;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.jaxrs.nio.NioWriteEntity;
import org.apache.cxf.jaxrs.nio.NioWriteListenerImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Provider
public class NioMessageBodyWriter
implements MessageBodyWriter<NioWriteEntity> {
    @Override
    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return NioWriteEntity.class.isAssignableFrom(cls) && this.getContinuationProvider() != null;
    }

    @Override
    public void writeTo(NioWriteEntity entity, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        Continuation cont = this.getContinuationProvider().getContinuation();
        NioWriteListenerImpl listener = new NioWriteListenerImpl(cont, entity, os);
        Message m = JAXRSUtils.getCurrentMessage();
        m.put(WriteListener.class, listener);
        cont.suspend(0L);
    }

    @Override
    public long getSize(NioWriteEntity t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    private ContinuationProvider getContinuationProvider() {
        return (ContinuationProvider)JAXRSUtils.getCurrentMessage().getExchange().getInMessage().get(ContinuationProvider.class.getName());
    }
}

