/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.ProxyClassLoader;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.ProtocolHeaders;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalContextResolver;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalInvocationHandler;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalMessageContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProtocolHeaders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProviders;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalRequest;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalSecurityContext;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalUriInfo;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXBUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ParameterizedCollectionType;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public final class InjectionUtils {
    public static final Set<String> STANDARD_CONTEXT_CLASSES = new HashSet<String>();
    public static final Set<String> VALUE_CONTEXTS = new HashSet<String>();
    private static final Logger LOG;
    private static final ResourceBundle BUNDLE;
    private static final String SERVLET_CONFIG_CLASS_NAME = "javax.servlet.ServletConfig";
    private static final String SERVLET_CONTEXT_CLASS_NAME = "javax.servlet.ServletContext";
    private static final String HTTP_SERVLET_REQUEST_CLASS_NAME = "javax.servlet.http.HttpServletRequest";
    private static final String HTTP_SERVLET_RESPONSE_CLASS_NAME = "javax.servlet.http.HttpServletResponse";
    private static final String ENUM_CONVERSION_CASE_SENSITIVE = "enum.conversion.case.sensitive";
    private static final String IGNORE_MATRIX_PARAMETERS = "ignore.matrix.parameters";

    private InjectionUtils() {
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) {
        if (cls == null || cls == Object.class) {
            return null;
        }
        Field f = ReflectionUtil.getDeclaredField(cls, fieldName);
        if (f != null) {
            return f;
        }
        return InjectionUtils.getDeclaredField(cls.getSuperclass(), fieldName);
    }

    public static boolean isConcreteClass(Class<?> cls) {
        return !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers());
    }

    private static ParameterizedType findGenericDeclaration(GenericDeclaration declaration, Type scope) {
        if (scope instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)scope;
            if (type.getRawType() == declaration) {
                return type;
            }
            scope = type.getRawType();
        }
        if (scope instanceof Class) {
            Class classScope = (Class)scope;
            ParameterizedType result = InjectionUtils.findGenericDeclaration(declaration, classScope.getGenericSuperclass());
            if (result == null) {
                Type type;
                Type[] typeArray = classScope.getGenericInterfaces();
                int n = typeArray.length;
                for (int i = 0; i < n && (result = InjectionUtils.findGenericDeclaration(declaration, type = typeArray[i])) == null; ++i) {
                }
            }
            return result;
        }
        return null;
    }

    public static Type getSuperType(Class<?> serviceClass, TypeVariable<?> var) {
        int pos;
        Object genericDeclaration = var.getGenericDeclaration();
        TypeVariable<?>[] vars = genericDeclaration.getTypeParameters();
        for (pos = 0; pos < vars.length && !vars[pos].getName().equals(var.getName()); ++pos) {
        }
        ParameterizedType genericSubtype = InjectionUtils.findGenericDeclaration(genericDeclaration, serviceClass);
        Type result = null;
        if (genericSubtype != null) {
            result = genericSubtype.getActualTypeArguments()[pos];
        }
        if (result instanceof TypeVariable) {
            result = InjectionUtils.getSuperType(serviceClass, (TypeVariable)result);
        }
        if (result == null || result == Object.class) {
            for (Type bound : var.getBounds()) {
                if (bound == Object.class) continue;
                result = bound;
                break;
            }
        }
        return result;
    }

    public static Method checkProxy(Method methodToInvoke, Object resourceObject) {
        if (Proxy.class.isInstance(resourceObject)) {
            String methodToInvokeName = methodToInvoke.getName();
            Class<?>[] methodToInvokeTypes = methodToInvoke.getParameterTypes();
            for (Class<?> c : resourceObject.getClass().getInterfaces()) {
                try {
                    return c.getMethod(methodToInvokeName, methodToInvokeTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (methodToInvokeTypes.length <= 0) continue;
                    for (Method m : c.getMethods()) {
                        if (!m.getName().equals(methodToInvokeName) || m.getParameterTypes().length != methodToInvokeTypes.length) continue;
                        Class<?>[] methodTypes = m.getParameterTypes();
                        for (int i = 0; i < methodTypes.length && methodTypes[i].isAssignableFrom(methodToInvokeTypes[i]); ++i) {
                        }
                        return m;
                    }
                }
            }
        }
        return methodToInvoke;
    }

    public static void injectFieldValue(final Field f, final Object o, final Object v) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    f.setAccessible(true);
                    f.set(o, v);
                }
                catch (IllegalAccessException ex) {
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                }
                return null;
            }
        });
    }

    public static Object extractFieldValue(final Field f, final Object o) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    f.setAccessible(true);
                    return f.get(o);
                }
                catch (IllegalAccessException ex) {
                    InjectionUtils.reportServerError("FIELD_ACCESS_FAILURE", f.getType().getName());
                    return null;
                }
            }
        });
    }

    public static Class<?> getActualType(Type genericType) {
        return InjectionUtils.getActualType(genericType, 0);
    }

    public static Class<?> getActualType(Type genericType, int pos) {
        if (genericType == null) {
            return null;
        }
        if (genericType == Object.class) {
            return (Class)genericType;
        }
        if (!ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            if (genericType instanceof TypeVariable) {
                genericType = InjectionUtils.getType(((TypeVariable)genericType).getBounds(), pos);
            } else if (genericType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)genericType;
                Type[] bounds = wildcardType.getLowerBounds();
                if (bounds.length == 0) {
                    bounds = wildcardType.getUpperBounds();
                }
                genericType = InjectionUtils.getType(bounds, pos);
            } else if (genericType instanceof GenericArrayType) {
                genericType = ((GenericArrayType)genericType).getGenericComponentType();
            }
            Class<Object> cls = null;
            cls = !(genericType instanceof ParameterizedType) ? (Class<?>)genericType : (Class)((ParameterizedType)genericType).getRawType();
            return cls.isArray() ? cls.getComponentType() : cls;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        Type t = InjectionUtils.getType(paramType.getActualTypeArguments(), pos);
        return t instanceof Class ? (Class<?>)t : InjectionUtils.getActualType(t, 0);
    }

    public static Type getType(Type[] types, int pos) {
        if (pos >= types.length) {
            throw new RuntimeException("No type can be found at position " + pos);
        }
        return types[pos];
    }

    public static Class<?> getRawType(Type genericType) {
        if (genericType instanceof Class) {
            return (Class)genericType;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type t = paramType.getRawType();
            if (t instanceof Class) {
                return (Class)t;
            }
        } else if (genericType instanceof GenericArrayType) {
            return InjectionUtils.getRawType(((GenericArrayType)genericType).getGenericComponentType());
        }
        return null;
    }

    public static Type[] getActualTypes(Type genericType) {
        if (genericType == null || !ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
            return null;
        }
        ParameterizedType paramType = (ParameterizedType)genericType;
        return paramType.getActualTypeArguments();
    }

    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue) {
        InjectionUtils.injectThroughMethod(requestObject, method, parameterValue, null);
    }

    public static void injectThroughMethod(Object requestObject, Method method, Object parameterValue, Message inMessage) {
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            methodToInvoke.invoke(requestObject, parameterValue);
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (InvocationTargetException ex) {
            Response r = JAXRSUtils.convertFaultToResponse(ex.getCause(), inMessage);
            if (r != null) {
                inMessage.getExchange().put(Response.class, r);
                throw new WebApplicationException();
            }
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName());
        }
    }

    public static Object extractFromMethod(Object requestObject, Method method) {
        return InjectionUtils.extractFromMethod(requestObject, method, true);
    }

    public static Object extractFromMethod(Object requestObject, Method method, boolean logError) {
        try {
            Method methodToInvoke = InjectionUtils.checkProxy(method, requestObject);
            return methodToInvoke.invoke(requestObject, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("METHOD_ACCESS_FAILURE", method.getName(), logError);
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("METHOD_INJECTION_FAILURE", method.getName(), logError);
        }
        return null;
    }

    public static <T> T handleParameter(String value, boolean decoded, Class<T> pClass, Type genericType, Annotation[] paramAnns, ParameterType pType, Message message) {
        if (value == null) {
            return null;
        }
        if (pType == ParameterType.PATH) {
            if (PathSegment.class.isAssignableFrom(pClass)) {
                return pClass.cast(new PathSegmentImpl(value, decoded));
            }
            if (!MessageUtils.getContextualBoolean(message, IGNORE_MATRIX_PARAMETERS)) {
                value = new PathSegmentImpl(value, false).getPath();
            }
        }
        value = InjectionUtils.decodeValue(value, decoded, pType);
        Object result = null;
        try {
            result = InjectionUtils.createFromParameterHandler(value, pClass, genericType, paramAnns, message);
        }
        catch (IllegalArgumentException nfe) {
            throw InjectionUtils.createParamConversionException(pType, nfe);
        }
        if (result != null) {
            Object theResult = null;
            theResult = pClass.isPrimitive() ? result : (Object)pClass.cast(result);
            return (T)theResult;
        }
        if (Number.class.isAssignableFrom(pClass) && "".equals(value)) {
            return null;
        }
        if (Boolean.class == pClass) {
            pClass = Boolean.TYPE;
        }
        if (pClass.isPrimitive()) {
            try {
                return (T)PrimitiveUtils.read(value, pClass);
            }
            catch (NumberFormatException nfe) {
                throw InjectionUtils.createParamConversionException(pType, nfe);
            }
        }
        boolean adapterHasToBeUsed = false;
        Class<Object> cls = pClass;
        Class<?> valueType = JAXBUtils.getValueTypeFromAdapter(pClass, pClass, paramAnns);
        if (valueType != cls) {
            cls = valueType;
            adapterHasToBeUsed = true;
        }
        if (pClass == String.class && !adapterHasToBeUsed) {
            return (T)pClass.cast(value);
        }
        try {
            Constructor<Object> c = cls.getConstructor(String.class);
            result = c.newInstance(value);
        }
        catch (NoSuchMethodException c) {
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Throwable t = InjectionUtils.getOrThrowActualException(ex);
            LOG.warning(new org.apache.cxf.common.i18n.Message("CLASS_CONSTRUCTOR_FAILURE", BUNDLE, pClass.getName()).toString());
            Response r = JAXRSUtils.toResponse(HttpUtils.getParameterFailureStatus(pType));
            throw ExceptionUtils.toHttpException(t, r);
        }
        if (result == null) {
            String[] stringArray;
            if (cls.isEnum()) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "fromString";
                stringArray2[1] = "fromValue";
                stringArray = stringArray2;
                stringArray2[2] = "valueOf";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "valueOf";
                stringArray = stringArray3;
                stringArray3[1] = "fromString";
            }
            String[] methodNames = stringArray;
            result = InjectionUtils.evaluateFactoryMethods(value, pType, result, cls, methodNames);
        }
        if (adapterHasToBeUsed) {
            String valueToReplace = result != null ? result : value;
            try {
                result = JAXBUtils.convertWithAdapter(valueToReplace, pClass, paramAnns);
            }
            catch (Throwable ex) {
                result = null;
            }
        }
        if (result == null) {
            InjectionUtils.reportServerError("WRONG_PARAMETER_TYPE", pClass.getName());
        }
        try {
            return (T)pClass.cast(result);
        }
        catch (ClassCastException ex) {
            InjectionUtils.reportServerError("WRONG_PARAMETER_TYPE", pClass.getName());
            return null;
        }
    }

    private static RuntimeException createParamConversionException(ParameterType pType, Exception ex) {
        if (pType == ParameterType.PATH || pType == ParameterType.QUERY || pType == ParameterType.MATRIX) {
            return ExceptionUtils.toNotFoundException(ex, null);
        }
        return ExceptionUtils.toBadRequestException(ex, null);
    }

    public static <T> T createFromParameterHandler(String value, Class<T> pClass, Type genericType, Annotation[] anns, Message message) {
        ServerProviderFactory pf;
        ParamConverter<T> pm;
        T result = null;
        if (message != null && (pm = (pf = ServerProviderFactory.getInstance(message)).createParameterHandler(pClass, genericType, anns, message)) != null) {
            result = pm.fromString(value);
        }
        return result;
    }

    public static void reportServerError(String messageName, String parameter) {
        InjectionUtils.reportServerError(messageName, parameter, true);
    }

    public static void reportServerError(String messageName, String parameter, boolean logError) {
        org.apache.cxf.common.i18n.Message errorMessage = new org.apache.cxf.common.i18n.Message(messageName, BUNDLE, parameter);
        if (logError) {
            LOG.severe(errorMessage.toString());
        }
        Response r = JAXRSUtils.toResponseBuilder(Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity(errorMessage.toString()).build();
        throw ExceptionUtils.toInternalServerErrorException(null, r);
    }

    private static Object evaluateFactoryMethods(String value, ParameterType pType, Object result, Class<?> cls, String[] methodNames) {
        Exception factoryMethodEx = null;
        for (String mName : methodNames) {
            try {
                result = InjectionUtils.evaluateFactoryMethod(value, cls, pType, mName);
                if (result == null) continue;
                factoryMethodEx = null;
            }
            catch (Exception ex) {
                factoryMethodEx = ex;
                if (!cls.isEnum()) break;
                if ("fromValue".equals(mName)) continue;
            }
            break;
        }
        if (factoryMethodEx != null) {
            Throwable t = InjectionUtils.getOrThrowActualException(factoryMethodEx);
            LOG.warning(new org.apache.cxf.common.i18n.Message("CLASS_VALUE_OF_FAILURE", BUNDLE, cls.getName()).toString());
            throw new WebApplicationException(t, HttpUtils.getParameterFailureStatus(pType));
        }
        return result;
    }

    private static <T> T evaluateFactoryMethod(String value, Class<T> pClass, ParameterType pType, String methodName) throws InvocationTargetException {
        try {
            Method m = pClass.getMethod(methodName, String.class);
            if (Modifier.isStatic(m.getModifiers())) {
                return pClass.cast(m.invoke(null, value));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    private static Throwable getOrThrowActualException(Throwable ex) {
        Throwable t;
        Throwable throwable = t = ex instanceof InvocationTargetException ? ((InvocationTargetException)ex).getCause() : ex;
        if (t instanceof WebApplicationException) {
            throw (WebApplicationException)t;
        }
        return t;
    }

    public static Object handleBean(Class<?> paramType, Annotation[] paramAnns, MultivaluedMap<String, String> values, ParameterType pType, Message message, boolean decoded) {
        String memberKey;
        Object bean = null;
        try {
            if (paramType.isInterface()) {
                paramType = JAXBUtils.getValueTypeFromAdapter(paramType, paramType, paramAnns);
            }
            bean = paramType.newInstance();
        }
        catch (IllegalAccessException ex) {
            InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", paramType.getName());
        }
        catch (Exception ex) {
            InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", paramType.getName());
        }
        HashMap parsedValues = new HashMap();
        for (Map.Entry entry : values.entrySet()) {
            memberKey = (String)entry.getKey();
            String beanKey = null;
            int idx = memberKey.indexOf(46);
            if (idx == -1) {
                beanKey = "." + memberKey;
            } else {
                beanKey = memberKey.substring(0, idx);
                memberKey = memberKey.substring(idx + 1);
            }
            MetadataMap value = (MetadataMap)parsedValues.get(beanKey);
            if (value == null) {
                value = new MetadataMap();
                parsedValues.put(beanKey, value);
            }
            value.put(memberKey, entry.getValue());
        }
        if (!parsedValues.isEmpty()) {
            for (Map.Entry entry : parsedValues.entrySet()) {
                boolean isbean;
                memberKey = (String)entry.getKey();
                boolean bl = isbean = !memberKey.startsWith(".");
                if (!isbean) {
                    memberKey = memberKey.substring(1);
                }
                AccessibleObject setter = null;
                AccessibleObject getter = null;
                for (Method method : paramType.getMethods()) {
                    if (method.getName().equalsIgnoreCase("set" + memberKey) && method.getParameterTypes().length == 1) {
                        setter = method;
                    } else if (method.getName().equalsIgnoreCase("get" + memberKey) || InjectionUtils.isBooleanType(method.getReturnType()) && method.getName().equalsIgnoreCase("is" + memberKey)) {
                        getter = method;
                    }
                    if (setter != null && getter != null) break;
                }
                if (setter == null) {
                    for (AccessibleObject accessibleObject : paramType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        setter = accessibleObject;
                        getter = accessibleObject;
                        break;
                    }
                }
                if (setter == null || getter == null) continue;
                Class<?> type = null;
                Type genericType = null;
                Object paramValue = null;
                if (setter instanceof Method) {
                    type = ((Method)Method.class.cast(setter)).getParameterTypes()[0];
                    genericType = ((Method)Method.class.cast(setter)).getGenericParameterTypes()[0];
                    paramValue = InjectionUtils.extractFromMethod(bean, (Method)getter);
                } else {
                    type = ((Field)Field.class.cast(setter)).getType();
                    genericType = ((Field)Field.class.cast(setter)).getGenericType();
                    paramValue = InjectionUtils.extractFieldValue((Field)getter, bean);
                }
                List<MultivaluedMap<String, String>> list = InjectionUtils.processValues(type, genericType, (MultivaluedMap)entry.getValue(), isbean);
                for (MultivaluedMap<String, String> processedValues : list) {
                    Object appendValue;
                    if (InjectionUtils.isSupportedCollectionOrArray(type)) {
                        appendValue = InjectionUtils.injectIntoCollectionOrArray(type, genericType, paramAnns, processedValues, isbean, true, pType, message);
                        paramValue = InjectionUtils.mergeCollectionsOrArrays(paramValue, appendValue, genericType);
                    } else if (InjectionUtils.isSupportedMap(genericType)) {
                        appendValue = InjectionUtils.injectIntoMap(type, genericType, paramAnns, processedValues, true, pType, message);
                        paramValue = InjectionUtils.mergeMap(paramValue, appendValue, genericType);
                    } else {
                        paramValue = isbean ? InjectionUtils.handleBean(type, paramAnns, processedValues, pType, message, decoded) : InjectionUtils.handleParameter((String)((List)processedValues.values().iterator().next()).get(0), decoded, type, type, paramAnns, pType, message);
                    }
                    if (paramValue == null) continue;
                    if (setter instanceof Method) {
                        InjectionUtils.injectThroughMethod(bean, setter, paramValue);
                        continue;
                    }
                    InjectionUtils.injectFieldValue((Field)setter, bean, paramValue);
                }
            }
        }
        return bean;
    }

    private static Object mergeMap(Object first, Object second, Type genericType) {
        if (first == null) {
            return second;
        }
        if (first instanceof Map) {
            ((Map)Map.class.cast(first)).putAll((Map)second);
            return first;
        }
        return null;
    }

    private static Object injectIntoMap(Class<?> rawType, Type genericType, Annotation[] paramAnns, MultivaluedMap<String, String> processedValues, boolean decoded, ParameterType pathParam, Message message) {
        ParameterizedType paramType = (ParameterizedType)genericType;
        Class keyType = (Class)paramType.getActualTypeArguments()[0];
        Type secondType = InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
        if (secondType instanceof ParameterizedType) {
            MetadataMap theValues = new MetadataMap();
            ParameterizedType valueParamType = (ParameterizedType)secondType;
            Class valueType = (Class)InjectionUtils.getType(valueParamType.getActualTypeArguments(), 0);
            for (Map.Entry processedValuesEntry : processedValues.entrySet()) {
                List valuesList = (List)processedValuesEntry.getValue();
                for (String value : valuesList) {
                    Object o = InjectionUtils.handleParameter(value, decoded, valueType, valueType, paramAnns, pathParam, message);
                    theValues.add(InjectionUtils.convertStringToPrimitive((String)processedValuesEntry.getKey(), keyType), o);
                }
            }
            return theValues;
        }
        HashMap theValues = new HashMap();
        Class valueType = (Class)InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
        for (Map.Entry processedValuesEntry : processedValues.entrySet()) {
            List valuesList = (List)processedValuesEntry.getValue();
            for (String value : valuesList) {
                Object o = InjectionUtils.handleParameter(value, decoded, valueType, valueType, paramAnns, pathParam, message);
                theValues.put(InjectionUtils.convertStringToPrimitive((String)processedValuesEntry.getKey(), keyType), o);
            }
        }
        return theValues;
    }

    private static boolean isSupportedMap(Type genericType) {
        ParameterizedType paramType;
        Class<?> rawType = InjectionUtils.getRawType(genericType);
        if (Map.class.isAssignableFrom(rawType) && genericType instanceof ParameterizedType && (paramType = (ParameterizedType)genericType).getActualTypeArguments().length == 2) {
            Class<?> firstType = InjectionUtils.getRawType(InjectionUtils.getType(paramType.getActualTypeArguments(), 0));
            Type secondType = InjectionUtils.getType(paramType.getActualTypeArguments(), 1);
            Class<?> secondRawType = InjectionUtils.getRawType(secondType);
            return InjectionUtils.isPrimitive(firstType) && (InjectionUtils.isPrimitive(secondRawType) || InjectionUtils.allowedMapListValue(secondRawType, secondType));
        }
        return false;
    }

    private static boolean allowedMapListValue(Class<?> cls, Type type) {
        if (List.class.isAssignableFrom(cls)) {
            Class<?> listtype = InjectionUtils.getRawType(InjectionUtils.getType(((ParameterizedType)type).getActualTypeArguments(), 0));
            return InjectionUtils.isPrimitive(listtype);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static List<MultivaluedMap<String, String>> processValues(Class<?> type, Type genericType, MultivaluedMap<String, String> values, boolean isbean) {
        ArrayList<MultivaluedMap<String, String>> valuesList = new ArrayList<MultivaluedMap<String, String>>();
        if (isbean && InjectionUtils.isSupportedCollectionOrArray(type)) {
            Class<?> realType = InjectionUtils.getActualType(genericType);
            for (Map.Entry entry : values.entrySet()) {
                String memberKey = (String)entry.getKey();
                Class<?> memberType = null;
                for (Method method : realType.getMethods()) {
                    if (!method.getName().equalsIgnoreCase("set" + memberKey) || method.getParameterTypes().length != 1) continue;
                    memberType = method.getParameterTypes()[0];
                    break;
                }
                if (memberType == null) {
                    for (AccessibleObject accessibleObject : realType.getFields()) {
                        if (!((Field)accessibleObject).getName().equalsIgnoreCase(memberKey)) continue;
                        memberType = ((Field)accessibleObject).getType();
                        break;
                    }
                }
                if (memberType != null && InjectionUtils.isSupportedCollectionOrArray(memberType)) continue;
                int idx = 0;
                for (String value : (List)entry.getValue()) {
                    void var13_21;
                    MultivaluedMap multivaluedMap;
                    MultivaluedMap multivaluedMap2 = multivaluedMap = idx < valuesList.size() ? (MultivaluedMap)valuesList.get(idx) : null;
                    if (multivaluedMap == null) {
                        MetadataMap metadataMap = new MetadataMap();
                        valuesList.add(metadataMap);
                    }
                    var13_21.add(memberKey, value);
                    ++idx;
                }
            }
        } else {
            valuesList.add(values);
        }
        return valuesList;
    }

    public static boolean isSupportedCollectionOrArray(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray();
    }

    private static Object mergeCollectionsOrArrays(Object first, Object second, Type genericType) {
        if (first == null) {
            return second;
        }
        if (first instanceof Collection) {
            ((Collection)Collection.class.cast(first)).addAll((Collection)second);
            return first;
        }
        int firstLen = Array.getLength(first);
        int secondLen = Array.getLength(second);
        Object mergedArray = Array.newInstance(InjectionUtils.getActualType(genericType), firstLen + secondLen);
        System.arraycopy(first, 0, mergedArray, 0, firstLen);
        System.arraycopy(second, 0, mergedArray, firstLen, secondLen);
        return mergedArray;
    }

    static Class<?> getCollectionType(Class<?> rawType) {
        Class type = null;
        if (SortedSet.class.isAssignableFrom(rawType)) {
            type = TreeSet.class;
        } else if (Set.class.isAssignableFrom(rawType)) {
            type = HashSet.class;
        } else if (Collection.class.isAssignableFrom(rawType)) {
            type = ArrayList.class;
        }
        return type;
    }

    private static Object injectIntoCollectionOrArray(Class<?> rawType, Type genericType, Annotation[] paramAnns, MultivaluedMap<String, String> values, boolean isbean, boolean decoded, ParameterType pathParam, Message message) {
        Class<?> type = InjectionUtils.getCollectionType(rawType);
        Class<?> realType = null;
        Type realGenericType = null;
        if (rawType.isArray()) {
            realGenericType = realType = rawType.getComponentType();
        } else {
            Type[] types = InjectionUtils.getActualTypes(genericType);
            if (types == null || types.length == 0 || !(types[0] instanceof ParameterizedType)) {
                realGenericType = realType = InjectionUtils.getActualType(genericType);
            } else {
                realType = InjectionUtils.getRawType(types[0]);
                realGenericType = types[0];
            }
        }
        Object theValues = null;
        if (type != null) {
            try {
                theValues = type.newInstance();
            }
            catch (IllegalAccessException ex) {
                InjectionUtils.reportServerError("CLASS_ACCESS_FAILURE", type.getName());
            }
            catch (Exception ex) {
                InjectionUtils.reportServerError("CLASS_INSTANTIATION_FAILURE", type.getName());
            }
        } else {
            theValues = Array.newInstance(realType, isbean ? 1 : ((List)values.values().iterator().next()).size());
        }
        if (isbean) {
            Object o = InjectionUtils.handleBean(realType, paramAnns, values, pathParam, message, decoded);
            InjectionUtils.addToCollectionValues(theValues, o, 0);
        } else {
            List<String> valuesList = (List<String>)values.values().iterator().next();
            valuesList = InjectionUtils.checkPathSegment(valuesList, realType, pathParam);
            for (int ind = 0; ind < valuesList.size(); ++ind) {
                Object o = InjectionUtils.handleParameter(valuesList.get(ind), decoded, realType, realGenericType, paramAnns, pathParam, message);
                InjectionUtils.addToCollectionValues(theValues, o, ind);
            }
        }
        return theValues;
    }

    private static void addToCollectionValues(Object theValues, Object o, int index) {
        if (o != null) {
            if (theValues instanceof Collection) {
                ((Collection)Collection.class.cast(theValues)).add(o);
            } else if (theValues.getClass().getComponentType().isPrimitive()) {
                Array.set(theValues, index, o);
            } else {
                ((Object[])theValues)[index] = o;
            }
        }
    }

    private static List<String> checkPathSegment(List<String> values, Class<?> type, ParameterType pathParam) {
        if (pathParam != ParameterType.PATH || !PathSegment.class.isAssignableFrom(type)) {
            return values;
        }
        ArrayList<String> newValues = new ArrayList<String>();
        for (String v : values) {
            String[] segments;
            for (String s : segments = StringUtils.split(v, "/")) {
                if (s.length() == 0) continue;
                newValues.add(s);
            }
            if (!v.endsWith("/")) continue;
            newValues.add("");
        }
        return newValues;
    }

    public static Object createParameterObject(List<String> paramValues, Class<?> paramType, Type genericType, Annotation[] paramAnns, String defaultValue, boolean decoded, ParameterType pathParam, Message message) {
        if (paramValues == null) {
            if (defaultValue != null) {
                paramValues = Collections.singletonList(defaultValue);
            } else if (paramType.isPrimitive()) {
                paramValues = Collections.singletonList(Boolean.TYPE == paramType ? "false" : (Character.TYPE == paramType ? Character.toString('\u0000') : "0"));
            } else if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
                paramValues = Collections.emptyList();
            } else {
                return null;
            }
        }
        Object value = null;
        if (InjectionUtils.isSupportedCollectionOrArray(paramType)) {
            MetadataMap<String, String> paramValuesMap = new MetadataMap<String, String>();
            paramValuesMap.put("", (String)((Object)paramValues));
            value = InjectionUtils.injectIntoCollectionOrArray(paramType, genericType, paramAnns, paramValuesMap, false, decoded, pathParam, message);
        } else {
            String result = null;
            if (!paramValues.isEmpty()) {
                boolean isLast = pathParam == ParameterType.PATH;
                String string = result = isLast ? paramValues.get(paramValues.size() - 1) : paramValues.get(0);
            }
            if (result != null) {
                value = InjectionUtils.handleParameter(result, decoded, paramType, genericType, paramAnns, pathParam, message);
            }
        }
        return value;
    }

    public static <T> ThreadLocalProxy<T> createThreadLocalProxy(Class<T> type) {
        ThreadLocalProxy<UriInfo> proxy = null;
        if (UriInfo.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalUriInfo();
        } else if (HttpHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalHttpHeaders();
        } else if (ProtocolHeaders.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProtocolHeaders();
        } else if (SecurityContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalSecurityContext();
        } else if (ContextResolver.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalContextResolver();
        } else if (Request.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalRequest();
        } else if (Providers.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalProviders();
        } else if (MessageContext.class.isAssignableFrom(type)) {
            proxy = new ThreadLocalMessageContext();
        }
        if (proxy == null && InjectionUtils.isServletApiContext(type.getName())) {
            proxy = InjectionUtils.createThreadLocalServletApiContext(type.getName());
        }
        if (proxy == null) {
            ProxyClassLoader loader = new ProxyClassLoader(Proxy.class.getClassLoader());
            loader.addLoader(type.getClassLoader());
            loader.addLoader(ThreadLocalProxy.class.getClassLoader());
            return (ThreadLocalProxy)Proxy.newProxyInstance(loader, new Class[]{type, ThreadLocalProxy.class}, new ThreadLocalInvocationHandler());
        }
        return proxy;
    }

    private static boolean isServletApiContext(String name) {
        return name.startsWith("javax.servlet.");
    }

    private static ThreadLocalProxy<?> createThreadLocalServletApiContext(String name) {
        String proxyClassName = null;
        if (HTTP_SERVLET_REQUEST_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletRequest";
        } else if (HTTP_SERVLET_RESPONSE_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalHttpServletResponse";
        } else if (SERVLET_CONTEXT_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletContext";
        } else if (SERVLET_CONFIG_CLASS_NAME.equals(name)) {
            proxyClassName = "org.apache.cxf.jaxrs.impl.tl.ThreadLocalServletConfig";
        }
        if (proxyClassName != null) {
            try {
                return (ThreadLocalProxy)ClassLoaderUtils.loadClass(proxyClassName, InjectionUtils.class).newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return null;
    }

    public static Method getGetterFromSetter(Method setter) throws Exception {
        return setter.getDeclaringClass().getMethod("get" + setter.getName().substring(3), new Class[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectContextProxiesAndApplication(AbstractResourceInfo cri, Object instance, Application app, ProviderFactory factory) {
        if (!cri.contextsAvailable() || !cri.isSingleton()) {
            return;
        }
        Object object = instance;
        synchronized (object) {
            for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
                Method method = entry.getValue();
                Object value = null;
                Class<?> cls = method.getParameterTypes()[0];
                if (cls == Application.class) {
                    value = app;
                } else if (VALUE_CONTEXTS.contains(cls.getName()) && factory != null) {
                    ContextProvider p = factory.createContextProvider(cls, null);
                    if (p != null) {
                        value = p.createContext(null);
                    }
                } else {
                    value = cri.getContextSetterProxy(method);
                }
                try {
                    if (value == InjectionUtils.extractFromMethod(instance, InjectionUtils.getGetterFromSetter(method), false)) {
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                InjectionUtils.injectThroughMethod(instance, method, value);
            }
            for (Field f : cri.getContextFields()) {
                Object value = null;
                Class<?> cls = f.getType();
                if (cls == Application.class) {
                    value = app;
                } else if (VALUE_CONTEXTS.contains(cls.getName()) && factory != null) {
                    ContextProvider p = factory.createContextProvider(cls, null);
                    if (p != null) {
                        value = p.createContext(null);
                    }
                } else {
                    value = cri.getContextFieldProxy(f);
                }
                try {
                    if (value == InjectionUtils.extractFieldValue(f, instance)) {
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                InjectionUtils.injectFieldValue(f, instance, value);
            }
        }
    }

    public static void injectContextProxies(AbstractResourceInfo cri, Object instance) {
        InjectionUtils.injectContextProxiesAndApplication(cri, instance, null, null);
    }

    public static void injectContextField(AbstractResourceInfo cri, Field f, Object o, Object value) {
        if (!cri.isSingleton()) {
            InjectionUtils.injectFieldValue(f, o, value);
        } else {
            ThreadLocalProxy<?> proxy = cri.getContextFieldProxy(f);
            if (proxy != null) {
                proxy.set(value);
            }
        }
    }

    public static void injectContexts(Object requestObject, AbstractResourceInfo resource, Message message) {
        if (resource.contextsAvailable()) {
            InjectionUtils.injectContextMethods(requestObject, resource, message);
            InjectionUtils.injectContextFields(requestObject, resource, message);
            InjectionUtils.injectConstructorProxies(requestObject, resource, message);
        }
    }

    public static void injectContextMethods(Object requestObject, AbstractResourceInfo cri, Message message) {
        for (Map.Entry<Class<?>, Method> entry : cri.getContextMethods().entrySet()) {
            Object o;
            Method method = entry.getValue();
            if (VALUE_CONTEXTS.contains(method.getParameterTypes()[0].getName()) && cri.isSingleton() || (o = JAXRSUtils.createContextValue(message, method.getGenericParameterTypes()[0], entry.getKey())) == null) continue;
            if (!cri.isSingleton()) {
                InjectionUtils.injectThroughMethod(requestObject, method, o, message);
                continue;
            }
            ThreadLocalProxy<?> proxy = cri.getContextSetterProxy(method);
            if (proxy == null) continue;
            proxy.set(o);
        }
    }

    public static void injectContextFields(Object o, AbstractResourceInfo cri, Message m) {
        for (Field f : cri.getContextFields()) {
            if (VALUE_CONTEXTS.contains(f.getType().getName()) && cri.isSingleton()) continue;
            Object value = JAXRSUtils.createContextValue(m, f.getGenericType(), f.getType());
            InjectionUtils.injectContextField(cri, f, o, value);
        }
    }

    public static void injectConstructorProxies(Object o, AbstractResourceInfo cri, Message m) {
        Map<Class<?>, ThreadLocalProxy<?>> proxies = cri.getConstructorProxies();
        if (proxies != null) {
            for (Map.Entry<Class<?>, ThreadLocalProxy<?>> entry : proxies.entrySet()) {
                Object value = JAXRSUtils.createContextValue(m, entry.getKey(), entry.getKey());
                entry.getValue().set(value);
            }
        }
    }

    public static MultivaluedMap<String, Object> extractValuesFromBean(Object bean, String baseName) {
        MetadataMap<String, Object> values = new MetadataMap<String, Object>();
        InjectionUtils.fillInValuesFromBean(bean, baseName, values);
        return values;
    }

    private static boolean isBooleanType(Class<?> cls) {
        return Boolean.TYPE == cls || Boolean.class == cls;
    }

    public static void fillInValuesFromBean(Object bean, String baseName, MultivaluedMap<String, Object> values) {
        for (Method m : bean.getClass().getMethods()) {
            Object value;
            String propertyName;
            int minLen;
            String methodName = m.getName();
            boolean startsFromGet = methodName.startsWith("get");
            if (!startsFromGet && (!InjectionUtils.isBooleanType(m.getReturnType()) || !methodName.startsWith("is")) || m.getParameterTypes().length != 0) continue;
            int n = minLen = startsFromGet ? 3 : 2;
            if (methodName.length() <= minLen || baseName.contains(propertyName = (propertyName = methodName.substring(minLen)).length() == 1 ? propertyName.toLowerCase() : propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1)) || "class".equals(propertyName) || "declaringClass".equals(propertyName)) continue;
            if (!"".equals(baseName)) {
                propertyName = baseName + "." + propertyName;
            }
            if ((value = InjectionUtils.extractFromMethod(bean, m)) == null) continue;
            if (InjectionUtils.isPrimitive(value.getClass()) || Date.class.isAssignableFrom(value.getClass())) {
                values.putSingle(propertyName, value);
                continue;
            }
            if (value.getClass().isEnum()) {
                values.putSingle(propertyName, value.toString());
                continue;
            }
            if (InjectionUtils.isSupportedCollectionOrArray(value.getClass())) {
                List<Object> theValues = null;
                theValues = value.getClass().isArray() ? Arrays.asList((Object[])value) : (value instanceof Set ? new ArrayList<Object>((Set)value) : CastUtils.cast((List)value));
                values.put(propertyName, theValues);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                if (!InjectionUtils.isSupportedMap(m.getGenericReturnType())) continue;
                Map map = CastUtils.cast((Map)value);
                for (Map.Entry entry : map.entrySet()) {
                    values.add(propertyName + "." + entry.getKey().toString(), entry.getValue().toString());
                }
                continue;
            }
            InjectionUtils.fillInValuesFromBean(value, propertyName, values);
        }
    }

    public static Map<Parameter, Class<?>> getParametersFromBeanClass(Class<?> beanClass, ParameterType type, boolean checkIgnorable) {
        LinkedHashMap params = new LinkedHashMap();
        for (Method m : beanClass.getMethods()) {
            int minLen;
            String methodName = m.getName();
            boolean startsFromGet = methodName.startsWith("get");
            if (!startsFromGet && (!InjectionUtils.isBooleanType(m.getReturnType()) || !methodName.startsWith("is")) || m.getParameterTypes().length != 0) continue;
            int n = minLen = startsFromGet ? 3 : 2;
            if (methodName.length() <= minLen) continue;
            String propertyName = StringUtils.uncapitalize(methodName.substring(minLen));
            if (m.getReturnType() == Class.class || checkIgnorable && InjectionUtils.canPropertyBeIgnored(m, propertyName)) continue;
            params.put(new Parameter(type, propertyName), m.getReturnType());
        }
        return params;
    }

    private static boolean canPropertyBeIgnored(Method m, String propertyName) {
        for (Annotation ann : m.getAnnotations()) {
            String annType = ann.annotationType().getName();
            if (!"org.apache.cxf.aegis.type.java5.IgnoreProperty".equals(annType) && !"javax.xml.bind.annotation.XmlTransient".equals(annType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return String.class == type || InjectionUtils.isPrimitiveOnly(type);
    }

    public static boolean isPrimitiveOnly(Class<?> type) {
        return type.isPrimitive() || Number.class.isAssignableFrom(type) || Boolean.class == type || Character.class == type;
    }

    public static String decodeValue(String value, boolean decode, ParameterType param) {
        if (!decode) {
            return value;
        }
        if (param == ParameterType.PATH || param == ParameterType.MATRIX) {
            return HttpUtils.pathDecode(value);
        }
        return HttpUtils.urlDecode(value);
    }

    public static void invokeLifeCycleMethod(Object instance, Method method) {
        if (method != null) {
            method = InjectionUtils.checkProxy(method, instance);
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                String msg = "Method " + method.getName() + " can not be invoked due to InvocationTargetException";
                throw new WebApplicationException(JAXRSUtils.toResponseBuilder(500).entity(msg).build());
            }
            catch (IllegalAccessException ex) {
                String msg = "Method " + method.getName() + " can not be invoked due to IllegalAccessException";
                throw ExceptionUtils.toInternalServerErrorException(ex, JAXRSUtils.toResponseBuilder(500).entity(msg).build());
            }
        }
    }

    public static Object convertStringToPrimitive(String value, Class<?> cls) {
        return InjectionUtils.convertStringToPrimitive(value, cls, new Annotation[0]);
    }

    public static Object convertStringToPrimitive(String value, Class<?> cls, Annotation[] anns) {
        Message m = JAXRSUtils.getCurrentMessage();
        Object obj = InjectionUtils.createFromParameterHandler(value, cls, cls, anns, m);
        if (obj != null) {
            return obj;
        }
        if (String.class == cls) {
            return value;
        }
        if (cls.isPrimitive()) {
            return PrimitiveUtils.read(value, cls);
        }
        if (cls.isEnum()) {
            if (m != null && !MessageUtils.getContextualBoolean(m, ENUM_CONVERSION_CASE_SENSITIVE, false)) {
                obj = InjectionUtils.invokeValueOf(value.toUpperCase(), cls);
            }
            if (obj == null) {
                try {
                    obj = InjectionUtils.invokeValueOf(value, cls);
                }
                catch (RuntimeException ex) {
                    if (m == null) {
                        obj = InjectionUtils.invokeValueOf(value.toUpperCase(), cls);
                    }
                    throw ex;
                }
            }
            return obj;
        }
        try {
            Constructor<?> c = cls.getConstructor(String.class);
            return c.newInstance(value);
        }
        catch (Throwable throwable) {
            return InjectionUtils.invokeValueOf(value, cls);
        }
    }

    private static Object invokeValueOf(String value, Class<?> cls) {
        try {
            Method m = cls.getMethod("valueOf", String.class);
            return m.invoke(null, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getRawResponseClass(Object targetObject) {
        if (targetObject != null) {
            Class<?> targetClass = targetObject.getClass();
            return ClassHelper.getRealClassFromClass(targetClass);
        }
        return null;
    }

    public static Type getGenericResponseType(Method invoked, Class<?> serviceCls, Object targetObject, Class<?> targetType, Exchange exchange) {
        if (targetObject == null) {
            return null;
        }
        Type type = null;
        type = GenericEntity.class.isAssignableFrom(targetObject.getClass()) ? InjectionUtils.processGenericTypeIfNeeded(serviceCls, targetType, ((GenericEntity)targetObject).getType()) : (invoked == null || !invoked.getReturnType().isAssignableFrom(targetType) ? targetObject.getClass() : InjectionUtils.processGenericTypeIfNeeded(serviceCls, targetType, invoked.getGenericReturnType()));
        return type;
    }

    public static Class<?> updateParamClassToTypeIfNeeded(Class<?> paramCls, Type type) {
        Class clsType;
        if (paramCls != type && type instanceof Class && (paramCls.isAssignableFrom(clsType = (Class)type) || clsType != Object.class && !clsType.isInterface() && clsType.isAssignableFrom(paramCls))) {
            paramCls = clsType;
        }
        return paramCls;
    }

    public static Type processGenericTypeIfNeeded(Class<?> serviceCls, Class<?> paramCls, Type type) {
        ParameterizedType pt;
        if (type instanceof TypeVariable) {
            type = InjectionUtils.getSuperType(serviceCls, (TypeVariable)type);
        } else if (type instanceof ParameterizedType && (pt = (ParameterizedType)type).getActualTypeArguments()[0] instanceof TypeVariable && InjectionUtils.isSupportedCollectionOrArray(InjectionUtils.getRawType(pt))) {
            TypeVariable typeVar = (TypeVariable)pt.getActualTypeArguments()[0];
            Type theType = InjectionUtils.getSuperType(serviceCls, typeVar);
            if (theType instanceof Class) {
                type = new ParameterizedCollectionType((Class)theType);
            } else {
                type = InjectionUtils.processGenericTypeIfNeeded(serviceCls, paramCls, theType);
                type = new ParameterizedCollectionType(type);
            }
        }
        if (type == null || type == Object.class) {
            type = paramCls;
        }
        return type;
    }

    public static Object getEntity(Object o) {
        return o instanceof GenericEntity ? ((GenericEntity)o).getEntity() : o;
    }

    static {
        STANDARD_CONTEXT_CLASSES.add(Application.class.getName());
        STANDARD_CONTEXT_CLASSES.add(UriInfo.class.getName());
        STANDARD_CONTEXT_CLASSES.add(HttpHeaders.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Request.class.getName());
        STANDARD_CONTEXT_CLASSES.add(SecurityContext.class.getName());
        STANDARD_CONTEXT_CLASSES.add(Providers.class.getName());
        STANDARD_CONTEXT_CLASSES.add(ContextResolver.class.getName());
        STANDARD_CONTEXT_CLASSES.add(HTTP_SERVLET_REQUEST_CLASS_NAME);
        STANDARD_CONTEXT_CLASSES.add(HTTP_SERVLET_RESPONSE_CLASS_NAME);
        STANDARD_CONTEXT_CLASSES.add(SERVLET_CONTEXT_CLASS_NAME);
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceContext");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.container.ResourceInfo");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.core.Configuration");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.sse.Sse");
        STANDARD_CONTEXT_CLASSES.add("javax.ws.rs.sse.SseEventSink");
        VALUE_CONTEXTS.add(Application.class.getName());
        VALUE_CONTEXTS.add("javax.ws.rs.sse.Sse");
        LOG = LogUtils.getL7dLogger(InjectionUtils.class);
        BUNDLE = BundleUtils.getBundle(InjectionUtils.class);
    }
}

