/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.BeanScope;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="bean")
public class BeanComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(BeanComponent.class);
    private final Map<BeanInfoCacheKey, BeanInfo> beanInfoCache = LRUCacheFactory.newLRUSoftCache(1000);
    @Deprecated
    @Metadata(defaultValue="true", description="Use singleton option instead.")
    private Boolean cache;
    @Metadata(defaultValue="Singleton", description="Scope of bean. When using singleton scope (default) the bean is created or looked up only once and reused for the lifetime of the endpoint. The bean should be thread-safe in case concurrent threads is calling the bean at the same time. When using request scope the bean is created or looked up once per request (exchange). This can be used if you want to store state on a bean while processing a request and you want to call the same bean instance multiple times while processing the request. The bean does not have to be thread-safe as the instance is only called from the same request. When using delegate scope, then the bean will be looked up or created per call. However in case of lookup then this is delegated  to the bean registry such as Spring or CDI (if in use), which depends on their configuration can act as either singleton or prototype scope. so when using prototype then this depends on the delegated registry.")
    private BeanScope scope = BeanScope.Singleton;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanEndpoint endpoint = new BeanEndpoint(uri, this);
        endpoint.setBeanName(remaining);
        if (this.cache != null) {
            endpoint.setCache(this.cache);
        }
        endpoint.setScope(this.scope);
        this.setProperties(endpoint, parameters);
        Map<String, Object> options = PropertiesHelper.extractProperties(parameters, "bean.");
        endpoint.setParameters(options);
        return endpoint;
    }

    BeanInfo getBeanInfoFromCache(BeanInfoCacheKey key) {
        return this.beanInfoCache.get(key);
    }

    void addBeanInfoToCache(BeanInfoCacheKey key, BeanInfo beanInfo) {
        this.beanInfoCache.put(key, beanInfo);
    }

    @Override
    protected void doShutdown() throws Exception {
        if (LOG.isDebugEnabled() && this.beanInfoCache instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.beanInfoCache;
            LOG.debug("Clearing BeanInfo cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
        }
        this.beanInfoCache.clear();
    }

    @Deprecated
    public Boolean getCache() {
        return this.scope == BeanScope.Singleton;
    }

    @Deprecated
    public void setCache(Boolean cache) {
        this.scope = Boolean.TRUE.equals(cache) ? BeanScope.Singleton : BeanScope.Prototype;
    }

    public BeanScope getScope() {
        return this.scope;
    }

    public void setScope(BeanScope scope) {
        this.scope = scope;
    }
}

