/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import java.util.Set;
import org.apache.camel.BeanScope;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantStaticTypeBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.component.bean.ParameterMappingStrategyHelper;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.component.bean.RequestBeanHolder;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="bean-processor-factory")
public final class DefaultBeanProcessorFactory
extends ServiceSupport
implements BeanProcessorFactory,
CamelContextAware,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanProcessorFactory.class);
    private CamelContext camelContext;
    private ParameterMappingStrategy parameterMappingStrategy;
    private BeanComponent beanComponent;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Processor createBeanProcessor(CamelContext camelContext, Object bean, Method method) throws Exception {
        BeanInfo info = new BeanInfo(camelContext, method, this.parameterMappingStrategy, this.beanComponent);
        return new BeanProcessor(bean, info);
    }

    @Override
    public Processor createBeanProcessor(CamelContext camelContext, Object bean, String beanType, Class<?> beanClass, String ref, String method, BeanScope scope) throws Exception {
        BeanProcessor answer;
        BeanHolder beanHolder;
        Class<?> clazz;
        Class<?> clazz2 = clazz = bean != null ? bean.getClass() : null;
        if (ObjectHelper.isNotEmpty(ref)) {
            if (scope == BeanScope.Singleton) {
                beanHolder = new RegistryBean(camelContext, ref, this.parameterMappingStrategy, this.beanComponent).createCacheHolder();
                bean = beanHolder.getBean(null);
            } else {
                beanHolder = new RegistryBean(camelContext, ref, this.parameterMappingStrategy, this.beanComponent);
            }
            if (scope == BeanScope.Request) {
                beanHolder = new RequestBeanHolder(beanHolder);
            }
            answer = new BeanProcessor(beanHolder);
        } else {
            if (bean == null) {
                Set<?> beans;
                if (beanType == null && beanClass == null) {
                    throw new IllegalArgumentException("bean, ref or beanType must be provided");
                }
                if (beanType != null) {
                    try {
                        clazz = camelContext.getClassResolver().resolveMandatoryClass(beanType);
                    }
                    catch (ClassNotFoundException e) {
                        throw RuntimeCamelException.wrapRuntimeCamelException(e);
                    }
                } else {
                    clazz = beanClass;
                }
                if (scope == BeanScope.Singleton && clazz != null && !(beans = camelContext.getRegistry().findByType(clazz)).isEmpty()) {
                    if (beans.size() == 1) {
                        LOG.debug("Exactly one instance of type: {} in registry found.", clazz);
                        bean = beans.iterator().next();
                    } else {
                        LOG.debug("Found {} bean instances of type: {} in the registry.", (Object)beans.size(), clazz);
                    }
                }
                if (bean == null && scope == BeanScope.Singleton && camelContext.getInjector().supportsAutoWiring()) {
                    try {
                        LOG.debug("Attempting to create new bean instance from class: {} via auto-wiring enabled", clazz);
                        bean = CamelContextHelper.newInstance(camelContext, clazz);
                    }
                    catch (Exception e) {
                        LOG.debug("Error creating new bean instance from class: {}. This exception is ignored", clazz, (Object)e);
                    }
                }
                if (bean == null && scope == BeanScope.Singleton && ObjectHelper.hasDefaultPublicNoArgConstructor(clazz)) {
                    LOG.debug("Class has default no-arg constructor so creating a new bean instance: {}", clazz);
                    bean = CamelContextHelper.newInstance(camelContext, clazz);
                    ObjectHelper.notNull(bean, "bean", this);
                }
            }
            if (bean instanceof String) {
                throw new IllegalArgumentException("The bean instance is a java.lang.String type: " + bean + ". We suppose you want to refer to a bean instance by its id instead. Please use ref.");
            }
            if (bean != null) {
                beanHolder = new ConstantBeanHolder(bean, camelContext, this.parameterMappingStrategy, this.beanComponent);
            } else if (scope == BeanScope.Singleton && ObjectHelper.hasDefaultPublicNoArgConstructor(clazz)) {
                beanHolder = new ConstantTypeBeanHolder(clazz, camelContext, this.parameterMappingStrategy, this.beanComponent).createCacheHolder();
            } else if (ObjectHelper.hasDefaultPublicNoArgConstructor(clazz)) {
                beanHolder = new ConstantTypeBeanHolder(clazz, camelContext, this.parameterMappingStrategy, this.beanComponent);
            } else {
                if (clazz.isInterface()) {
                    throw new IllegalArgumentException("The bean is an interface type: " + clazz + ". Interfaces are only supported to lookup in the Camel registry for a single instance of such type. Otherwise the bean must be a class type.");
                }
                beanHolder = new ConstantStaticTypeBeanHolder(clazz, camelContext, this.parameterMappingStrategy, this.beanComponent);
            }
            if (scope == BeanScope.Request) {
                beanHolder = new RequestBeanHolder(beanHolder);
            }
            answer = new BeanProcessor(beanHolder);
        }
        if (method != null) {
            answer.setMethod(method);
            if (scope == BeanScope.Singleton) {
                BeanInfo beanInfo = beanHolder.getBeanInfo();
                if (bean != null) {
                    if (!beanInfo.hasMethod(method)) {
                        throw RuntimeCamelException.wrapRuntimeCamelException(new MethodNotFoundException(null, bean, method));
                    }
                } else if (clazz != null && !beanInfo.hasStaticMethod(method)) {
                    throw RuntimeCamelException.wrapRuntimeCamelException(new MethodNotFoundException(null, clazz, method, true));
                }
            }
        }
        return answer;
    }

    @Override
    protected void doInit() throws Exception {
        this.parameterMappingStrategy = ParameterMappingStrategyHelper.createParameterMappingStrategy(this.getCamelContext());
        this.beanComponent = this.getCamelContext().getComponent("bean", BeanComponent.class);
    }
}

