/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.directvm.DirectVmConsumer;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectVmBlockingProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectVmBlockingProducer.class);
    private final DirectVmEndpoint endpoint;

    public DirectVmBlockingProducer(DirectVmEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.getConsumer(exchange).getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.getConsumer(exchange).getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected DirectVmConsumer getConsumer(Exchange exchange) throws Exception {
        DirectVmConsumer answer = this.endpoint.getConsumer();
        if (answer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
            answer = this.awaitConsumer();
            if (answer == null) {
                throw new DirectVmConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
        }
        return answer;
    }

    private DirectVmConsumer awaitConsumer() {
        ForegroundTask task = Tasks.foregroundTask().withBudget(Budgets.iterationTimeBudget().withMaxIterations(-1).withMaxDuration(Duration.ofMillis(this.endpoint.getTimeout())).withInterval(Duration.ofMillis(500L)).build()).build();
        StopWatch watch = new StopWatch();
        DirectVmConsumer answer = task.run(this.endpoint::getConsumer, a -> a != null).orElse(null);
        LOG.debug("Waited {} for consumer to be ready", (Object)watch.taken());
        return answer;
    }
}

