/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.log.LogEndpoint;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="log")
public class LogComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(LogComponent.class);
    private ExchangeFormatter defaultExchangeFormatter;
    @Metadata(label="advanced", autowired=true)
    private ExchangeFormatter exchangeFormatter;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ExchangeFormatter logFormatter;
        LoggingLevel level = this.getLoggingLevel(parameters);
        Logger providedLogger = this.getLogger(parameters);
        if (providedLogger == null) {
            Map<String, Logger> availableLoggers = this.getCamelContext().getRegistry().findByTypeWithName(Logger.class);
            if (availableLoggers.size() == 1) {
                providedLogger = availableLoggers.values().iterator().next();
                LOG.info("Using custom Logger: {}", (Object)providedLogger);
            } else if (availableLoggers.size() > 1) {
                LOG.info("More than one {} instance found in the registry. Falling back to creating logger from URI {}.", (Object)Logger.class.getName(), (Object)uri);
            }
        }
        if ((logFormatter = this.getCamelContext().getRegistry().lookupByNameAndType("logFormatter", ExchangeFormatter.class)) != null) {
            this.setProperties(logFormatter, parameters);
        } else if (this.exchangeFormatter != null) {
            logFormatter = this.exchangeFormatter;
        }
        LogEndpoint endpoint = new LogEndpoint(uri, this);
        endpoint.setLevel(level.name());
        endpoint.setExchangeFormatter(logFormatter);
        if (providedLogger == null) {
            endpoint.setLoggerName(remaining);
        } else {
            endpoint.setProvidedLogger(providedLogger);
        }
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    protected LoggingLevel getLoggingLevel(Map<String, Object> parameters) {
        String levelText = this.getAndRemoveParameter(parameters, "level", String.class);
        if (levelText != null) {
            return LoggingLevel.valueOf(levelText.toUpperCase(Locale.ENGLISH));
        }
        return LoggingLevel.INFO;
    }

    protected Logger getLogger(Map<String, Object> parameters) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, "logger", Logger.class);
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }

    public ExchangeFormatter getDefaultExchangeFormatter() {
        return this.defaultExchangeFormatter;
    }

    @Override
    protected void doInit() throws Exception {
        DefaultExchangeFormatter def = new DefaultExchangeFormatter();
        def.setShowExchangePattern(true);
        def.setSkipBodyLineSeparator(true);
        def.setShowBody(true);
        def.setShowBodyType(true);
        def.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
        def.setMaxChars(10000);
        this.defaultExchangeFormatter = def;
    }
}

