/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.camel.BinaryPredicate;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.mock.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeClause
implements BinaryPredicate {
    private static final Logger LOG = LoggerFactory.getLogger(TimeClause.class);
    private final Expression left;
    private final Expression right;
    private Time timeFrom;
    private Time timeTo;
    private boolean beforeNext;
    private String was;

    public TimeClause(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public TimeClassUnit noLaterThan(int period) {
        TimeClassUnit unit = new TimeClassUnit(this, period);
        return unit;
    }

    public TimeClassUnit between(int from, int to) {
        TimeClassUnit unit = new TimeClassUnit(this, from, to);
        return unit;
    }

    public void beforeNext() {
        this.beforeNext = true;
    }

    public void afterPrevious() {
        this.beforeNext = false;
    }

    @Override
    public Expression getLeft() {
        return this.left;
    }

    @Override
    public Expression getRight() {
        return this.right;
    }

    @Override
    public boolean matches(Exchange exchange) {
        return this.matchesReturningFailureMessage(exchange) == null;
    }

    @Override
    public String matchesReturningFailureMessage(Exchange exchange) {
        Object rightValue;
        String answer = null;
        Object leftValue = this.left.evaluate(exchange, Object.class);
        if (!this.matches(exchange, leftValue, rightValue = this.right.evaluate(exchange, Object.class))) {
            answer = leftValue + " " + this.getOperator() + " " + rightValue;
        }
        return answer;
    }

    protected boolean matches(Exchange exchange, Object leftValue, Object rightValue) {
        this.was = null;
        boolean answer = true;
        if (this.timeTo == null) {
            throw new IllegalArgumentException("The time period has not been set. Ensure to include the time unit as well.");
        }
        Date currentDate = exchange.getProperty("CamelReceivedTimestamp", Date.class);
        Date otherDate = this.beforeNext ? (leftValue != null ? (Date)leftValue : (Date)rightValue) : (rightValue != null ? (Date)rightValue : (Date)leftValue);
        if (otherDate == null) {
            return true;
        }
        Time current = new Time(currentDate.getTime(), TimeUnit.MILLISECONDS);
        Time other = new Time(otherDate.getTime(), TimeUnit.MILLISECONDS);
        long delta = Math.abs(other.toMillis() - current.toMillis());
        this.was = "delta: " + delta + " millis";
        if (this.timeFrom != null) {
            long from = this.timeFrom.toMillis();
            boolean bl = answer = delta >= from;
        }
        if (answer) {
            long to = this.timeTo.toMillis();
            boolean bl = answer = delta <= to;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evaluated time clause [{}] with current: {}, other: {} -> {}", new Object[]{this.toString(), currentDate, otherDate, answer});
        }
        return answer;
    }

    @Override
    public String getOperator() {
        return this.getOperationText();
    }

    protected String getOperationText() {
        return this.beforeNext ? "before next" : "after previous";
    }

    public String toString() {
        if (this.timeFrom == null) {
            return "no later than " + this.timeTo + " " + this.getOperationText() + " (" + this.was + ")";
        }
        return "between " + this.timeFrom.getNumber() + "-" + this.timeTo.getNumber() + " " + this.timeTo.getTimeUnit().toString().toLowerCase(Locale.ENGLISH) + " " + this.getOperationText() + " (" + this.was + ")";
    }

    public class TimeClassUnit {
        private final TimeClause clause;
        private int from;
        private int to;

        public TimeClassUnit(TimeClause clause, int to) {
            this(clause, -1, to);
        }

        public TimeClassUnit(TimeClause clause, int from, int to) {
            this.clause = clause;
            this.from = from;
            this.to = to;
        }

        public TimeClause millis() {
            this.period(TimeUnit.MILLISECONDS);
            return this.clause;
        }

        public TimeClause seconds() {
            this.period(TimeUnit.SECONDS);
            return this.clause;
        }

        public TimeClause minutes() {
            this.period(TimeUnit.MINUTES);
            return this.clause;
        }

        private void period(TimeUnit unit) {
            if (this.from > 0) {
                TimeClause.this.timeFrom = new Time(this.from, unit);
            }
            TimeClause.this.timeTo = new Time(this.to, unit);
        }
    }
}

